/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.cdt.core.refactoring;

import com.nxp.s32ds.ext.ide.core.refactoring.RefactoringParticipant;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ActiveConfigurationKeeper
implements RefactoringParticipant {
    public IStatus apply(IProject target, IProject source, String search, String replace, IProgressMonitor monitor) {
        return ActiveConfigurationKeeper.updateActiveConfiguration(target, source);
    }

    private static IStatus updateActiveConfiguration(IProject target, IProject source) {
        ICProjectDescription sourceDescription = ActiveConfigurationKeeper.getProjectDescription(source);
        ICProjectDescription targetDescription = ActiveConfigurationKeeper.getProjectDescription(target);
        if (sourceDescription != null && targetDescription != null) {
            String currentActiveCfgName;
            String sourceActiveCfgName = ActiveConfigurationKeeper.getActiveConfigurationName(sourceDescription);
            if (sourceActiveCfgName.equals(currentActiveCfgName = ActiveConfigurationKeeper.getActiveConfigurationName(targetDescription))) {
                return Status.OK_STATUS;
            }
            try {
                ActiveConfigurationKeeper.updateActiveConfiguration(target, targetDescription, sourceActiveCfgName);
            }
            catch (CoreException e) {
                return e.getStatus();
            }
        }
        return Status.OK_STATUS;
    }

    private static String getActiveConfigurationName(ICProjectDescription projectDescription) {
        return projectDescription.getActiveConfiguration().getName();
    }

    private static ICProjectDescription getProjectDescription(IProject project) {
        return CoreModel.getDefault().getProjectDescription(project, true);
    }

    private static void updateActiveConfiguration(IProject tgtProject, ICProjectDescription tgtProjectDescription, String cfgName) throws CoreException {
        ICConfigurationDescription cfg = tgtProjectDescription.getConfigurationByName(cfgName);
        tgtProjectDescription.setActiveConfiguration(cfg);
        CoreModel.getDefault().setProjectDescription(tgtProject, tgtProjectDescription);
    }
}

