/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.ide.software.manager.internal.registry.core.implementation;

import com.nxp.s32ds.cle.ide.software.manager.internal.marker.SoftwareManifestMarker;
import com.nxp.s32ds.cle.ide.software.manager.internal.registry.core.SoftwareManagerActivator;
import com.nxp.s32ds.cle.ide.software.manager.registry.core.SoftwareManagerMessages;
import com.nxp.s32ds.cle.runtime.software.manager.SoftwareManifestFilesManager;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.osgi.service.prefs.Preferences;

public class SoftwareManifestFilesManagerImplementation
implements SoftwareManifestFilesManager {
    private IWorkspaceRoot workspaceRoot;
    private final Set<String> softwareDescriptorsLocations;

    public SoftwareManifestFilesManagerImplementation(IWorkspaceRoot workspaceRoot, Set<String> softwareDescriptorsLocations) {
        this.workspaceRoot = workspaceRoot;
        this.softwareDescriptorsLocations = softwareDescriptorsLocations;
    }

    public void fileNotExistsErrorHandling(String missingFile) {
        SoftwareManifestMarker.createMarker((IResource)this.workspaceRoot, missingFile, SoftwareManagerMessages.bind((String)SoftwareManagerMessages.SoftwareManagerJob_SoftwareManifestNotFoundByPath, (Object)missingFile.toString()));
    }

    public Set<String> getCurrentFilesLocation() {
        return this.softwareDescriptorsLocations;
    }

    public String getMD5Properties() {
        return SoftwareManagerActivator.getInstance().getConfigurationScopePreferences().get("storedSoftwareFilesMD5", "");
    }

    public void storeMD5SumPropirties(String prefsString) {
        Preferences configurationScopePreferences = SoftwareManagerActivator.getInstance().getConfigurationScopePreferences();
        configurationScopePreferences.put("storedSoftwareFilesMD5", prefsString);
        SoftwareManagerActivator.getInstance().savePreferences();
    }

    public void stringSubstitutionErrorHandling(String errorMessage) {
        SoftwareManagerActivator.getInstance().logError(errorMessage);
    }
}

