/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cdt.svd.internal.ui.view.action;

import com.nxp.s32ds.cdt.svd.internal.ui.view.action.SvdActionBase;
import com.nxp.s32ds.cdt.svd.internal.ui.view.action.SvdVisible;
import com.nxp.s32ds.cdt.svd.internal.ui.view.watch.SvdWatchTreeViewer;
import com.nxp.s32ds.cdt.svd.model.SvdField;
import com.nxp.s32ds.cdt.svd.model.SvdRegister;
import com.nxp.s32ds.cdt.svd.model.watch.SvdCompositeWatchModel;
import com.nxp.s32ds.cdt.svd.model.watch.SvdWatchContext;
import com.nxp.s32ds.cdt.svd.model.watch.SvdWatchContextManager;
import com.nxp.s32ds.cdt.svd.parser.model.AccessType;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.jface.viewers.IStructuredSelection;

public abstract class SvdContextAction
extends SvdActionBase<SvdWatchTreeViewer>
implements SvdVisible {
    private boolean visible;

    public SvdContextAction(SvdWatchTreeViewer viewer) {
        super(viewer);
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Override
    public void update() {
        this.setVisible(false);
        super.update();
        if (!this.isEnabled()) {
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)((SvdWatchTreeViewer)this.viewer).getSelection();
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof SvdField) {
                return;
            }
            ++n2;
        }
        Set<SvdRegister> registers = SvdContextAction.getRegisters(selection);
        if (registers.isEmpty()) {
            return;
        }
        SvdWatchContextManager contextManager = this.getWatchContextManager();
        boolean hasValidContext = registers.stream().map(r -> contextManager.getContext(r)).filter(c -> this.isContextValid((SvdWatchContext)c)).findAny().isPresent();
        if (!hasValidContext) {
            return;
        }
        this.setVisible(true);
        List writeOnlyRegisters = registers.stream().map(r -> r.getAccessType()).filter(t -> t == AccessType.WRITE_ONCE || t == AccessType.WRITE_ONLY).collect(Collectors.toList());
        if (registers.size() == writeOnlyRegisters.size()) {
            this.setEnabled(false);
        }
    }

    protected SvdWatchContextManager getWatchContextManager() {
        SvdCompositeWatchModel model = (SvdCompositeWatchModel)((SvdWatchTreeViewer)this.viewer).getInput().model;
        SvdWatchContextManager contextManager = model.getContextManager();
        return contextManager;
    }

    protected DsfSession getSession() {
        return ((SvdWatchTreeViewer)this.viewer).getInput().launch.getSession();
    }

    protected abstract boolean isContextValid(SvdWatchContext var1);
}

