/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cdt.svd.internal.ui.view.memento;

import com.nxp.s32ds.cdt.svd.internal.ui.CdtSvdUiActivator;
import com.nxp.s32ds.cdt.svd.internal.ui.Messages;
import com.nxp.s32ds.cdt.svd.internal.ui.view.SvdTreeViewerBase;
import com.nxp.s32ds.cdt.svd.internal.ui.view.memento.SvdMementos;
import com.nxp.s32ds.ext.orbit.strings.SeparatedStrings;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IMemento;

public class SvdTreeViewerMemento
extends SvdMementos<SvdTreeViewerBase> {
    private static final String ORDER = "order";
    private static final String WIDTH = "width";
    private static final String SORT_INDEX = "sort_index";
    private static final String SORT_DIRECTION = "sort_direction";
    private static final String COLUMNS_ORGANIZERS = "columnsOrganizers";

    public SvdTreeViewerMemento(String mementoId) {
        super("SvdTreeViewerMemento." + mementoId);
    }

    protected SvdTreeViewerBase restoreFromMemento(IMemento memento, SvdTreeViewerBase svdTreeViewer) {
        IMemento node = memento.getChild(COLUMNS_ORGANIZERS);
        if (node != null) {
            SvdTreeViewerMemento.restoreColumnOrder(svdTreeViewer, node);
            SvdTreeViewerMemento.restoreColumnWidth(svdTreeViewer, node);
            SvdTreeViewerMemento.restoreColumnSort(svdTreeViewer, node);
        }
        return svdTreeViewer;
    }

    protected void saveToMemento(IMemento memento, SvdTreeViewerBase svdTreeViewer) {
        IMemento node = memento.getChild(COLUMNS_ORGANIZERS);
        if (node == null) {
            node = memento.createChild(COLUMNS_ORGANIZERS);
        }
        Tree tree = svdTreeViewer.getTreeViewer().getTree();
        int[] columnOrder = tree.getColumnOrder();
        node.putString(ORDER, SvdTreeViewerMemento.arrayToString(columnOrder));
        TreeViewerColumn[] columns = svdTreeViewer.getColumns();
        int[] columnWidths = Arrays.stream(columns).mapToInt(c -> c.getColumn().getWidth()).toArray();
        int[] columnWeights = SvdTreeViewerBase.widthToWeight(columnWidths);
        node.putString(WIDTH, SvdTreeViewerMemento.arrayToString(columnWeights));
        TreeColumn sortColumn = tree.getSortColumn();
        if (sortColumn != null) {
            int i = 0;
            while (i < columns.length) {
                if (columns[i].getColumn() == sortColumn) {
                    node.putInteger(SORT_INDEX, i);
                    break;
                }
                ++i;
            }
            node.putInteger(SORT_DIRECTION, tree.getSortDirection());
        }
    }

    private static void restoreColumnWidth(SvdTreeViewerBase svdTreeViewer, IMemento node) {
        String width = node.getString(WIDTH);
        if (width == null) {
            return;
        }
        try {
            int[] storedWidth = SvdTreeViewerMemento.stringToArray(width);
            TreeViewerColumn[] columns = svdTreeViewer.getColumns();
            if (storedWidth.length != columns.length) {
                throw new CoreException(CdtSvdUiActivator.getInstance().createError(NLS.bind((String)Messages.SvdModelPageMementoHelper_invalid_size_of_column_width_0, (Object)width)));
            }
            int[] defaultColumnMinimumWidth = svdTreeViewer.getDefaultColumnMinimumWidth();
            int i = 0;
            while (i < columns.length) {
                svdTreeViewer.getLayout().setColumnData((Widget)columns[i].getColumn(), (ColumnLayoutData)new ColumnWeightData(storedWidth[i], defaultColumnMinimumWidth[i]));
                ++i;
            }
        }
        catch (CoreException e) {
            CdtSvdUiActivator.getInstance().logError(NLS.bind((String)Messages.SvdModelPageMementoHelper_cannot_restore_column_width_caused_by_0, (Object)e.getStatus().getMessage()));
        }
    }

    private static void restoreColumnOrder(SvdTreeViewerBase svdTreeViewer, IMemento node) {
        String order = node.getString(ORDER);
        if (order == null) {
            return;
        }
        try {
            int[] storedOrder = SvdTreeViewerMemento.stringToArray(order);
            int[] columnOrder = svdTreeViewer.getTreeViewer().getTree().getColumnOrder();
            if (storedOrder.length != columnOrder.length) {
                throw new CoreException(CdtSvdUiActivator.getInstance().createError(NLS.bind((String)Messages.SvdModelPageMementoHelper_invalid_size_of_column_order_0, (Object)order)));
            }
            svdTreeViewer.getTreeViewer().getTree().setColumnOrder(storedOrder);
        }
        catch (CoreException e) {
            CdtSvdUiActivator.getInstance().logError(NLS.bind((String)Messages.SvdModelPageMementoHelper_cannot_restore_column_order_caused_by_0, (Object)e.getStatus().getMessage()));
        }
    }

    private static void restoreColumnSort(SvdTreeViewerBase svdTreeViewer, IMemento node) {
        Integer integer = node.getInteger(SORT_INDEX);
        if (integer != null) {
            TreeViewerColumn[] columns = svdTreeViewer.getColumns();
            if (integer < 0 || integer >= columns.length) {
                CdtSvdUiActivator.getInstance().logError(NLS.bind((String)Messages.SvdModelPageMementoHelper_cannot_restore_sorted_column_invalid_index_value_0, (Object)integer));
            } else {
                svdTreeViewer.setSortColumn(columns[integer]);
            }
        }
        if ((integer = node.getInteger(SORT_DIRECTION)) != null) {
            svdTreeViewer.getTreeViewer().getTree().setSortDirection(integer.intValue());
        }
    }

    private static String arrayToString(int[] array) {
        List list = Arrays.stream(array).mapToObj(i -> Integer.toString(i)).collect(Collectors.toList());
        return SeparatedStrings.COMMA_SEPARATED.toString(list);
    }

    private static int[] stringToArray(String string) throws CoreException {
        String[] strings = SeparatedStrings.COMMA_SEPARATED.asArray(string);
        int[] array = new int[strings.length];
        int i = 0;
        while (i < strings.length) {
            try {
                array[i] = Integer.parseInt(strings[i]);
            }
            catch (NumberFormatException numberFormatException) {
                throw new CoreException(CdtSvdUiActivator.getInstance().createError(NLS.bind((String)Messages.SvdModelPageMementoHelper_invalid_format_of_integer_array_0, (Object)string)));
            }
            ++i;
        }
        return array;
    }
}

