/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cdt.svd.internal.ui.view.memento;

import com.nxp.s32ds.cdt.svd.internal.ui.CdtSvdUiActivator;
import com.nxp.s32ds.cdt.svd.internal.ui.view.memento.SvdMementos;
import com.nxp.s32ds.cdt.svd.model.watch.SvdWatchContext;
import com.nxp.s32ds.cdt.svd.model.watch.SvdWatchModelLoader;
import com.nxp.s32ds.cdt.svd.model.watch.SvdWatchReadPolicy;
import com.nxp.s32ds.cdt.svd.model.watch.SvdWatchReadPolicyType;
import java.util.Map;
import java.util.Set;
import org.eclipse.ui.IMemento;

public class SvdWatchModelMemento
extends SvdMementos<SvdWatchModelLoader.SvdWatchModelState> {
    private static final String PATHS = "paths";
    private static final String PATH = "path";
    private static final String CONTEXTS = "contexts";
    private static final String CONTEXT = "context";
    private static final String READ_POLICY = "readPolicy";

    public SvdWatchModelMemento(String mementoId) {
        super("SvdWatchModelMemento." + mementoId);
    }

    protected SvdWatchModelLoader.SvdWatchModelState restoreFromMemento(IMemento memento, SvdWatchModelLoader.SvdWatchModelState modelState) {
        IMemento element;
        int n;
        int n2;
        IMemento[] iMementoArray;
        IMemento node = memento.getChild(PATHS);
        if (node != null) {
            iMementoArray = node.getChildren(PATH);
            n2 = iMementoArray.length;
            n = 0;
            while (n < n2) {
                element = iMementoArray[n];
                modelState.getPaths().add(element.getTextData());
                ++n;
            }
        }
        if ((node = memento.getChild(CONTEXTS)) != null) {
            iMementoArray = node.getChildren(CONTEXT);
            n2 = iMementoArray.length;
            n = 0;
            while (n < n2) {
                element = iMementoArray[n];
                SvdWatchContext.Builder builder = SvdWatchContext.builder();
                String readPolicyString = element.getString(READ_POLICY);
                if (readPolicyString != null) {
                    try {
                        builder.readPolicy(new SvdWatchReadPolicy(SvdWatchReadPolicyType.valueOf((String)readPolicyString), true));
                    }
                    catch (Exception exception) {
                        CdtSvdUiActivator.getInstance().logError("Cannot restore readPolicy from '" + readPolicyString + "'");
                    }
                }
                modelState.getContexts().put(element.getTextData(), builder.build());
                ++n;
            }
        }
        return modelState;
    }

    protected void saveToMemento(IMemento memento, SvdWatchModelLoader.SvdWatchModelState modelState) {
        IMemento paths = memento.getChild(PATHS);
        if (paths == null) {
            paths = memento.createChild(PATHS);
        }
        for (String string : modelState.getPaths()) {
            paths.createChild(PATH).putTextData(string);
        }
        IMemento contexts = memento.getChild(CONTEXTS);
        if (contexts == null) {
            contexts = memento.createChild(CONTEXTS);
        }
        Set entrySet = modelState.getContexts().entrySet();
        for (Map.Entry entry : entrySet) {
            IMemento contextMemento = contexts.createChild(CONTEXT);
            contextMemento.putTextData((String)entry.getKey());
            SvdWatchContext context = (SvdWatchContext)entry.getValue();
            SvdWatchReadPolicyType readPolicy = context.getReadPolicy().getType();
            contextMemento.putString(READ_POLICY, readPolicy.name());
        }
    }
}

