/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cdt.svd.internal.ui.view.provider;

import com.nxp.s32ds.cdt.svd.internal.ui.Messages;
import com.nxp.s32ds.cdt.svd.internal.ui.view.provider.SvdColumnLabelProvider;
import com.nxp.s32ds.cdt.svd.model.SvdAdresableContainer;
import com.nxp.s32ds.cdt.svd.model.SvdField;
import com.nxp.s32ds.cdt.svd.model.SvdNamedElement;
import com.nxp.s32ds.cdt.svd.model.SvdRegister;
import com.nxp.s32ds.cdt.svd.parser.model.AccessType;
import com.nxp.s32ds.cdt.svd.utils.SvdNumberToStrings;
import com.nxp.s32ds.cle.ide.debugger.svd.SvdSourceType;
import java.math.BigInteger;
import java.util.Optional;
import org.eclipse.cdt.core.IAddress;

public class SvdColumnLabelProviders {
    private static String getAbbreviation(AccessType type) {
        switch (type) {
            case READ_WRITE: {
                return Messages.SvdColumnLabelProviders_rw;
            }
            case READ_ONLY: {
                return Messages.SvdColumnLabelProviders_ro;
            }
            case WRITE_ONLY: {
                return Messages.SvdColumnLabelProviders_wo;
            }
            case WRITE_ONCE: {
                return Messages.SvdColumnLabelProviders_w1;
            }
            case READ_WRITE_ONCE: {
                return Messages.SvdColumnLabelProviders_rw1;
            }
        }
        return Messages.SvdColumnLabelProviders_na;
    }

    public static String getExplanation(AccessType type) {
        switch (type) {
            case READ_WRITE: {
                return Messages.SvdColumnLabelProviders_read_write;
            }
            case READ_ONLY: {
                return Messages.SvdColumnLabelProviders_read_only;
            }
            case WRITE_ONLY: {
                return Messages.SvdColumnLabelProviders_write_only;
            }
            case WRITE_ONCE: {
                return Messages.SvdColumnLabelProviders_write_once;
            }
            case READ_WRITE_ONCE: {
                return Messages.SvdColumnLabelProviders_read_write_once;
            }
        }
        return Messages.SvdColumnLabelProviders_undefined;
    }

    static /* synthetic */ String access$0(AccessType accessType) {
        return SvdColumnLabelProviders.getAbbreviation(accessType);
    }

    public static class AddressLabelProvider
    extends SvdColumnLabelProvider<SvdAdresableContainer> {
        public AddressLabelProvider() {
            super(SvdAdresableContainer.class);
        }

        @Override
        public String getText(Object element) {
            return this.apply(element, r -> AddressLabelProvider.getAddress(r), "");
        }

        private static String getAddress(SvdAdresableContainer container) {
            if (container.getModel().getType() == SvdSourceType.SYS) {
                return "";
            }
            return SvdNumberToStrings.toHexString((IAddress)container.getAddress(), (int)32);
        }
    }

    public static class DescriptionLabelProvider
    extends SvdColumnLabelProvider<SvdNamedElement> {
        public DescriptionLabelProvider() {
            super(SvdNamedElement.class);
        }

        @Override
        public String getText(Object element) {
            return this.apply(element, e -> Optional.ofNullable(e.getDescription()).orElse(""));
        }
    }

    public static class FieldAccessLabelProvider
    extends SvdColumnLabelProvider<SvdField> {
        public FieldAccessLabelProvider() {
            super(SvdField.class);
        }

        @Override
        public String getText(Object element) {
            return this.apply(element, r -> SvdColumnLabelProviders.getAbbreviation(r.getAccessType()));
        }

        public String getToolTipText(Object element) {
            return this.apply(element, r -> SvdColumnLabelProviders.getExplanation(r.getAccessType()));
        }
    }

    public static class RegisterAccessLabelProvider
    extends SvdColumnLabelProvider<SvdRegister> {
        public RegisterAccessLabelProvider() {
            super(SvdRegister.class);
        }

        @Override
        public String getText(Object element) {
            return this.apply(element, r -> SvdColumnLabelProviders.getAbbreviation(r.getAccessType()));
        }

        public String getToolTipText(Object element) {
            return this.apply(element, r -> SvdColumnLabelProviders.getExplanation(r.getAccessType()));
        }
    }

    public static class ResetLabelProvider
    extends SvdColumnLabelProvider<SvdRegister> {
        private static final String EMPTY = "";

        public ResetLabelProvider() {
            super(SvdRegister.class);
        }

        @Override
        public String getText(Object element) {
            return this.apply(element, r -> {
                BigInteger resetValue = r.getResetValue();
                return resetValue == null ? EMPTY : SvdNumberToStrings.toHexString((BigInteger)resetValue, (int)r.getBitLength());
            });
        }

        public String getToolTipText(Object element) {
            return this.apply(element, r -> {
                BigInteger resetValue = r.getResetValue();
                return resetValue == null ? null : SvdNumberToStrings.toBinaryString((BigInteger)resetValue, (int)r.getBitLength());
            });
        }
    }
}

