/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cdt.svd.internal.ui.view.watch.edit;

import com.nxp.s32ds.cdt.svd.internal.ui.view.watch.edit.Messages;
import java.math.BigInteger;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.osgi.util.NLS;

public class SvdHexTextCellEditorValidator
implements ICellEditorValidator {
    private final int bitLength;

    public SvdHexTextCellEditorValidator(int bitLength) {
        this.bitLength = bitLength;
    }

    public String isValid(Object objValue) {
        BigInteger bigValue;
        if (!(objValue instanceof String)) {
            return Messages.SvdHexCellEditorValidator_value_shoud_be_string;
        }
        String strValue = ((String)objValue).trim();
        if (strValue.startsWith("0x")) {
            strValue = strValue.substring(2, strValue.length());
        }
        if (strValue.length() == 0) {
            return Messages.SvdHexCellEditorValidator_empty_value;
        }
        try {
            bigValue = new BigInteger(strValue, 16);
        }
        catch (NumberFormatException e) {
            return NLS.bind((String)Messages.SvdHexCellEditorValidator_invalid_value_format_0, (Object)e.getMessage());
        }
        if (bigValue.bitLength() > this.bitLength) {
            return NLS.bind((String)Messages.SvdHexCellEditorValidator_value_out_of_rang_zero_0, (Object)bigValue.bitLength());
        }
        return null;
    }
}

