/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cdt.svd.internal.ui.view.watch.provider;

import com.nxp.s32ds.cdt.svd.internal.ui.view.SvdTreeViewerInputs;
import com.nxp.s32ds.cdt.svd.internal.ui.view.provider.SvdColumnLabelProviders;
import com.nxp.s32ds.cdt.svd.internal.ui.view.watch.provider.SvdColumnLabelColoredProvider;
import com.nxp.s32ds.cdt.svd.model.SvdAccesible;
import com.nxp.s32ds.cdt.svd.parser.model.AccessType;
import java.math.BigInteger;
import java.util.Objects;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Color;

public abstract class SvdColumnLabelAccesibleProvider<T extends SvdAccesible>
extends SvdColumnLabelColoredProvider<T> {
    public SvdColumnLabelAccesibleProvider(Class<T> _class) {
        super(_class);
    }

    @Override
    public String getText(Object element) {
        SvdAccesible accesible = this.apply(element, e -> e);
        if (accesible == null) {
            return null;
        }
        return this.getTextInternal(accesible, SvdTreeViewerInputs.getValue(this.getViewer(), accesible));
    }

    private String getTextInternal(T accesible, BigInteger value) {
        if (value == null) {
            AccessType accessType = accesible.getAccessType();
            switch (accessType) {
                case WRITE_ONLY: 
                case WRITE_ONCE: {
                    return NLS.bind((String)"({0})", (Object)SvdColumnLabelProviders.getExplanation(accessType).toLowerCase());
                }
            }
            return "?";
        }
        return this.getValueText(accesible, value);
    }

    public Color getBackground(Object element) {
        if (this.isChanged(element)) {
            return this.getSystemColor(7);
        }
        return null;
    }

    private boolean isChanged(Object element) {
        SvdAccesible accesible = this.apply(element, e -> e);
        if (accesible == null) {
            return false;
        }
        BigInteger prevValue = SvdTreeViewerInputs.getPrevValue(this.getViewer(), accesible);
        if (prevValue == null) {
            return false;
        }
        return !Objects.equals(this.getTextInternal(accesible, SvdTreeViewerInputs.getValue(this.getViewer(), accesible)), this.getTextInternal(accesible, prevValue));
    }

    @Override
    public Color getForeground(Object element) {
        if (this.isChanged(element)) {
            return null;
        }
        return super.getForeground(element);
    }

    protected abstract String getValueText(T var1, BigInteger var2);
}

