/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cdt.svd.internal.ui.view.wizard;

import com.nxp.s32ds.cdt.svd.internal.ui.CdtSvdUiActivator;
import com.nxp.s32ds.cdt.svd.internal.ui.Messages;
import com.nxp.s32ds.cdt.svd.internal.ui.view.SvdTreeViewer;
import com.nxp.s32ds.cdt.svd.internal.ui.view.wizard.SvdImportExport;
import com.nxp.s32ds.cdt.svd.internal.ui.view.wizard.SvdImportExportRegistersWizardPageBase;
import com.nxp.s32ds.cdt.svd.internal.ui.view.wizard.SvdImportRegistersWizard;
import com.nxp.s32ds.cdt.svd.internal.ui.view.wizard.SvdImportedRegister;
import com.nxp.s32ds.cdt.svd.internal.ui.view.wizard.SvdRegistersImports;
import com.nxp.s32ds.cdt.svd.internal.ui.view.wizard.SvdSelectPathComposite;
import com.nxp.s32ds.cdt.svd.model.SvdCompositeDeviceModel;
import com.nxp.s32ds.cdt.svd.parser.cache.SvdLaunchToModelsCache;
import com.nxp.s32ds.cle.ide.debugger.svd.SvdSourceType;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.IPageChangingListener;
import org.eclipse.jface.dialogs.PageChangingEvent;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;

public class SvdImportRegistersWizardPage1
extends SvdImportExportRegistersWizardPageBase {
    private static final String PAGE_NAME = SvdImportRegistersWizardPage1.class.getSimpleName();
    private static final String FILE_KEY = String.valueOf(PAGE_NAME) + ".file";
    private final IPageChangingListener listener = e -> this.pageChanging(e);
    private final SvdTreeViewer viewer;
    private SvdSelectPathComposite selectPathComposite;
    private SvdImportRegistersWizard wizard;
    private Collection<SvdImportedRegister> importedRegisters;

    public SvdImportRegistersWizardPage1(SvdTreeViewer viewer) {
        super(PAGE_NAME, Messages.SvdImportRegistersWizardPage1_select_source_file, null);
        this.viewer = viewer;
        this.setDefaultMessage(Messages.SvdImportRegistersWizardPage1_import_registers_from_the_local_file_system);
    }

    public void setWizard(IWizard newWizard) {
        super.setWizard(newWizard);
        this.wizard = (SvdImportRegistersWizard)newWizard;
        this.wizard.addPageChangingListener(this.listener);
    }

    public void dispose() {
        super.dispose();
        this.wizard.removePageChangingListener(this.listener);
    }

    private void pageChanging(PageChangingEvent e) {
        if (e.getCurrentPage() == this) {
            try {
                SvdCompositeDeviceModel model = new SvdCompositeDeviceModel((Collection)SvdLaunchToModelsCache.getInstance().getModelFutures((ILaunch)this.viewer.getInput().launch, EnumSet.allOf(SvdSourceType.class)).get());
                Optional<Path> path = this.selectPathComposite.getFilePath();
                if (path.isPresent()) {
                    this.importedRegisters = SvdRegistersImports.importFile(model, path.get());
                    return;
                }
            }
            catch (CoreException exception) {
                this.handleError(exception);
            }
            catch (InterruptedException | ExecutionException exception) {
                this.handleError(new CoreException(CdtSvdUiActivator.getInstance().createError(Messages.SvdImportRegistersWizardPage1_cannot_get_list_of_models, exception)));
            }
            e.doit = false;
        }
    }

    public Collection<SvdImportedRegister> getImportedRegisters() {
        return this.importedRegisters;
    }

    @Override
    protected void doCreateControl(Composite parent) {
        this.selectPathComposite = new SvdSelectPathComposite(parent, 0);
        this.selectPathComposite.setLayoutData(new GridData(768));
        this.selectPathComposite.addModifyListener(e -> this.updateComplete());
        this.selectPathComposite.setFilterExtensions(SvdImportExport.EXTENSIONS);
        this.selectPathComposite.setFilterNames(SvdImportExport.NAMES);
        this.selectPathComposite.setDialogStyle(4096);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "com.nxp.s32ds.cdt.svd.ui.IMPORT_REGISTERS_WIZARD_context");
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.selectPathComposite.setFocus();
        }
    }

    private void updateComplete() {
        this.importedRegisters = null;
        this.updatePageComplete();
    }

    @Override
    protected void restoreWidgetState(IDialogSettings settings) {
        String string = settings.get(FILE_KEY);
        if (string != null) {
            this.selectPathComposite.setText(string);
        }
    }

    @Override
    protected void saveWidgetState(IDialogSettings settings) {
        settings.put(FILE_KEY, this.selectPathComposite.getText());
    }

    @Override
    protected IStatus validate() {
        return this.selectPathComposite.validate();
    }

    protected boolean fileExist() {
        Optional<Path> path = this.selectPathComposite.getFilePath();
        if (!path.isPresent()) {
            return false;
        }
        return Files.exists(path.get(), new LinkOption[0]);
    }
}

