/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cdt.svd.internal.ui.view.wizard;

import com.nxp.s32ds.cdt.svd.internal.ui.Messages;
import com.nxp.s32ds.cdt.svd.internal.ui.view.SvdTreeViewer;
import com.nxp.s32ds.cdt.svd.internal.ui.view.wizard.SvdImportExportRegistersWizardPageBase;
import com.nxp.s32ds.cdt.svd.internal.ui.view.wizard.SvdImportRegistersWizard;
import com.nxp.s32ds.cdt.svd.internal.ui.view.wizard.SvdImportedRegister;
import com.nxp.s32ds.cdt.svd.internal.ui.view.wizard.dialog.SvdImportExportRegistryTreeComposite;
import com.nxp.s32ds.cdt.svd.internal.ui.view.wizard.dialog.provider.SvdImportContentProvider;
import com.nxp.s32ds.cdt.svd.internal.ui.view.wizard.dialog.provider.SvdNameImportLabelProvider;
import com.nxp.s32ds.cdt.svd.internal.ui.view.wizard.dialog.provider.SvdValueImportLabelProvider;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;

public class SvdImportRegistersWizardPage2
extends SvdImportExportRegistersWizardPageBase {
    private static final String PAGE_NAME = SvdImportRegistersWizardPage2.class.getSimpleName();
    private final ColumnLabelProvider nameProvider;
    private final SvdValueImportLabelProvider valueProvider;
    private Button valuesButton;
    private SvdImportExportRegistryTreeComposite filteredTreeComposite;
    private SvdImportRegistersWizard wizard;

    public SvdImportRegistersWizardPage2(SvdTreeViewer viewer) {
        super(PAGE_NAME, Messages.SvdImportRegistersWizardPage2_select_registers_for_import, null);
        this.nameProvider = new SvdNameImportLabelProvider(viewer.showFullPath());
        this.valueProvider = new SvdValueImportLabelProvider(false);
        this.setDefaultMessage(Messages.SvdImportRegistersWizardPage2_import_registers_from_the_local_file_system);
    }

    public void setWizard(IWizard newWizard) {
        super.setWizard(newWizard);
        this.wizard = (SvdImportRegistersWizard)newWizard;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            Collection<SvdImportedRegister> importedRegisters = this.wizard.getImportedRegisters();
            if (importedRegisters == null) {
                this.setErrorMessage(Messages.SvdImportRegistersWizardPage2_import_result_is_empty);
                this.filteredTreeComposite.setInput(null);
            } else {
                this.filteredTreeComposite.setInput(importedRegisters);
            }
            this.filteredTreeComposite.setFocus();
        }
    }

    public List<SvdImportedRegister> getCheckedElements() {
        return Arrays.stream(this.filteredTreeComposite.getCheckedElements()).filter(e -> e instanceof SvdImportedRegister).map(e -> (SvdImportedRegister)e).collect(Collectors.toList());
    }

    @Override
    public boolean finish() {
        return this.filteredTreeComposite.getCheckedElements().length > 0;
    }

    @Override
    protected void doCreateControl(Composite parent) {
        this.doCreateImportValuesButton(parent);
        this.doCreateFilteredTreeComponent(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "com.nxp.s32ds.cdt.svd.ui.IMPORT_REGISTERS_WIZARD_context");
    }

    private void doCreateImportValuesButton(Composite parent) {
        this.valuesButton = new Button(parent, 32);
        this.valuesButton.setText(Messages.SvdImportRegistersWizardPage2_import_values);
        this.valuesButton.addListener(13, event -> {
            this.valueProvider.setShowValues(this.valuesButton.getSelection());
            this.filteredTreeComposite.getTreeViewer().refresh();
        });
    }

    private void doCreateFilteredTreeComponent(Composite parent) {
        this.filteredTreeComposite = new SvdImportExportRegistryTreeComposite(parent, 0, Messages._registers, this.nameProvider, this.valueProvider, new SvdImportContentProvider());
        this.filteredTreeComposite.setLayoutData(new GridData(1808));
        this.filteredTreeComposite.setEmptyTreeMessage(Messages.SvdImportRegistersWizardPage2_nothing_to_import);
        this.filteredTreeComposite.setNoElementsSelectedMessage(Messages._no_registers_selected);
        this.filteredTreeComposite.setInitiallyCheckAll(true);
        this.filteredTreeComposite.addCheckStateChangedListener(() -> this.updatePageComplete());
    }

    @Override
    protected void restoreWidgetState(IDialogSettings settings) {
    }

    @Override
    protected IStatus validate() {
        return this.filteredTreeComposite.validate();
    }

    public boolean importValues() {
        return this.valuesButton.getSelection();
    }

    @Override
    protected void saveWidgetState(IDialogSettings settings) {
    }
}

