/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.jfx.ui;

import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import javafx.embed.swt.FXCanvas;
import javafx.scene.image.Image;
import javafx.stage.FileChooser;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class FxFileDialog {
    private static final String IMG_OPEN_URL = "platform:/plugin/org.eclipse.ui/icons/full/obj16/fldr_obj@2x.png";
    private static final String IMG_SAVE_URL = "platform:/plugin/org.eclipse.ui/icons/full/etool16/save_edit@2x.png";
    private final FXCanvas canvas;
    private final Stage stage;
    private final Shell swtShell;
    private final boolean save;
    private final boolean multiDialog;
    private String title;
    private String initialDirectory;
    private String initialFile;
    private String iconPath;
    private String[] filterExtensions;
    private String[] filterNames = new String[0];
    private String[] fileNames = new String[0];

    public FxFileDialog(Composite parent, Shell swtShell, int style) {
        if ((style & 0x1000) == 0 && (style & 0x2000) == 0) {
            throw new IllegalArgumentException("Wrong dialog style - must contain SWT.OPEN or SWT.SAVE");
        }
        this.save = (style & 0x2000) != 0;
        this.multiDialog = !this.save && (style & 2) != 0;
        this.swtShell = swtShell;
        this.canvas = new FXCanvas(parent, 0);
        this.stage = new Stage(StageStyle.TRANSPARENT);
        this.stage.setScene(this.canvas.getScene());
        this.stage.initModality(Modality.APPLICATION_MODAL);
    }

    public void setFilterPath(String path) {
        this.initialDirectory = path;
    }

    public void setText(String title) {
        this.title = title;
    }

    public void setIconPath(String iconPath) {
        this.iconPath = iconPath;
    }

    public void setFilterNames(String[] names) {
        if (names != null) {
            this.filterNames = names;
        }
    }

    public void setFilterExtensions(String[] extensions) {
        this.filterExtensions = extensions;
    }

    public void setFileName(String fileName) {
        this.initialFile = fileName;
    }

    public String open() {
        FileChooser fileChooser = new FileChooser();
        if (this.initialDirectory != null && !this.initialDirectory.isEmpty()) {
            fileChooser.setInitialDirectory(new File(this.initialDirectory));
        }
        if (this.title != null && !this.title.isEmpty()) {
            fileChooser.setTitle(this.title);
            this.stage.setTitle(this.title);
        }
        if (this.filterExtensions != null) {
            int i = 0;
            while (i < this.filterExtensions.length) {
                FileChooser.ExtensionFilter filter = new FileChooser.ExtensionFilter(this.filterNames.length > i ? this.filterNames[i] : "-", this.filterExtensions[i].split(";"));
                fileChooser.getExtensionFilters().add((Object)filter);
                ++i;
            }
        }
        if (this.initialFile != null && !this.initialFile.isEmpty()) {
            fileChooser.setInitialFileName(this.initialFile);
        }
        Image icon = null;
        icon = this.iconPath == null || this.iconPath.isEmpty() ? (this.save ? new Image(IMG_SAVE_URL) : new Image(IMG_OPEN_URL)) : new Image(this.iconPath);
        if (icon != null) {
            this.stage.getIcons().add((Object)icon);
        }
        File result = null;
        Cursor currentCursor = this.swtShell.getCursor();
        Cursor waitingCursor = new Cursor((Device)this.swtShell.getDisplay(), 1);
        try {
            try {
                this.swtShell.setEnabled(false);
                this.swtShell.setCursor(waitingCursor);
                waitingCursor.dispose();
                this.stage.show();
                result = !this.save ? (!this.multiDialog ? fileChooser.showOpenDialog((Window)this.stage) : this.showOpenMultiDialog(fileChooser)) : fileChooser.showSaveDialog((Window)this.stage);
                if (result != null) {
                    this.initialDirectory = result.getParentFile().getAbsolutePath();
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            this.swtShell.setCursor(currentCursor);
            this.swtShell.setEnabled(true);
            waitingCursor.dispose();
            this.stage.hide();
            if (icon != null) {
                this.stage.getIcons().remove((Object)icon);
            }
            this.canvas.dispose();
        }
        return result != null ? result.getAbsolutePath() : null;
    }

    private File showOpenMultiDialog(FileChooser fileChooser) {
        File result = null;
        List filesList = fileChooser.showOpenMultipleDialog((Window)this.stage);
        if (filesList != null && !filesList.isEmpty()) {
            result = (File)filesList.get(0);
            this.fileNames = filesList.stream().map(file -> file.getName()).collect(Collectors.toList()).toArray(new String[0]);
        }
        return result;
    }

    public String[] getFileNames() {
        return this.fileNames;
    }

    public String getFilterPath() {
        return this.initialDirectory;
    }
}

