/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.core.model;

import com.freescale.s32ds.cross.core.model.AffectType;
import com.freescale.s32ds.cross.core.model.EditorType;
import com.freescale.s32ds.cross.core.model.IParameterHandler;
import com.freescale.s32ds.cross.core.model.ModelUtil;
import com.freescale.s32ds.cross.core.model.ParameterType;
import com.freescale.s32ds.cross.core.model.ValueType;
import org.eclipse.core.runtime.IConfigurationElement;

public class Parameter {
    private ParameterType type;
    private final String id;
    private final String name;
    private final String description;
    private final AffectType affectType;
    private final boolean single;
    private final boolean visible;
    private final boolean applyAll;
    private final IParameterHandler handler;

    public Parameter(IConfigurationElement ce, ParameterType type) {
        this.id = ce.getAttribute("id");
        String nm = ce.getAttribute("name");
        this.name = nm != null ? nm : type.getName();
        String descr = ce.getAttribute("description");
        this.description = descr != null ? descr : type.getDescription();
        this.type = type;
        this.affectType = ModelUtil.parseAffectType(ce.getAttribute("affectType"));
        this.single = ModelUtil.parseBoolean(ce.getAttribute("single"));
        this.visible = ModelUtil.parseBoolean(ce.getAttribute("visible"), true);
        this.applyAll = ModelUtil.parseBoolean(ce.getAttribute("applyAll"), true);
        this.handler = ModelUtil.parseParameterHandler(ce);
    }

    public String getId() {
        return this.id;
    }

    public String getTag() {
        return this.type.getTag();
    }

    public ParameterType getType() {
        return this.type;
    }

    public AffectType getAffectType() {
        return this.affectType;
    }

    public boolean isSingle() {
        return this.single;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean isApplyAll() {
        return this.applyAll;
    }

    public IParameterHandler getHandler() {
        return this.handler;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public EditorType getEditorType() {
        return this.type.getEditorType();
    }

    public ValueType getValueType() {
        return this.type.getValueType();
    }

    public String getUnit() {
        return this.type.getUnit();
    }

    public String toString() {
        return this.type.toString();
    }
}

