/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.core.model;

import com.freescale.s32ds.cross.core.Activator;
import com.freescale.s32ds.cross.core.model.DataType;
import com.freescale.s32ds.cross.core.model.EditorType;
import com.freescale.s32ds.cross.core.model.IEditorFactory;
import com.freescale.s32ds.cross.core.model.ModelUtil;
import com.freescale.s32ds.cross.core.model.ValueType;
import org.eclipse.core.runtime.IConfigurationElement;

public final class ParameterType {
    private final String tag;
    private final String name;
    private final String description;
    private final EditorType editorType;
    private final DataType dataType;
    private final ValueType valueType;
    private final IEditorFactory editorFactory;
    private final String unit;
    private final String displayName;
    private final boolean calculate;
    private final ParameterType refParameterType;

    private ParameterType(String tag) {
        this.tag = tag;
        this.name = tag;
        this.description = "";
        this.editorType = EditorType.LABEL;
        this.valueType = ValueType.STRING;
        this.dataType = DataType.VALUE;
        this.editorFactory = null;
        this.unit = "";
        this.calculate = false;
        this.displayName = this.createDisplayName(this.name, this.unit);
        this.refParameterType = null;
    }

    public ParameterType(IConfigurationElement ce, ParameterType refType) {
        ParameterType.validateType(ce);
        boolean parameterCE = ParameterType.isParameterConfigurationElement(ce);
        this.tag = parameterCE ? ce.getAttribute("tag") : ce.getName();
        this.name = parameterCE ? ce.getAttribute("name") : this.tag;
        this.description = parameterCE ? ce.getAttribute("description") : this.tag;
        this.editorType = parameterCE ? this.extractEditorType(ce) : EditorType.LABEL;
        this.valueType = parameterCE ? this.extractValueType(ce) : ValueType.STRING;
        this.dataType = this.extractDataType(ce);
        String u = ce.getAttribute("unit");
        this.unit = u != null ? u : "";
        this.editorFactory = ModelUtil.parseEditorFactory(ce);
        this.calculate = ModelUtil.parseBoolean(ce.getAttribute("calculate"), false);
        this.displayName = this.createDisplayName(this.name, this.unit);
        this.refParameterType = refType;
    }

    public String getTag() {
        return this.tag;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public EditorType getEditorType() {
        return this.editorType;
    }

    public ValueType getValueType() {
        return this.valueType;
    }

    public boolean isMultipleSelection() {
        return EditorType.MULTI_SELECTION == this.editorType;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public String toString() {
        return this.tag;
    }

    public IEditorFactory getEditorFactory() {
        return this.editorFactory;
    }

    public boolean hasNamedIds() {
        return ValueType.STRING == this.valueType && EditorType.SELECTION == this.editorType;
    }

    public String getUnit() {
        return this.unit;
    }

    public boolean isCalculate() {
        return this.calculate;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public ParameterType getRefParameterType() {
        return this.refParameterType;
    }

    private EditorType extractEditorType(IConfigurationElement ce) {
        String attribute;
        String string = attribute = ce != null ? ce.getAttribute("editorType") : null;
        if (attribute == null) {
            return EditorType.LABEL;
        }
        try {
            return EditorType.valueOf(attribute);
        }
        catch (Exception exception) {
            Activator.logWarning("Unsupported editor " + attribute + " for paramerter " + this.tag + "!");
            return EditorType.LABEL;
        }
    }

    private ValueType extractValueType(IConfigurationElement ce) {
        String attribute;
        String string = attribute = ce != null ? ce.getAttribute("valueType") : null;
        if (attribute == null) {
            return ValueType.STRING;
        }
        try {
            return ValueType.valueOf(attribute);
        }
        catch (Exception exception) {
            Activator.logWarning("Unsupported valueType " + attribute + " for paramerter " + this.tag + "!");
            return ValueType.STRING;
        }
    }

    private DataType extractDataType(IConfigurationElement ce) {
        if (this.tag.toLowerCase().endsWith("Set")) {
            return DataType.SET;
        }
        if (ce != null && !ParameterType.isParameterConfigurationElement(ce) && ce.getChildren().length > 0) {
            return DataType.OBJECT;
        }
        return DataType.VALUE;
    }

    private String createDisplayName(String name, String unit) {
        return unit.trim().isEmpty() ? name : String.valueOf(name) + ", " + unit;
    }

    public static String findElementTag(String tag) {
        return ParameterType.isSetTag(tag) ? tag.substring(0, tag.length() - "Set".length()) : tag;
    }

    public static String findSetTag(String tag) {
        return ParameterType.isSetTag(tag) ? tag : String.valueOf(tag) + "Set";
    }

    public static boolean isSetTag(String tag) {
        return tag.endsWith("Set");
    }

    public static boolean isElementTag(String tag) {
        return !ParameterType.isSetTag(tag);
    }

    public static void validateType(IConfigurationElement ce) {
        if (!"parameterType".equals(ce.getName())) {
            IllegalArgumentException e = new IllegalArgumentException("Incorrect type, expected : parameterType,  actual : " + ce.getName());
            Activator.log(e);
            throw e;
        }
    }

    public static boolean isParameterConfigurationElement(IConfigurationElement ce) {
        return "parameterType".equals(ce.getName());
    }

    public static ParameterType createUndeclaredType(String id) {
        return new ParameterType(id);
    }
}

