/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.core.model.context;

import com.freescale.s32ds.cross.core.model.context.ContextChange;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class ChangeResult {
    private static final String EMPTY = "";
    private final List<ContextChange> contextChanges = new ArrayList<ContextChange>();
    private final boolean approved;
    private String warningMessage = "";

    public ChangeResult(boolean approve, List<ContextChange> contextChanges, String warningMessage) {
        this.approved = approve;
        this.contextChanges.addAll(contextChanges);
        this.warningMessage = warningMessage;
    }

    public ChangeResult(boolean approve) {
        this(approve, Collections.EMPTY_LIST, EMPTY);
    }

    public ChangeResult(List<ContextChange> contextChanges) {
        this(true, contextChanges, EMPTY);
    }

    public ChangeResult(boolean approve, String warningMessage) {
        this(approve, Collections.EMPTY_LIST, warningMessage);
    }

    public ChangeResult(List<ContextChange> contextChanges, String warningMessage) {
        this(true, contextChanges, warningMessage);
    }

    public List<ContextChange> getContextChanges() {
        return Collections.unmodifiableList(this.contextChanges);
    }

    public boolean isApproved() {
        return this.approved;
    }

    public String getWarningMessage() {
        return this.warningMessage;
    }

    public boolean hasWarning() {
        return this.warningMessage != null && !this.warningMessage.isEmpty();
    }

    public void setWarningMessage(String warningMessage) {
        this.warningMessage = warningMessage;
    }

    public static ChangeResult createDeclined() {
        return new ChangeResult(false);
    }

    public static ChangeResult createApproved() {
        return new ChangeResult(true);
    }
}

