/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.core.model.context;

import com.freescale.s32ds.cross.core.Activator;
import com.freescale.s32ds.cross.core.model.AffectType;
import com.freescale.s32ds.cross.core.model.DefaultParameterHandler;
import com.freescale.s32ds.cross.core.model.IParameterHandler;
import com.freescale.s32ds.cross.core.model.Parameter;
import com.freescale.s32ds.cross.core.model.ParameterType;
import com.freescale.s32ds.cross.core.model.PositionType;
import com.freescale.s32ds.cross.core.model.context.AbstractContext;
import com.freescale.s32ds.cross.core.model.context.CProjectMasterContext;
import com.freescale.s32ds.cross.core.model.context.ChangeResult;
import com.freescale.s32ds.cross.core.model.data.ObjectData;
import com.freescale.s32ds.cross.core.model.registry.ContextDefinition;
import com.freescale.s32ds.cross.core.model.registry.ContextPart;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ContextParameterManager {
    private final AbstractContext context;
    private final ObjectData rootData;
    private final ContextDefinition contextDefinition;
    private final IParameterHandler defaultParameterHandler = new DefaultParameterHandler();
    private Map<String, Parameter> parameterMap = new LinkedHashMap<String, Parameter>();
    private Map<String, IParameterHandler> handlerMap = new HashMap<String, IParameterHandler>();
    private final List<ParameterType> parameterTypes = new ArrayList<ParameterType>();

    public ContextParameterManager(AbstractContext context, ContextDefinition contextDefinition, List<ContextPart> insertionParts, ObjectData rootData) {
        this.context = context;
        this.rootData = rootData;
        this.contextDefinition = contextDefinition;
        ArrayList<ContextPart> topParts = new ArrayList<ContextPart>();
        ArrayList<ContextPart> bottomParts = new ArrayList<ContextPart>();
        ArrayList<ContextPart> centerParts = new ArrayList<ContextPart>();
        for (ContextPart part : insertionParts) {
            if (PositionType.TOP == part.getPositionType()) {
                topParts.add(part);
                continue;
            }
            if (PositionType.BOTTOM == part.getPositionType()) {
                bottomParts.add(part);
                continue;
            }
            centerParts.add(part);
        }
        this.initParameters(centerParts, false, true);
        this.initParameters(contextDefinition.getDefaultPart(), true, false);
        this.initParameters(topParts, true, true);
        this.initParameters(contextDefinition.getTerminationPart(), false, false);
        this.initParameters(bottomParts, false, true);
        for (Parameter ref : this.parameterMap.values()) {
            this.parameterTypes.add(ref.getType());
        }
    }

    public ObjectData getRootData() {
        return this.rootData;
    }

    public ContextDefinition getContextDefinition() {
        return this.contextDefinition;
    }

    public IParameterHandler getParameterHandler(String tag) {
        IParameterHandler h = this.handlerMap.get(tag);
        return h != null ? h : this.defaultParameterHandler;
    }

    public List<ParameterType> getParameterTypes() {
        return Collections.unmodifiableList(this.parameterTypes);
    }

    public boolean containsParameter(String tag) {
        return this.parameterMap.containsKey(tag);
    }

    public Parameter getParameter(String tag) {
        return this.parameterMap.get(tag);
    }

    public Parameter getParameter(ParameterType parameterType) {
        return this.parameterMap.get(parameterType.getTag());
    }

    public Collection<Parameter> getParameters() {
        return this.parameterMap.values();
    }

    public boolean isParameterEnabled(String tag) {
        return this.getParameterHandler(tag).isEnabled(tag, this.context);
    }

    public boolean isParameterSingle(String tag) {
        Parameter ref = this.parameterMap.get(tag);
        return ref != null ? ref.isSingle() : false;
    }

    public boolean isParameterApplyAll(String tag) {
        Parameter ref = this.parameterMap.get(tag);
        return ref != null ? ref.isApplyAll() : false;
    }

    public AffectType getAffectType(String tag) {
        Parameter ref = this.parameterMap.get(tag);
        return ref != null ? ref.getAffectType() : AffectType.ALL;
    }

    protected ChangeResult getChangeResult(String tag, Object value, boolean onInit) {
        IParameterHandler h = this.getParameterHandler(tag);
        try {
            ChangeResult result;
            ChangeResult changeResult = result = onInit ? h.onInit(tag, value, this.context) : h.onEdit(tag, value, this.context);
            if (result == null) {
                result = ChangeResult.createApproved();
            }
            return result;
        }
        catch (Exception e) {
            Activator.log(e);
            return ChangeResult.createDeclined();
        }
    }

    private void initParameters(List<ContextPart> parts, boolean first, boolean replace) {
        int i = 0;
        while (i < parts.size()) {
            boolean r = i == 0 ? replace : false;
            boolean f = i == 0 ? first : false;
            this.initParameters(parts.get(i), f, r);
            ++i;
        }
    }

    private void initParameters(ContextPart part, boolean first, boolean replace) {
        Collection<Parameter> ps = part.getParameters();
        if (ps.isEmpty()) {
            return;
        }
        ArrayList<Parameter> toAdd = new ArrayList<Parameter>();
        if (this.parameterMap.isEmpty()) {
            toAdd.addAll(ps);
        } else {
            for (Parameter p : ps) {
                if (!replace && this.parameterMap.containsKey(p.getTag())) continue;
                toAdd.add(p);
            }
        }
        if (toAdd.isEmpty()) {
            return;
        }
        LinkedHashMap<String, Parameter> pMap = null;
        if (first) {
            pMap = new LinkedHashMap<String, Parameter>(this.parameterMap);
            this.parameterMap.clear();
        }
        boolean isProjectContext = this.context instanceof CProjectMasterContext;
        for (Parameter parameter : toAdd) {
            this.parameterMap.put(parameter.getTag(), parameter);
            if (!isProjectContext || parameter.getHandler() == null || this.handlerMap.containsKey(parameter.getTag())) continue;
            this.handlerMap.put(parameter.getTag(), parameter.getHandler());
        }
        if (pMap != null && !pMap.isEmpty()) {
            for (Map.Entry entry : pMap.entrySet()) {
                if (this.parameterMap.containsKey(entry.getKey())) continue;
                this.parameterMap.put((String)entry.getKey(), (Parameter)entry.getValue());
            }
        }
    }
}

