/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.core.model.data;

import com.freescale.s32ds.cross.core.model.IDataInitilyzer;
import com.freescale.s32ds.cross.core.model.ModelUtil;
import com.freescale.s32ds.cross.core.model.Parameter;
import com.freescale.s32ds.cross.core.model.ParameterType;
import com.freescale.s32ds.cross.core.model.PositionType;
import com.freescale.s32ds.cross.core.model.data.ConfigurationData;
import com.freescale.s32ds.cross.core.model.data.DataFactory;
import com.freescale.s32ds.cross.core.model.data.SimpleData;
import com.freescale.s32ds.cross.core.model.registry.ModelRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;

public class ObjectData
extends ConfigurationData {
    private static final Set<String> reservedNames = new HashSet<String>(Arrays.asList("family", "processor", "coProcessor", "core", "coreType", "coreKind", "template"));
    private static final Set<String> reservedRefIds = new HashSet<String>();
    private final List<ConfigurationData> children = new ArrayList<ConfigurationData>();
    private final Map<String, ConfigurationData> attributesDataMap = new LinkedHashMap<String, ConfigurationData>();
    private Map<String, Parameter> parameterMap = null;
    private final Map<String, String> reservedDataTagMap = new HashMap<String, String>();
    private final Set<String> reservedParameterIds = new LinkedHashSet<String>();
    private IDataInitilyzer initializer;
    private PositionType contextPositionType = PositionType.CENTER;

    static {
        for (String reservedName : reservedNames) {
            reservedRefIds.add(String.valueOf(reservedName) + "Id");
            reservedRefIds.add(String.valueOf(reservedName) + "Ref");
        }
    }

    public ObjectData(IConfigurationElement ce, ConfigurationData parent, ModelRegistry registry) {
        super(ce, parent, registry);
        this.parseChildren(ce, registry);
    }

    public Set<Parameter> getParameters() {
        return new LinkedHashSet<Parameter>(this.getParameterMap().values());
    }

    protected PositionType getContextPositionType() {
        return this.contextPositionType;
    }

    public IDataInitilyzer getInitialyzer() {
        return this.initializer;
    }

    protected void setInitialyzer(IDataInitilyzer initialyzer) {
        this.initializer = initialyzer;
    }

    @Override
    public void init() {
        this.children.stream().forEach(ConfigurationData::init);
        if (this.initializer != null) {
            for (ConfigurationData d : this.initializer.createData(this)) {
                if (d == null || this.attributesDataMap.containsKey(d.getTag())) continue;
                this.attributesDataMap.put(d.getTag(), d);
            }
        }
        super.init();
    }

    public String toString() {
        return "{" + this.getBaseInfo() + ":" + this.getAttributesDataMap().values() + "}";
    }

    @Override
    public ConfigurationData getElement(String tag) {
        List<ConfigurationData> dataSet = this.getElements(tag);
        return dataSet.size() > 0 ? dataSet.get(0) : null;
    }

    @Override
    public String getValue(String tag) {
        ConfigurationData d = this.getElement(tag);
        if (d == null) {
            return null;
        }
        return d instanceof SimpleData ? ((SimpleData)d).getValue() : d.getId();
    }

    @Override
    public String getDisplayValue(String tag) {
        ConfigurationData d = this.getElement(tag);
        if (d == null) {
            return null;
        }
        return d instanceof SimpleData ? ((SimpleData)d).getValue() : d.getName();
    }

    @Override
    public List<ConfigurationData> getElements() {
        return new ArrayList<ConfigurationData>(this.getAttributesDataMap().values());
    }

    @Override
    public List<ConfigurationData> getElements(String tag) {
        return this.getElements(tag, true);
    }

    @Override
    public List<ConfigurationData> getElements(String tag, boolean considerSetElementTag) {
        String setTag;
        if (tag == null) {
            return Collections.EMPTY_LIST;
        }
        List<ConfigurationData> cs = this.getElements(tag, true, true);
        if (considerSetElementTag && cs.isEmpty() && !tag.endsWith("Set") && (cs = this.getElements(setTag = ParameterType.findSetTag(tag), true, false)).size() > 0) {
            cs = cs.get(0).getElements();
        }
        return cs;
    }

    protected List<ConfigurationData> getChildren() {
        return this.children;
    }

    @Override
    protected List<ConfigurationData> getElements(String tag, boolean parentSearch, boolean childrenSearch) {
        List<ConfigurationData> ds;
        ConfigurationData attributeData;
        LinkedHashSet<ConfigurationData> result = new LinkedHashSet<ConfigurationData>();
        if (this.getTag().equals(tag)) {
            result.add(this);
        }
        if ((attributeData = this.getAttributesDataMap().get(tag)) != null && result.isEmpty()) {
            result.add(attributeData);
        }
        if (result.isEmpty()) {
            String tagWithIdSuffix = String.valueOf(tag) + "Id";
            ConfigurationData attributeNonInitialized = this.getAttributesDataMap().get(tagWithIdSuffix);
            if (attributeNonInitialized != null) {
                String targetId = attributeNonInitialized.getStringValue(tagWithIdSuffix);
                ConfigurationData targetData = this.getRegistry().getData(tag, targetId);
                if (targetData != null) {
                    this.addAttribute(targetData);
                    result.add(targetData);
                }
            }
        }
        if (result.isEmpty()) {
            for (ConfigurationData d : this.getAttributesDataMap().values()) {
                List<ConfigurationData> ds2;
                if (d == null || (ds2 = d.getElements(tag, parentSearch, false)) == null || ds2.isEmpty()) continue;
                result.addAll(ds2);
                break;
            }
        }
        if (result.isEmpty() && childrenSearch) {
            for (ConfigurationData child : this.children) {
                result.addAll(child.getElements(tag, false, true));
            }
        }
        if (result.isEmpty() && this.getParent() != null && (ds = this.getParent().getElements(tag, true, false)) != null && !ds.isEmpty()) {
            result.addAll(ds);
        }
        return new ArrayList<ConfigurationData>(result);
    }

    public Map<String, Parameter> getParameterMap() {
        if (this.parameterMap == null) {
            this.parameterMap = new LinkedHashMap<String, Parameter>();
            for (String pid : this.reservedParameterIds) {
                Parameter p = this.getRegistry().getParameter(pid);
                if (p == null) continue;
                this.parameterMap.put(p.getId(), p);
            }
        }
        return Collections.unmodifiableMap(this.parameterMap);
    }

    public Map<String, ConfigurationData> getAttributesDataMap() {
        if (!this.reservedDataTagMap.isEmpty()) {
            Iterator<Map.Entry<String, String>> it = this.reservedDataTagMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, String> entry = it.next();
                String dataId = entry.getKey();
                String tag = entry.getValue();
                ConfigurationData data = this.getRegistry().getData(tag, dataId);
                if (data == null) continue;
                this.attributesDataMap.put(tag, data);
                it.remove();
            }
        }
        return Collections.unmodifiableMap(this.attributesDataMap);
    }

    void addAttribute(ConfigurationData data) {
        this.attributesDataMap.put(data.getTag(), data);
    }

    /*
     * Unable to fully structure code
     */
    private void parseChildren(IConfigurationElement ce, ModelRegistry registry) {
        var7_4 = attributeNames = ce.getAttributeNames();
        var6_5 = attributeNames.length;
        var5_6 = 0;
        while (var5_6 < var6_5) {
            block9: {
                block10: {
                    attributeName = var7_4[var5_6];
                    if ("id".equals(attributeName) || "name".equals(attributeName) || "description".equals(attributeName)) break block9;
                    if (!"initialyzer".equals(attributeName)) break block10;
                    dp = ModelUtil.parseDataInitialyzer(ce);
                    this.setInitialyzer(dp);
                    break block9;
                }
                tagRefId = attributeName.length() > 2 && attributeName.toLowerCase().endsWith("id") != false ? attributeName.substring(0, attributeName.length() - 2) : attributeName;
                dataRefId = ce.getAttribute(attributeName);
                if (ObjectData.reservedRefIds.contains(attributeName) || registry.getTags().contains(tagRefId)) ** GOTO lbl22
                if (ObjectData.reservedNames.contains(tagRefId)) {
                    this.reservedDataTagMap.put(dataRefId, tagRefId);
                    this.attributesDataMap.put(tagRefId, null);
                } else {
                    registry.registerTag(tagRefId);
lbl22:
                    // 2 sources

                    if ((data = registry.getData(tagRefId, dataRefId)) == null) {
                        data = new SimpleData(attributeName, dataRefId, this);
                    }
                    this.attributesDataMap.put(data.getTag(), data);
                }
            }
            ++var5_6;
        }
        var7_4 = ce.getChildren();
        var6_5 = var7_4.length;
        var5_6 = 0;
        while (var5_6 < var6_5) {
            cce = var7_4[var5_6];
            if (cce.getName().equals("parameters")) {
                this.contextPositionType = PositionType.parsePositionType(cce.getAttribute("position"));
                var11_14 = cce.getChildren();
                var10_13 = var11_14.length;
                var9_10 = 0;
                while (var9_10 < var10_13) {
                    pe = var11_14[var9_10];
                    pid = pe.getAttribute("parameterId");
                    this.reservedParameterIds.add(pid);
                    ++var9_10;
                }
            } else {
                data = DataFactory.createData((IConfigurationElement)cce, this, registry);
                if (data != null) {
                    this.children.add(data);
                }
            }
            ++var5_6;
        }
    }
}

