/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.core.model.data;

import com.freescale.s32ds.cross.core.model.ModelUtil;
import com.freescale.s32ds.cross.core.model.data.ConfigurationData;
import com.freescale.s32ds.cross.core.model.data.SingleData;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class SimpleData
extends SingleData {
    private final String value;
    private final List<ConfigurationData> dataSet;

    SimpleData(String attributeName, String attributeValue, ConfigurationData parent) {
        super(attributeName, parent, parent.getRegistry());
        this.value = attributeValue;
        this.dataSet = Collections.unmodifiableList(Arrays.asList(this));
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public ConfigurationData getElement(String tag) {
        return this.getTag().equals(tag) ? this : null;
    }

    @Override
    public String getValue(String tag) {
        return this.getTag().equals(tag) ? this.getValue() : null;
    }

    @Override
    public String getDisplayValue(String tag) {
        String d = this.getValue(tag);
        return d != null ? d : null;
    }

    @Override
    public List<ConfigurationData> getElements() {
        return Collections.unmodifiableList(this.dataSet);
    }

    @Override
    public List<ConfigurationData> getElements(String tag) {
        if (this.getTag().equals(tag)) {
            return this.dataSet;
        }
        return Collections.emptyList();
    }

    @Override
    public List<ConfigurationData> getElements(String tag, boolean considerSetElementTag) {
        return this.getElements();
    }

    @Override
    public List<ConfigurationData> getElements(String tag, boolean parentSearch, boolean childrenSearch) {
        return this.getElements(tag);
    }

    public boolean equals(Object obj) {
        if (obj instanceof SimpleData) {
            SimpleData v = (SimpleData)obj;
            if (!this.getTag().equals(v.getTag())) {
                return false;
            }
            if (this.value == null && v.getValue() == null) {
                return true;
            }
            if (this.value == null || v.getValue() == null) {
                return false;
            }
            return this.value.equals(v.getValue());
        }
        return false;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return "{" + this.getBaseInfo() + ":" + this.value + "}";
    }

    public String gettValue() {
        return this.getValue();
    }

    public int getIntValue() {
        return ModelUtil.parseInteger(this.gettValue());
    }

    public String getStringValue() {
        return this.gettValue();
    }

    public long getLongValue() {
        return ModelUtil.parseLong(this.gettValue(), 16);
    }

    public Boolean getBooleanValue() {
        return ModelUtil.parseBoolean(this.gettValue());
    }
}

