/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.core.model.data;

import com.freescale.s32ds.cross.core.model.CdtTemplateInfo;
import com.freescale.s32ds.cross.core.model.data.ConfigurationData;
import com.freescale.s32ds.cross.core.model.data.CoreNatureData;
import com.freescale.s32ds.cross.core.model.data.ObjectData;
import com.freescale.s32ds.cross.core.model.registry.ContextPart;
import com.freescale.s32ds.cross.core.model.registry.ModelRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;

public class TemplateData
extends ObjectData {
    private final ObjectData executableData;
    private final ObjectData libraryData;
    private ContextPart executableContextPart;
    private ContextPart libraryContextPart;
    private final String executableTemplateId;
    private final String libraryTemplateId;
    private final CdtTemplateInfo executableInfo;
    private final CdtTemplateInfo libraryInfo;
    private final List<String> valueVariables = new ArrayList<String>();
    private final List<String> dynamicVariables = new ArrayList<String>();

    public TemplateData(IConfigurationElement ce, ConfigurationData parent, ModelRegistry registry) {
        super(ce, parent, registry);
        this.executableData = (ObjectData)this.getElement("executable");
        this.executableTemplateId = this.executableData != null ? this.executableData.getId() : null;
        this.libraryData = (ObjectData)this.getElement("library");
        this.libraryTemplateId = this.libraryData != null ? this.libraryData.getId() : null;
        this.executableInfo = this.executableTemplateId != null ? registry.getCdtTemplateInfo(this.executableTemplateId) : null;
        this.libraryInfo = this.libraryTemplateId != null ? registry.getCdtTemplateInfo(this.libraryTemplateId) : null;
        this.addTemplateToElements("coreType");
        this.addTemplateToElements("core");
        this.addTemplateToElements("coProcessor");
        this.dynamicVariables.addAll(this.getVariables("dynamicVariable"));
        this.valueVariables.addAll(this.getVariables("valueVariable"));
    }

    public ContextPart getExecutableContextPart() {
        if (this.executableContextPart == null) {
            this.executableContextPart = this.createContextPart(this.executableData, this.getRegistry());
        }
        return this.executableContextPart;
    }

    public ContextPart getLibraryContextPart() {
        if (this.libraryContextPart == null) {
            this.libraryContextPart = this.createContextPart(this.libraryData, this.getRegistry());
        }
        return this.libraryContextPart;
    }

    public String getExecutableTemplateId() {
        return this.executableTemplateId;
    }

    public String getLibraryTemplateId() {
        return this.libraryTemplateId;
    }

    public CdtTemplateInfo getExecutableInfo() {
        return this.executableInfo;
    }

    public CdtTemplateInfo getLibraryInfo() {
        return this.libraryInfo;
    }

    public CdtTemplateInfo getTemplateInfo(boolean executable) {
        return executable ? this.getExecutableInfo() : this.getLibraryInfo();
    }

    public List<String> getValueVariables() {
        return Collections.unmodifiableList(this.valueVariables);
    }

    public List<String> getDynamicVariables() {
        return Collections.unmodifiableList(this.dynamicVariables);
    }

    private void addTemplateToElements(String tag) {
        String refTag = String.valueOf(tag) + "Ref";
        List<ConfigurationData> refs = this.getElements(refTag);
        for (ConfigurationData ref : refs) {
            ConfigurationData element = ref.getElement(tag);
            if (!(element instanceof CoreNatureData)) continue;
            ((CoreNatureData)element).addTemplate(this);
        }
    }

    private ContextPart createContextPart(ObjectData data, ModelRegistry registry) {
        if (data == null) {
            return new ContextPart();
        }
        return new ContextPart(data.getParameterMap().values(), this.getContextPositionType());
    }

    private Set<String> getVariables(String tag) {
        List<ConfigurationData> es = this.getElements(String.valueOf(tag) + "s");
        if (es.size() > 0) {
            List<ConfigurationData> ds = es.get(0).getElements(tag);
            LinkedHashSet<String> result = new LinkedHashSet<String>();
            for (ConfigurationData d : ds) {
                result.add(d.getName());
            }
            return result;
        }
        return Collections.emptySet();
    }
}

