/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.core.tools;

import com.freescale.s32ds.cross.core.tools.AbstractActionFilesHandler;
import com.freescale.s32ds.cross.core.tools.ExtensionLoader;
import com.freescale.s32ds.cross.core.tools.Messages;
import com.freescale.s32ds.cross.core.tools.Preprocessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.settings.model.ICSourceEntry;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.internal.core.AdapterUtil;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.IStructuredSelection;

public class PreprocessFilesHandler
extends AbstractActionFilesHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        List<IFile> selectedFiles = this.getSelectedPreprocessableFiles(event);
        if (selectedFiles.isEmpty()) {
            return null;
        }
        PreprocessFilesJob job = new PreprocessFilesJob(selectedFiles);
        job.schedule();
        return null;
    }

    private List<IFile> getSelectedPreprocessableFiles(ExecutionEvent event) throws ExecutionException {
        Collection selectedResources = PreprocessFilesHandler.getSelectedResources((ExecutionEvent)event);
        ArrayList<IFile> files = new ArrayList<IFile>(selectedResources.size());
        for (IResource resource : selectedResources) {
            if (!(resource instanceof IFile) || !PreprocessFilesHandler.isBuildable(resource)) continue;
            files.add((IFile)resource);
        }
        return files;
    }

    private static boolean isBuildable(IResource resource) {
        IProject project = resource.getProject();
        if (!ManagedBuildManager.manages((IResource)project)) {
            return false;
        }
        IManagedBuildInfo buildInfo = ManagedBuildManager.getBuildInfo((IResource)project);
        return buildInfo != null && buildInfo.isValid() && buildInfo.buildsFileType(resource.getFileExtension());
    }

    @Override
    protected boolean shouldBeEnabled(Object evaluationContext) {
        IStructuredSelection selection = PreprocessFilesHandler.convertSelection((IEvaluationContext)evaluationContext, null);
        if (selection.isEmpty()) {
            return false;
        }
        Iterator elements = selection.iterator();
        while (elements.hasNext()) {
            IFile file = (IFile)AdapterUtil.adapt(elements.next(), IFile.class);
            if (file == null) {
                return false;
            }
            if (!PreprocessFilesHandler.isBuildable((IResource)file)) {
                return false;
            }
            if (PreprocessFilesHandler.hasPreprocessor(file)) continue;
            return false;
        }
        return true;
    }

    public static boolean hasPreprocessor(IFile file) {
        if (file == null) {
            return false;
        }
        if (file.getFileExtension() == null) {
            return false;
        }
        if (file.getLocation() == null) {
            return false;
        }
        IProject project = file.getProject();
        if (!ManagedBuildManager.manages((IResource)project)) {
            return false;
        }
        IManagedBuildInfo builderInfo = ManagedBuildManager.getBuildInfo((IResource)project);
        if (builderInfo == null) {
            return false;
        }
        IConfiguration config = builderInfo.getDefaultConfiguration();
        if (config == null) {
            return false;
        }
        if (CDataUtil.isExcluded((IPath)file.getProjectRelativePath(), (ICSourceEntry[])config.getSourceEntries())) {
            return false;
        }
        String projectType = PreprocessFilesHandler.getProjectTypeID(builderInfo);
        if (projectType.equals("")) {
            return false;
        }
        ITool tool = builderInfo.getToolFromInputExtension(file.getFileExtension());
        if (tool == null) {
            return false;
        }
        return PreprocessFilesHandler.hasPreprocessor(tool);
    }

    static boolean hasPreprocessor(ITool tool) {
        return ExtensionLoader.getInstance().getPreprocessor(tool) != null;
    }

    private static class PreprocessFilesJob
    extends Job {
        private final List<IFile> files;

        private PreprocessFilesJob(List<IFile> filesToPreprocess) {
            super(Messages.PreprocessorPreprocessing_files);
            this.files = filesToPreprocess;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            Class<?> clazz = ((Object)((Object)this)).getClass();
            synchronized (clazz) {
                Job[] jobs;
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                Job[] jobArray = jobs = Job.getJobManager().find(ResourcesPlugin.FAMILY_MANUAL_BUILD);
                int n = jobs.length;
                int n2 = 0;
                while (n2 < n) {
                    Job job = jobArray[n2];
                    if (job != this && job instanceof PreprocessFilesJob) {
                        job.cancel();
                    }
                    ++n2;
                }
            }
            Preprocessor preprocessor = new Preprocessor();
            try {
                preprocessor.preprocessFiles(this.files, monitor);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            return Status.OK_STATUS;
        }

        public boolean belongsTo(Object family) {
            return ResourcesPlugin.FAMILY_MANUAL_BUILD == family;
        }
    }
}

