/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.uct.ui;

import com.nxp.swtools.clocks.data.IMcu;
import com.nxp.swtools.clocks.data.elements.ClockGate;
import com.nxp.swtools.clocks.data.elements.ClockOutput;
import com.nxp.swtools.clocks.data.elements.ClockSelect;
import com.nxp.swtools.clocks.data.elements.ComponentOutput;
import com.nxp.swtools.clocks.data.elements.ConfigElement;
import com.nxp.swtools.clocks.data.elements.IClockElement;
import com.nxp.swtools.clocks.data.elements.IConfigElementItem;
import com.nxp.swtools.clocks.data.elements.IElement;
import com.nxp.swtools.clocks.data.elements.Prescaler;
import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.data.model.IClocksProfile;
import com.nxp.swtools.clocks.data.model.LockState;
import com.nxp.swtools.clocks.data.settings.EnableSetting;
import com.nxp.swtools.clocks.data.settings.ISetting;
import com.nxp.swtools.clocks.data.settings.SettingType;
import com.nxp.swtools.clocks.data.settings.SettingValue;
import com.nxp.swtools.clocks.uct.ui.Messages;
import com.nxp.swtools.clocks.uct.ui.PeripheralClockElement;
import com.nxp.swtools.clocks.ui.SettingEditorHelper;
import com.nxp.swtools.clocks.ui.events.GuiController;
import com.nxp.swtools.common.ui.utils.editors.InstantSearchCellEditor;
import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.utils.events.IEventListener;
import com.nxp.swtools.utils.events.ToolEvent;
import com.nxp.swtools.utils.resources.ToolsColors;
import com.nxp.swtools.utils.resources.ToolsImages;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class PeripheralClockWindow {
    @NonNull
    static final Logger LOGGER = LogManager.getLogger(PeripheralClockWindow.class);
    @NonNull
    final Table table;
    @NonNull
    private final TableViewer tableViewer;
    @NonNull
    @NonNull Set<@NonNull IEventListener> listeners = new HashSet<IEventListener>();
    @Nullable
    static final Image ICON_CHECKED = ToolsImages.getImage((String)"icons/icons_for_table_viewers/checkbox_checked_left_transparent_pixel.png");
    @Nullable
    static final Image ICON_CHECKED_DISABLED = ToolsImages.getImage((String)"icons/icons_for_table_viewers/checkbox_checked_disabled_left_transparent_pixel.png");
    @Nullable
    static final Image ICON_UNCHECKED = ToolsImages.getImage((String)"icons/icons_for_table_viewers/checkbox_unchecked_left_transparent_pixel.png");
    @Nullable
    static final Image ICON_UNCHECKED_DISABLED = ToolsImages.getImage((String)"icons/icons_for_table_viewers/checkbox_unchecked_disabled_left_transparent_pixel.png");
    private static final int COLUMN_NAME_WIDTH = 200;
    private static final int COLUMN_MONITOR_WIDTH = 100;
    private static int MAX_COLUMN_WIDTH = 110;
    @NonNull
    final GuiController guiController = GuiController.getInstance();

    public PeripheralClockWindow(@NonNull Composite parent) {
        FillLayout layout = new FillLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        parent.setLayout((Layout)layout);
        this.table = new Table(parent, 66308);
        this.tableViewer = new TableViewer(this.table);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.createNameColumn();
        this.createEnableColumn();
        this.createControlColumn();
        this.createSourceColumn();
        this.createDividerColumn();
        this.createDivTypeColumn();
        this.createFrequencyColumn();
        this.createMonitorColumn();
        this.createLowFrequencyColumn();
        this.createHighFrequencyColumn();
        this.registerSelectionListeners();
        this.tableViewer.setContentProvider((IContentProvider)PeripheralClockWindow.createContentProvider());
        IEventListener listener = new IEventListener(){

            public void handle(@NonNull ToolEvent event) {
                PeripheralClockWindow.this.refresh();
            }
        };
        GuiController.getInstance().addListener(226, listener);
        this.listeners.add(listener);
        this.refresh();
        this.table.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                PeripheralClockWindow.this.listeners.forEach(x -> GuiController.getInstance().removeModelListener(x));
            }
        });
        SWTFactoryProxy.INSTANCE.enableHtmlTooltipFor((ColumnViewer)this.tableViewer);
        SWTFactoryProxy.INSTANCE.setTestId((Widget)this.table, "peripheralClockViewTable");
    }

    private void createNameColumn() {
        TableViewerColumn colClocks = new TableViewerColumn(this.tableViewer, 0);
        colClocks.getColumn().setText(Messages.get().PeripheralClockWindow_ClockName);
        colClocks.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (!(element instanceof PeripheralClockElement)) {
                    return null;
                }
                ISetting setting = ((PeripheralClockElement)element).getClockOutput();
                if (setting != null) {
                    return setting.getElement().getName();
                }
                return "";
            }

            public String getToolTipText(Object element) {
                if (!(element instanceof PeripheralClockElement)) {
                    return null;
                }
                ISetting setting = ((PeripheralClockElement)element).getClockOutput();
                IClocksConfig activeConfig = PeripheralClockWindow.this.guiController.getProfile().getActiveConfig();
                if (activeConfig != null && setting != null) {
                    return setting.getToolTipText(activeConfig);
                }
                return "";
            }
        });
        TableColumn column = colClocks.getColumn();
        column.setWidth(200);
    }

    private void registerSelectionListeners() {
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IElement clockOutputElement;
                ISetting selectedSetting;
                PeripheralClockElement selectedSettingSelection = (PeripheralClockElement)((StructuredSelection)PeripheralClockWindow.this.tableViewer.getStructuredSelection()).getFirstElement();
                if (selectedSettingSelection != null && (selectedSetting = selectedSettingSelection.getClockOutput()) != null && (clockOutputElement = selectedSetting.getElement()) instanceof ClockOutput) {
                    String clockOutputId = ((ClockOutput)clockOutputElement).getID();
                    PeripheralClockWindow.this.guiController.setSelectedElement(clockOutputId, (Object)PeripheralClockWindow.this);
                }
            }
        });
    }

    private void createEnableColumn() {
        TableViewerColumn colClocks = new TableViewerColumn(this.tableViewer, 0);
        colClocks.getColumn().setText(Messages.get().PeripheralClockWindow_Enable);
        colClocks.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return "";
            }

            public Image getImage(Object element) {
                if (!(element instanceof PeripheralClockElement)) {
                    return null;
                }
                PeripheralClockElement peripheralClockElement = (PeripheralClockElement)element;
                ISetting clockGateEnableSetting = peripheralClockElement.getClockGateEnableSetting();
                IClocksConfig activeConfig = PeripheralClockWindow.this.guiController.getProfile().getActiveConfig();
                if (activeConfig != null) {
                    boolean checked = clockGateEnableSetting.isEnabled(activeConfig);
                    if (peripheralClockElement.getClockGateMainSetting() == null) {
                        return checked ? ICON_CHECKED_DISABLED : ICON_UNCHECKED_DISABLED;
                    }
                    return checked ? ICON_CHECKED : ICON_UNCHECKED;
                }
                return ICON_UNCHECKED_DISABLED;
            }
        });
        colClocks.setEditingSupport(new EditingSupport((ColumnViewer)this.tableViewer){

            protected void setValue(Object element, Object value) {
            }

            protected Object getValue(Object element) {
                return null;
            }

            /*
             * Issues handling annotations - annotations may be inaccurate
             */
            protected CellEditor getCellEditor(Object element) {
                if (!(element instanceof PeripheralClockElement)) {
                    return null;
                }
                ISetting setting = ((PeripheralClockElement)element).getClockGateMainSetting();
                IClocksProfile profile = PeripheralClockWindow.this.guiController.getProfile();
                IClocksConfig config = profile.getActiveConfig();
                if (config != null && setting != null) {
                    ConfigElement configElem = (ConfigElement)setting.getElement();
                    @NonNull Collection elemList = configElem.getItems();
                    IConfigElementItem activeItem = configElem.getActiveItem(config);
                    IConfigElementItem negatedItem = elemList.stream().filter(item -> !item.equals(activeItem)).findFirst().get();
                    config.setSettingValue(setting, new SettingValue((Object)negatedItem.getID(), negatedItem.getName()), true, true);
                    profile.regenerateCode();
                    PeripheralClockWindow.this.guiController.fireListeners(new ToolEvent.Builder(2).build());
                }
                return null;
            }

            protected boolean canEdit(Object element) {
                if (!(element instanceof PeripheralClockElement)) {
                    return false;
                }
                ISetting setting = ((PeripheralClockElement)element).getClockGateMainSetting();
                return setting != null;
            }
        });
        TableColumn column = colClocks.getColumn();
        column.pack();
        int colWidth = column.getWidth();
        if (colWidth == 0) {
            column.setWidth(MAX_COLUMN_WIDTH);
        }
    }

    private void createControlColumn() {
        TableViewerColumn colClocks = new TableViewerColumn(this.tableViewer, 0);
        colClocks.getColumn().setText(Messages.get().PeripheralClockWindow_Control);
        colClocks.setLabelProvider((CellLabelProvider)this.createColumnLabelProvider(PeripheralClockElement.PeripheralSettingType.CONTROL));
        colClocks.setEditingSupport(this.createEditingSupport(PeripheralClockElement.PeripheralSettingType.CONTROL));
        TableColumn column = colClocks.getColumn();
        column.pack();
        int colWidth = column.getWidth();
        if (colWidth == 0) {
            column.setWidth(MAX_COLUMN_WIDTH);
        }
    }

    private void createSourceColumn() {
        TableViewerColumn colClocks = new TableViewerColumn(this.tableViewer, 0);
        colClocks.getColumn().setText(Messages.get().PeripheralClockWindow_Source);
        colClocks.setLabelProvider((CellLabelProvider)this.createColumnLabelProvider(PeripheralClockElement.PeripheralSettingType.SELECT));
        colClocks.setEditingSupport(this.createEditingSupport(PeripheralClockElement.PeripheralSettingType.SELECT));
        TableColumn column = colClocks.getColumn();
        column.pack();
        int colWidth = column.getWidth();
        if (colWidth == 0) {
            column.setWidth(MAX_COLUMN_WIDTH);
        }
    }

    private void createDividerColumn() {
        TableViewerColumn colClocks = new TableViewerColumn(this.tableViewer, 0);
        colClocks.getColumn().setText(Messages.get().PeripheralClockWindow_Divider);
        colClocks.setLabelProvider((CellLabelProvider)this.createColumnLabelProvider(PeripheralClockElement.PeripheralSettingType.DIVIDE));
        colClocks.setEditingSupport(this.createEditingSupport(PeripheralClockElement.PeripheralSettingType.DIVIDE));
        TableColumn column = colClocks.getColumn();
        column.pack();
        int colWidth = column.getWidth();
        if (colWidth == 0) {
            column.setWidth(MAX_COLUMN_WIDTH);
        }
    }

    private void createDivTypeColumn() {
        TableViewerColumn colClocks = new TableViewerColumn(this.tableViewer, 0);
        colClocks.getColumn().setText(Messages.get().PeripheralClockWindow_DivType);
        colClocks.setLabelProvider((CellLabelProvider)this.createColumnLabelProvider(PeripheralClockElement.PeripheralSettingType.DIV_TYPE));
        colClocks.setEditingSupport(this.createEditingSupport(PeripheralClockElement.PeripheralSettingType.DIV_TYPE));
        TableColumn column = colClocks.getColumn();
        column.pack();
        int colWidth = column.getWidth();
        if (colWidth == 0) {
            column.setWidth(MAX_COLUMN_WIDTH);
        }
    }

    private void createFrequencyColumn() {
        TableViewerColumn colClocks = new TableViewerColumn(this.tableViewer, 0);
        colClocks.getColumn().setText(Messages.get().PeripheralClockWindow_Frequency);
        colClocks.setLabelProvider((CellLabelProvider)this.createColumnLabelProvider(PeripheralClockElement.PeripheralSettingType.OUTPUT));
        colClocks.setEditingSupport(this.createEditingSupport(PeripheralClockElement.PeripheralSettingType.OUTPUT));
        TableColumn column = colClocks.getColumn();
        column.pack();
        int colWidth = column.getWidth();
        if (colWidth == 0) {
            column.setWidth(MAX_COLUMN_WIDTH);
        }
    }

    private void createMonitorColumn() {
        TableViewerColumn colClocks = new TableViewerColumn(this.tableViewer, 0);
        colClocks.getColumn().setText(Messages.get().PeripheralClockWindow_Monitor);
        colClocks.setLabelProvider((CellLabelProvider)this.createColumnLabelProvider(PeripheralClockElement.PeripheralSettingType.CMU_ENABLE));
        colClocks.setEditingSupport(this.createEditingSupport(PeripheralClockElement.PeripheralSettingType.CMU_ENABLE));
        TableColumn column = colClocks.getColumn();
        column.setWidth(100);
    }

    private void createLowFrequencyColumn() {
        TableViewerColumn colClocks = new TableViewerColumn(this.tableViewer, 0);
        colClocks.getColumn().setText(Messages.get().PeripheralClockWindow_LowFrequency);
        colClocks.setLabelProvider((CellLabelProvider)this.createColumnLabelProvider(PeripheralClockElement.PeripheralSettingType.LOW_FREQ));
        colClocks.setEditingSupport(this.createEditingSupport(PeripheralClockElement.PeripheralSettingType.LOW_FREQ));
        TableColumn column = colClocks.getColumn();
        column.pack();
        int colWidth = column.getWidth();
        if (colWidth == 0) {
            column.setWidth(MAX_COLUMN_WIDTH);
        }
    }

    private void createHighFrequencyColumn() {
        TableViewerColumn colClocks = new TableViewerColumn(this.tableViewer, 0);
        colClocks.getColumn().setText(Messages.get().PeripheralClockWindow_HighFrequency);
        colClocks.setLabelProvider((CellLabelProvider)this.createColumnLabelProvider(PeripheralClockElement.PeripheralSettingType.HIGH_FREQ));
        colClocks.setEditingSupport(this.createEditingSupport(PeripheralClockElement.PeripheralSettingType.HIGH_FREQ));
        TableColumn column = colClocks.getColumn();
        column.pack();
        int colWidth = column.getWidth();
        if (colWidth == 0) {
            column.setWidth(MAX_COLUMN_WIDTH);
        }
    }

    private static @NonNull IStructuredContentProvider createContentProvider() {
        return new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return (Object[])inputElement;
            }
        };
    }

    private static @Nullable IClockElement getIClockElementSuccesor(@Nullable IClockElement root, Class<?> target) {
        if (root == null) {
            return null;
        }
        for (IClockElement elem : root.getSuccessors()) {
            if (!elem.getClass().equals(target)) continue;
            return elem;
        }
        return null;
    }

    private static @Nullable PeripheralClockElement getPeripheralClockElement(@NonNull IClockElement gate) {
        ClockGate clockGate = (ClockGate)gate;
        EnableSetting clockGateEnableSetting = clockGate.getEnableSetting();
        ISetting clockGateSetting = clockGate.getMainSetting();
        if (clockGateEnableSetting == null || clockGateSetting != null && ((ConfigElement)clockGateSetting.getElement()).getItems().size() != 2) {
            return null;
        }
        return new PeripheralClockElement(clockGateSetting, (ISetting)clockGateEnableSetting);
    }

    private static @Nullable PeripheralClockElement getClockElementCase1(@NonNull IClockElement gate) {
        PeripheralClockElement newElement = PeripheralClockWindow.getPeripheralClockElement(gate);
        if (newElement == null) {
            return null;
        }
        IClockElement element = PeripheralClockWindow.getIClockElementSuccesor(gate, ComponentOutput.class);
        if (element != null && (element = PeripheralClockWindow.getIClockElementSuccesor(element, ClockOutput.class)) != null) {
            newElement.setClockOutput(((ClockOutput)element).getMainSetting());
            IClockElement elementPredecessor = (IClockElement)gate.getPredecessors().toArray()[0];
            if (elementPredecessor instanceof Prescaler) {
                newElement.setPrescaler(((Prescaler)elementPredecessor).getFrequencyModifierSetting());
                elementPredecessor = (IClockElement)elementPredecessor.getPredecessors().toArray()[0];
            }
            PeripheralClockWindow.setCMUSettings(element, newElement);
            if (elementPredecessor instanceof ClockSelect) {
                newElement.setClockSelect(((ClockSelect)elementPredecessor).getMainSetting());
                return newElement;
            }
        }
        return null;
    }

    private static @Nullable PeripheralClockElement getClockElementCase2(@NonNull IClockElement gate) {
        PeripheralClockElement newElement = PeripheralClockWindow.getPeripheralClockElement(gate);
        if (newElement == null) {
            return null;
        }
        IClockElement element = PeripheralClockWindow.getIClockElementSuccesor(gate, ClockOutput.class);
        if (element != null) {
            newElement.setClockOutput(((ClockOutput)element).getMainSetting());
            IClockElement elementPredecessor = (IClockElement)gate.getPredecessors().toArray()[0];
            if (elementPredecessor instanceof ComponentOutput) {
                if ((elementPredecessor = (IClockElement)elementPredecessor.getPredecessors().toArray()[0]) instanceof Prescaler) {
                    newElement.setPrescaler(((Prescaler)elementPredecessor).getFrequencyModifierSetting());
                    elementPredecessor = (IClockElement)elementPredecessor.getPredecessors().toArray()[0];
                }
                PeripheralClockWindow.setCMUSettings(element, newElement);
                if (elementPredecessor instanceof ClockSelect) {
                    newElement.setClockSelect(((ClockSelect)elementPredecessor).getMainSetting());
                    return newElement;
                }
            }
        }
        return null;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static void setCMUSettings(IClockElement clockOutput, PeripheralClockElement newElement) {
        ClockOutput.CMU cmuFreq = ((ClockOutput)clockOutput).getCmuFreq();
        if (cmuFreq != null) {
            newElement.setControl(cmuFreq.getControlSetting());
            ISetting prescaler = newElement.getPrescaler();
            if (prescaler != null) {
                IClockElement clockElement = (IClockElement)prescaler.getElement();
                @NonNull List clockElementSettings = clockElement.getLocalConfigElementSettings();
                for (ISetting setting : clockElementSettings) {
                    if (!setting.getId().equals(cmuFreq.getDivTypeID())) continue;
                    newElement.setDivType(setting);
                    break;
                }
            }
            newElement.setEnableCMU(cmuFreq.getEnableCMUSetting());
            newElement.setLowFreq(cmuFreq.getLowFreqSetting());
            newElement.setHighFreq(cmuFreq.getHighFreqSetting());
        }
    }

    void refresh() {
        IMcu mcu = GuiController.getInstance().getProfile().getMcu();
        TreeSet<@NonNull PeripheralClockElement> peripheralElements = new TreeSet<PeripheralClockElement>(new SortAscend());
        for (Map.Entry elem : mcu.getAllElements().entrySet()) {
            IClockElement val = (IClockElement)elem.getValue();
            if (!(val instanceof ClockGate)) continue;
            PeripheralClockElement newElement = PeripheralClockWindow.getClockElementCase1(val);
            if (newElement == null) {
                newElement = PeripheralClockWindow.getClockElementCase2(val);
            }
            if (newElement == null) continue;
            peripheralElements.add(newElement);
        }
        this.tableViewer.setInput((Object)peripheralElements.toArray());
    }

    private @NonNull ColumnLabelProvider createColumnLabelProvider(final @NonNull PeripheralClockElement.PeripheralSettingType type) {
        return new ColumnLabelProvider(){

            public String getText(Object element) {
                IClocksConfig activeConfig;
                if (!(element instanceof PeripheralClockElement)) {
                    return null;
                }
                ISetting setting = ((PeripheralClockElement)element).getSetting(type);
                if (setting != null && (activeConfig = PeripheralClockWindow.this.guiController.getProfile().getActiveConfig()) != null) {
                    LockState lockState;
                    SettingValue value = activeConfig.getSettingsConfig().getSettingValue(setting);
                    String uiValue = value.getUiValue();
                    if (setting.isUserLockable() && (lockState = activeConfig.getSettingsConfig().getLockState(setting)) != null && !lockState.getUiValue().equals(uiValue)) {
                        return UtilsText.safeString((String)String.format("%s [%s]", lockState.getUiValue(), uiValue));
                    }
                    return SettingEditorHelper.getUiValueToShow((ISetting)setting, (SettingValue)value);
                }
                return "";
            }

            public String getToolTipText(Object element) {
                if (!(element instanceof PeripheralClockElement)) {
                    return null;
                }
                ISetting setting = ((PeripheralClockElement)element).getSetting(type);
                IClocksConfig activeConfig = PeripheralClockWindow.this.guiController.getProfile().getActiveConfig();
                if (activeConfig != null && setting != null) {
                    return setting.getToolTipText(activeConfig);
                }
                return "";
            }

            public Color getForeground(Object element) {
                IClocksConfig activeConfig;
                if (!(element instanceof PeripheralClockElement)) {
                    return null;
                }
                ISetting setting = ((PeripheralClockElement)element).getSetting(type);
                if (setting != null && (activeConfig = PeripheralClockWindow.this.guiController.getProfile().getActiveConfig()) != null) {
                    SettingValue value = activeConfig.getSettingsConfig().getSettingValue(setting);
                    if (!setting.isValid(value, activeConfig)) {
                        return ToolsColors.SwToolsColors.getColor((String)"com.nxp.swtools.utils.error_FG");
                    }
                    if (!setting.isEditable(activeConfig) || !setting.isEnabled(activeConfig)) {
                        return PeripheralClockWindow.this.table.getDisplay().getSystemColor(18);
                    }
                }
                return super.getForeground(element);
            }
        };
    }

    private @NonNull EditingSupport createEditingSupport(final @NonNull PeripheralClockElement.PeripheralSettingType type) {
        return new EditingSupport((ColumnViewer)this.tableViewer){

            protected Object getValue(Object element) {
                IClocksConfig activeConfig;
                if (!(element instanceof PeripheralClockElement)) {
                    return null;
                }
                ISetting setting = ((PeripheralClockElement)element).getSetting(type);
                if (setting != null && (activeConfig = PeripheralClockWindow.this.guiController.getProfile().getActiveConfig()) != null) {
                    SettingValue selectedValue = activeConfig.getSettingsConfig().getSettingValue(setting);
                    List allowedValues = setting.getValues(activeConfig);
                    if (!(allowedValues == null || setting.isComboSuppressionAllowed() && allowedValues.size() > 256)) {
                        int selectedValuePosition = allowedValues.indexOf(selectedValue);
                        return selectedValuePosition;
                    }
                    return SettingEditorHelper.getValue((ISetting)setting, (IClocksConfig)activeConfig);
                }
                return null;
            }

            protected void setValue(Object element, Object value) {
                if (!(element instanceof PeripheralClockElement)) {
                    return;
                }
                ISetting setting = ((PeripheralClockElement)element).getSetting(type);
                if (setting != null && SettingEditorHelper.setValue((ISetting)setting, (Object)value, null)) {
                    PeripheralClockWindow.this.guiController.fireListeners(new ToolEvent.Builder(162).build());
                }
            }

            protected CellEditor getCellEditor(Object element) {
                IClocksConfig activeConfig;
                if (!(element instanceof PeripheralClockElement)) {
                    return null;
                }
                ISetting setting = ((PeripheralClockElement)element).getSetting(type);
                if (setting != null && (activeConfig = PeripheralClockWindow.this.guiController.getProfile().getActiveConfig()) != null) {
                    Control editorControl;
                    TextCellEditor editor = null;
                    String[] values = SettingEditorHelper.getUiValuesForCombo((ISetting)setting);
                    if (values != null) {
                        InstantSearchCellEditor instantSearchListEditor = new InstantSearchCellEditor((Composite)PeripheralClockWindow.this.table, values, 0);
                        if (setting.getType().equals((Object)SettingType.FREQUENCY_OUTPUT)) {
                            instantSearchListEditor.setAllowCustomValue(true);
                        }
                        editor = instantSearchListEditor;
                    }
                    if (editor == null && (editorControl = (editor = new TextCellEditor((Composite)PeripheralClockWindow.this.table)).getControl()) instanceof Text) {
                        ((Text)editorControl).setTextLimit(20);
                    }
                    SWTFactoryProxy.INSTANCE.setHtmlTooltip(editor.getControl(), SettingEditorHelper.getEditorToolTip((ISetting)setting));
                    return editor;
                }
                return null;
            }

            protected boolean canEdit(Object element) {
                IClocksConfig activeConfig;
                if (!(element instanceof PeripheralClockElement)) {
                    return false;
                }
                ISetting setting = ((PeripheralClockElement)element).getSetting(type);
                if (setting != null && (activeConfig = PeripheralClockWindow.this.guiController.getProfile().getActiveConfig()) != null) {
                    return setting.isEditable(activeConfig);
                }
                return false;
            }
        };
    }

    static class SortAscend
    implements Comparator<PeripheralClockElement>,
    Serializable {
        private static final long serialVersionUID = 1L;

        SortAscend() {
        }

        @Override
        public int compare(PeripheralClockElement arg0, PeripheralClockElement arg1) {
            ISetting settingArg0 = arg0.getClockOutput();
            ISetting settingArg1 = arg1.getClockOutput();
            if (settingArg0 != null && settingArg1 != null) {
                return settingArg0.getElement().getName().compareTo(settingArg1.getElement().getName());
            }
            return 0;
        }
    }
}

