/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.gui;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.periphs.controller.Controller;
import com.nxp.swtools.periphs.gui.handler.MigrationOfferDialogHelper;
import com.nxp.swtools.periphs.gui.view.componentsettings.CollapsibleSettingsStorageHelper;
import com.nxp.swtools.periphs.gui.view.componentsettings.ComponentSettingViewHelper;
import com.nxp.swtools.periphs.gui.view.componentsettings.ProvidableSettingsSelectionStorageHelper;
import com.nxp.swtools.utils.profiler.Profiler;
import java.util.Objects;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PerspectiveAdapter;
import org.eclipse.ui.PlatformUI;

public class PeripheralsStartup
implements IStartup {
    public void earlyStartup() {
        if (SWToolsProperties.isPropertyTrue((String)"com.nxp.swtools.profiler")) {
            Profiler.getInstance((Object)"Peripherals").enableLogging();
        }
        Controller.getInstance();
        if (!SWToolsProperties.isHeadlessOn()) {
            PerspectiveAdapter perspectiveListener = new PerspectiveAdapter(){

                public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
                    if (perspective.getId().equals("com.nxp.swtools.periphs.gui.perspective")) {
                        Controller.getInstance().setReactToOtherToolChangesImmediately(true);
                        Controller.getInstance().softRefresh();
                        MigrationOfferDialogHelper.perspectiveActivated();
                    }
                }

                public void perspectiveDeactivated(@Nullable IWorkbenchPage page, @Nullable IPerspectiveDescriptor perspective) {
                    super.perspectiveDeactivated(page, perspective);
                    if (page == null) {
                        return;
                    }
                    if (perspective == null) {
                        return;
                    }
                    if (perspective.getId().equals("com.nxp.swtools.periphs.gui.perspective")) {
                        Controller.getInstance().setReactToOtherToolChangesImmediately(false);
                    }
                }

                public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
                    if (perspective.getId().equals("com.nxp.swtools.periphs.gui.perspective")) {
                        if (changeId.equals("reset")) {
                            ComponentSettingViewHelper.getInstance().setRemoveState(true);
                        }
                        if (changeId.equals("resetComplete")) {
                            ComponentSettingViewHelper.getInstance().setRemoveState(false);
                            IViewPart viewPart = ComponentSettingViewHelper.getViewPart();
                            if (viewPart == null) {
                                return;
                            }
                            IViewSite viewSite = viewPart.getViewSite();
                            if (viewSite == null) {
                                return;
                            }
                        }
                        if (changeId.equals("viewShow")) {
                            Controller.getInstance().setReactToOtherToolChangesImmediately(true);
                        }
                    }
                }
            };
            IWorkbench workbench = PlatformUI.getWorkbench();
            ProvidableSettingsSelectionStorageHelper.getInstance();
            CollapsibleSettingsStorageHelper.getInstance();
            ComponentSettingViewHelper.getInstance();
            Objects.requireNonNull(workbench.getActiveWorkbenchWindow()).addPerspectiveListener((IPerspectiveListener)perspectiveListener);
            workbench.addWorkbenchListener(new IWorkbenchListener(){

                public boolean preShutdown(@Nullable IWorkbench activeWorkbench, boolean forced) {
                    ComponentSettingViewHelper viewHelper = ComponentSettingViewHelper.getInstance();
                    if (viewHelper != null) {
                        viewHelper.switchRemoveState();
                        viewHelper.saveEditors();
                    } else if (!$assertionsDisabled) {
                        throw new AssertionError((Object)"Null ComponentSettingViewHelper.getInstance()");
                    }
                    CollapsibleSettingsStorageHelper.getInstance().onShutdown();
                    ProvidableSettingsSelectionStorageHelper.getInstance().onShutdown();
                    return true;
                }

                public void postShutdown(@Nullable IWorkbench activeWorkbench) {
                }
            });
        }
    }
}

