/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.gui.controller;

import com.nxp.swtools.common.ui.utils.perspectives.PerspectivesHelper;
import com.nxp.swtools.common.ui.utils.swt.ScrolledCompositeHelper;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.controller.AController;
import com.nxp.swtools.periphs.controller.MigrationMessage;
import com.nxp.swtools.periphs.controller.migration.MigrationReportData;
import com.nxp.swtools.periphs.controller.migration.MigrationReportGenerator;
import com.nxp.swtools.periphs.gui.view.MigrationReportDialog;
import com.nxp.swtools.periphs.gui.view.componentsettings.ComponentSettingView;
import com.nxp.swtools.periphs.gui.view.componentsettings.ComponentSettingViewHelper;
import com.nxp.swtools.periphs.gui.view.componentsettings.GlobalComponentSettingView;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.resourcetables.model.config.ChildContext;
import com.nxp.swtools.resourcetables.model.config.IChild;
import com.nxp.swtools.resourcetables.model.config.IComponentConfig;
import com.nxp.swtools.resourcetables.model.config.IComponentInstanceConfig;
import com.nxp.swtools.utils.view.ToolView;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public abstract class APeriphGUIController
extends AController {
    protected static final Logger LOGGER = LogManager.getLogger(APeriphGUIController.class);

    public abstract boolean openConfigurationSettingsView(IViewSite var1, String var2, String var3, boolean var4, boolean var5);

    public abstract boolean openConfigurationSettingsView(IViewSite var1, String var2, boolean var3);

    public abstract void addPermittedOccurrenceOfView(String var1);

    public boolean openViewOfInstance(IViewSite viewSite, IComponentInstanceConfig instance, boolean activate) {
        String viewOnCreation = instance.getComponent().getDefaultViewId();
        if (!UtilsText.isEmpty((String)viewOnCreation)) {
            String viewOnCreationFinal = UtilsText.safeString((String)viewOnCreation);
            String identificationBase = instance.getUUID();
            IWorkbenchPage workbenchPage = viewSite.getPage();
            Set<@NonNull Integer> permittedOccurrences = ComponentSettingViewHelper.getInstance().getPermittedOccurrences(identificationBase);
            Integer lastOpenOccurrence = -1;
            for (Integer i : permittedOccurrences) {
                String identification = String.valueOf(identificationBase) + "|" + i.toString();
                boolean viewPresent = Arrays.asList(workbenchPage.getViewReferences()).stream().filter(x -> viewOnCreationFinal.equals(x.getId())).anyMatch(x -> identification.equals(x.getSecondaryId()));
                if (!viewPresent) {
                    return this.openView(UtilsText.safeString((String)viewOnCreation), identification, activate);
                }
                lastOpenOccurrence = i;
            }
            if (lastOpenOccurrence != -1) {
                return this.openView(UtilsText.safeString((String)viewOnCreation), String.valueOf(identificationBase) + "|" + lastOpenOccurrence.toString(), activate);
            }
            return false;
        }
        return this.openConfigurationSettingsView(viewSite, instance.getUUID(), activate);
    }

    public @Nullable IViewSite getCurrentViewSite() {
        IWorkbenchPart activePart = APeriphGUIController.getActivePart();
        if (activePart == null) {
            return null;
        }
        IWorkbenchPartSite site = activePart.getSite();
        if (site instanceof IViewSite) {
            return (IViewSite)site;
        }
        return null;
    }

    public @Nullable Control getDefaultControlOfActiveToolView() {
        IWorkbenchPart activePart = APeriphGUIController.getActivePart();
        if (activePart instanceof ToolView) {
            ToolView toolView = (ToolView)activePart;
            return toolView.getToolMainControl();
        }
        return null;
    }

    public void openViewOfChild(IChild child) {
        IViewSite currentViewSite = this.getCurrentViewSite();
        if (currentViewSite == null) {
            return;
        }
        ChildContext childContext = child.getChildContext();
        IComponentConfig componentConfig = childContext.getComponentConfig();
        if (componentConfig == null) {
            return;
        }
        IComponentInstanceConfig componentInstanceConfig = childContext.getComponentInstanceConfig();
        if (componentInstanceConfig != null) {
            String uuid = componentInstanceConfig.getUUID();
            if (uuid.isEmpty()) {
                this.openViewOfInstance(currentViewSite, componentInstanceConfig, true);
                Control defaultControlOfActiveView = this.getDefaultControlOfActiveToolView();
                if (defaultControlOfActiveView instanceof Composite) {
                    Composite composite = (Composite)defaultControlOfActiveView;
                    ComponentSettingView componentInstanceView = (ComponentSettingView)PerspectivesHelper.getViewById((String)"com.nxp.swtools.periphs.gui.view.componentsettings", (String)(String.valueOf(componentInstanceConfig.getType()) + "/" + componentInstanceConfig.getName()));
                    if (componentInstanceView != null) {
                        ComponentSettingView.focusOnChild((IViewPart)componentInstanceView, child);
                    } else {
                        ScrolledCompositeHelper.scrollToControlWithId((Composite)composite, (String)("periphsSettLabel_" + child.getId()));
                    }
                } else {
                    LOGGER.severe("[TOOL] Provided control of active tool view is either null or is not composite");
                }
            } else {
                ComponentSettingView.open(currentViewSite.getPage(), uuid, true, child);
            }
        } else {
            String componentType = componentConfig.getType();
            String componentName = componentConfig.getName();
            ComponentSettingView.open(currentViewSite.getPage(), componentType, componentName, true, true, child);
        }
    }

    public void openGlobalViewOfChild(IChild child) {
        IViewSite currentViewSite = this.getCurrentViewSite();
        if (currentViewSite == null) {
            return;
        }
        ChildContext childContext = child.getChildContext();
        IComponentConfig componentConfig = childContext.getComponentConfig();
        if (componentConfig == null) {
            return;
        }
        GlobalComponentSettingView.open(currentViewSite, componentConfig.getType(), true);
        Control defaultControlOfActiveView = this.getDefaultControlOfActiveToolView();
        if (defaultControlOfActiveView instanceof Composite) {
            IViewPart globalSettingsView = PerspectivesHelper.getViewById((String)"com.nxp.swtools.periphs.gui.view.globalcomponentsettings", null);
            if (globalSettingsView != null) {
                ComponentSettingView.focusOnChild(globalSettingsView, child);
            } else {
                ScrolledCompositeHelper.scrollToControlWithId((Composite)((Composite)defaultControlOfActiveView), (String)("periphsSettLabel_" + child.getId()));
            }
        } else {
            LOGGER.severe("[TOOL] Provided control of active tool view is either null or is not composite");
        }
    }

    private static @Nullable IWorkbenchPart getActivePart() {
        IWorkbenchPage activePage = APeriphGUIController.getActivePage();
        if (activePage == null) {
            return null;
        }
        return activePage.getActivePart();
    }

    private static @Nullable IWorkbenchPage getActivePage() {
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return null;
        }
        IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
        return activePage;
    }

    public boolean openView(String viewId) {
        IWorkbenchPage activePage = APeriphGUIController.getActivePage();
        if (activePage != null) {
            try {
                activePage.showView(viewId);
                return true;
            }
            catch (PartInitException e) {
                LOGGER.log(Level.SEVERE, "[TOOL] Requested view cannot be opened", e);
                return false;
            }
        }
        return false;
    }

    public boolean openView(String viewId, String secondaryId, boolean activate) {
        IWorkbenchPage activePage = APeriphGUIController.getActivePage();
        if (activePage != null) {
            try {
                activePage.showView(viewId, secondaryId, activate ? 1 : 2);
                return true;
            }
            catch (PartInitException e) {
                LOGGER.log(Level.SEVERE, "[TOOL] Requested view cannot be opened", e);
                return false;
            }
        }
        return false;
    }

    public int openMigrationReportDialog(Shell shell, MigrationMessage.ShowMode mode, List<CollectionsUtils.Pair<IComponentInstanceConfig, IComponentInstanceConfig>> list) {
        MigrationReportData reportData = MigrationReportGenerator.createHtmlReport((ISharedConfiguration)SharedConfigurationFactory.getSharedConfigurationSingleton(), (MigrationMessage.ShowMode)mode, list);
        if (reportData == null) {
            return 1;
        }
        return MigrationReportDialog.open(shell, reportData.getStringContent(), reportData.getMessageCount());
    }
}

