/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.gui.handler;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.periphs.controller.Controller;
import com.nxp.swtools.periphs.controller.tool_extension.IRefreshHandler;
import com.nxp.swtools.periphs.gui.view.DocumentationView;
import com.nxp.swtools.provider.toolchainproject.RefreshProjectHandler;
import com.nxp.swtools.utils.profiler.Profiler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

public class RefreshHandler
extends RefreshProjectHandler {
    public static final Logger LOGGER = LogManager.getLogger(RefreshHandler.class);

    public @Nullable Object execute(ExecutionEvent event) throws ExecutionException {
        super.execute(event);
        Profiler.getInstance((Object)"Peripherals").flush();
        Controller.getInstance().refresh();
        DocumentationView.refresh();
        IConfigurationElement[] configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor("com.nxp.swtools.plu.external_tools");
        int counter = 0;
        while (counter < configurationElements.length) {
            try {
                IRefreshHandler handler = (IRefreshHandler)configurationElements[counter].createExecutableExtension("handler");
                handler.refresh();
            }
            catch (CoreException e) {
                LOGGER.log(Level.SEVERE, "[TOOL] Failed to create handler for refresh event from external tools: ", e);
            }
            ++counter;
        }
        return null;
    }
}

