/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.gui.view;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.periphs.controller.APeriphController;
import com.nxp.swtools.periphs.controller.Controller;
import com.nxp.swtools.periphs.controller.MigrationHelper;
import com.nxp.swtools.periphs.gui.Messages;
import com.nxp.swtools.periphs.gui.controller.IControllerWrapper;
import com.nxp.swtools.periphs.gui.templates.component.ComponentTemplateCreationDialog;
import com.nxp.swtools.periphs.gui.view.DocumentationView;
import com.nxp.swtools.periphs.gui.view.EditCommentDialog;
import com.nxp.swtools.periphs.gui.view.MigrationOfferDialog;
import com.nxp.swtools.periphs.gui.view.PeripheralsView;
import com.nxp.swtools.periphs.gui.view.RemoveComponentInstancesDialog;
import com.nxp.swtools.periphs.gui.view.RemoveDialog;
import com.nxp.swtools.periphs.gui.view.componentsettings.ComponentSettingView;
import com.nxp.swtools.periphs.gui.view.componentsettings.ComponentSettingViewHelper;
import com.nxp.swtools.periphs.gui.view.componentsettings.ComponentSettingViewInput;
import com.nxp.swtools.periphs.model.config.ComponentConfig;
import com.nxp.swtools.provider.analytics.ActionAnalyticsBuilder;
import com.nxp.swtools.resourcetables.model.config.IChild;
import com.nxp.swtools.resourcetables.model.config.IChildProvidable;
import com.nxp.swtools.resourcetables.model.config.IComponentConfig;
import com.nxp.swtools.resourcetables.model.config.IComponentInstanceConfig;
import com.nxp.swtools.resourcetables.model.config.IFunctionalGroup;
import com.nxp.swtools.resourcetables.model.data.ConfigurationComponentTypeId;
import com.nxp.swtools.utils.resources.ToolsImages;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewSite;

public class ComponentMenuCreator {
    @NonNull
    IComponentSelectionProvider selectionProvider;
    @Nullable
    IPeripheralSelectionProvider peripheralSelectionProvider;
    @NonNull
    ComponentMenuOptions options;
    @NonNull
    IControllerWrapper controllerWrapper;

    public ComponentMenuCreator(@NonNull IComponentSelectionProvider selectionProvider, @NonNull ComponentMenuOptions options, @NonNull IControllerWrapper controllerWrapper) {
        this(selectionProvider, null, options, controllerWrapper);
    }

    public ComponentMenuCreator(@NonNull IComponentSelectionProvider selectionProvider, @Nullable IPeripheralSelectionProvider peripheralSelectionProvider, @NonNull ComponentMenuOptions options, @NonNull IControllerWrapper controllerWrapper) {
        this.selectionProvider = selectionProvider;
        this.peripheralSelectionProvider = peripheralSelectionProvider;
        this.options = options;
        this.controllerWrapper = controllerWrapper;
    }

    static @Nullable ConfigurationComponentTypeId getTypeId(@NonNull IChild child) {
        if (child instanceof IComponentConfig) {
            return ((IComponentConfig)child).getConfigCompTypeId();
        }
        if (child instanceof IComponentInstanceConfig) {
            return ((IComponentInstanceConfig)child).getConfigCompTypeId();
        }
        return null;
    }

    public void createMenu(@NonNull Control control, @NonNull IViewSite viewSite, @Nullable ISelectionProvider selectionProviderArg) {
        this.createMenu(CollectionsUtils.asList((Object)control), viewSite, selectionProviderArg);
    }

    public void createMenu(@NonNull List<@NonNull Control> controls, @NonNull IViewSite viewSite, @Nullable ISelectionProvider selectionProviderArg) {
        MenuManager menuMgr = this.createMenuManager(viewSite);
        for (Control control : controls) {
            Menu menu = menuMgr.createContextMenu(control);
            control.setMenu(menu);
            if (selectionProviderArg == null) continue;
            viewSite.registerContextMenu(menuMgr, selectionProviderArg);
        }
    }

    private @NonNull MenuManager createMenuManager(final @NonNull IViewSite viewSite) {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            private boolean isSomethingSelected() {
                return !ComponentMenuCreator.this.selectionProvider.getSelection().isEmpty();
            }

            private boolean isSystemComponentSelected() {
                for (IChild iChild : ComponentMenuCreator.this.selectionProvider.getSelection()) {
                    if (!(iChild instanceof IComponentConfig) || !((ComponentConfig)iChild).getId().equals("system")) continue;
                    return true;
                }
                return false;
            }

            private boolean canBeMigrated() {
                for (IChild iChild : ComponentMenuCreator.this.selectionProvider.getSelection()) {
                    IComponentInstanceConfig instanceConfig;
                    List replacementComponents;
                    if (!(iChild instanceof IComponentInstanceConfig) || !(replacementComponents = MigrationHelper.getComponentsThatReplacesThis((String)(instanceConfig = (IComponentInstanceConfig)iChild).getComponentTypeId(), (APeriphController)ComponentMenuCreator.this.controllerWrapper.getController())).isEmpty()) continue;
                    return false;
                }
                return true;
            }

            private boolean isDocumentedComponentSelected() {
                HashSet<@NonNull ConfigurationComponentTypeId> set = new HashSet<ConfigurationComponentTypeId>();
                for (IChild iChild : ComponentMenuCreator.this.selectionProvider.getSelection()) {
                    ConfigurationComponentTypeId typeId;
                    if (iChild == null) {
                        return false;
                    }
                    if (iChild instanceof IComponentInstanceConfig) {
                        IComponentInstanceConfig instance = (IComponentInstanceConfig)iChild;
                        if (ComponentMenuCreator.this.controllerWrapper.getController().isInstanceTypeMarkPeripheralAsUsed(instance)) continue;
                    }
                    if ((typeId = ComponentMenuCreator.getTypeId(iChild)) == null) {
                        return false;
                    }
                    set.add(typeId);
                }
                if (set.size() != 1) {
                    return false;
                }
                ConfigurationComponentTypeId configurationComponentTypeId = (ConfigurationComponentTypeId)set.toArray()[0];
                return configurationComponentTypeId.isDocumentationPresent();
            }

            private boolean isComponentInSelection() {
                for (IChild iChild : ComponentMenuCreator.this.selectionProvider.getSelection()) {
                    if (!(iChild instanceof IComponentConfig)) continue;
                    return true;
                }
                return false;
            }

            @Nullable IChild getSelectedItem() {
                Collection<? extends @NonNull IChild> selection = ComponentMenuCreator.this.selectionProvider.getSelection();
                return selection.isEmpty() ? null : selection.iterator().next();
            }

            @Nullable IChildProvidable getFunctionalGroup(@NonNull IChild child) {
                return child.getChildContext().getFunctionalGroup();
            }

            private boolean areSelectedItemsIn(@NonNull IFunctionalGroup group) {
                boolean result = true;
                for (IChild iChild : ComponentMenuCreator.this.selectionProvider.getSelection()) {
                    IComponentInstanceConfig instanceConfig;
                    if (!(iChild instanceof IComponentInstanceConfig) || this.getFunctionalGroup((IChild)(instanceConfig = (IComponentInstanceConfig)iChild)) == group) continue;
                    result = false;
                }
                return result;
            }

            /*
             * Issues handling annotations - annotations may be inaccurate
             */
            public void menuAboutToShow(IMenuManager manager) {
                String peripheral;
                IPeripheralSelectionProvider peripheralProvider = ComponentMenuCreator.this.peripheralSelectionProvider;
                if (manager == null) {
                    return;
                }
                ComponentMenuCreator.this.addOpenInstanceAction(manager, viewSite);
                ComponentMenuCreator.this.addOpenDuplicateViewAction(manager, viewSite);
                if (!this.isComponentInSelection()) {
                    ComponentMenuCreator.this.addEnableOrDisableInstancesAction(manager, this.isSomethingSelected());
                }
                @NonNull List selectedInstances = (List)ComponentMenuCreator.this.selectionProvider.getSelection().stream().filter(child -> child instanceof IComponentInstanceConfig).map(i -> (IComponentInstanceConfig)i).collect(CollectorsUtils.toList());
                if (peripheralProvider != null && (peripheral = peripheralProvider.getSelection()) != null) {
                    manager.add(ActionAnalyticsBuilder.action((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            PeripheralsView.configurePeripheral(peripheral, (this).ComponentMenuCreator.this.controllerWrapper.getController().getFunctionalGroup(), ComponentMenuCreator.this, (this).ComponentMenuCreator.this.controllerWrapper);
                        }
                    }).id("periphsActionAddNewComponent").text(Messages.get().ComponentMenuCreator_actionAddComponentInstance).image(ToolsImages.getImageDescriptor((String)"icons/add_circle.png")).build());
                    this.addMarkInstanceAsUserInitliazedAction(manager, peripheral);
                }
                if (!selectedInstances.isEmpty()) {
                    final IComponentInstanceConfig selectedInstance = (IComponentInstanceConfig)selectedInstances.get(0);
                    manager.add(ActionAnalyticsBuilder.action((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            EditCommentDialog.open(viewSite, selectedInstance, (this).ComponentMenuCreator.this.controllerWrapper);
                        }
                    }).id("periphsActionOpenEditComment").text(Messages.get().ComponentMenuCreator_actionOpenEditingDialogForComment).image(ToolsImages.getImageDescriptor((String)"icons/legend.png")).enabled(true).build());
                    manager.add(ActionAnalyticsBuilder.action(() -> ComponentMenuCreator.this.controllerWrapper.getController().setEditingLockOfInstance(selectedInstance, !selectedInstance.isEditingLocked())).id(selectedInstance.isEditingLocked() ? "periphsActionUnlockInstance" : "periphsActionLockInstance").text(selectedInstance.isEditingLocked() ? Messages.get().ComponentMenuCreator_ActionUnlockInstanceEditing : Messages.get().ComponentMenuCreator_ActionLockInstanceEditing).image(ToolsImages.getImageDescriptor((String)(selectedInstance.isEditingLocked() ? "icons/unlocked.png" : "icons/locked.png"))).enabled(true).build());
                }
                MenuManager moveMenu = new MenuManager(Messages.get().ComponentsView_Menu_MoveTo);
                for (final IFunctionalGroup group : Controller.getInstance().getProfile().getFunctionalGroups()) {
                    moveMenu.add(ActionAnalyticsBuilder.action((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            boolean change = false;
                            for (IChild iChild : (this).ComponentMenuCreator.this.selectionProvider.getSelection()) {
                                if (!(iChild instanceof IComponentInstanceConfig)) continue;
                                IComponentInstanceConfig instanceConfig = (IComponentInstanceConfig)iChild;
                                IFunctionalGroup oldGroup = instanceConfig.getChildContext().getFunctionalGroup();
                                if (oldGroup == null) {
                                    return;
                                }
                                instanceConfig.getChildContext().setGroup(group);
                                oldGroup.removeInstance(instanceConfig.getName());
                                group.addInstance(instanceConfig);
                                change = true;
                            }
                            if (change) {
                                (this).ComponentMenuCreator.this.controllerWrapper.getController().handleSettingChange(1, (Object)ComponentMenuCreator.this, UtilsText.safeString((String)com.nxp.swtools.periphs.controller.Messages.get().Controller_Action_MoveComponentInstance));
                            }
                        }
                    }).id("periphsActionMoveInstance_" + group.getUiName()).text(group.getUiName()).image(null).enabled(!this.areSelectedItemsIn(group)).build());
                }
                IChild currentSelection = this.getSelectedItem();
                boolean moveMenuVisible = false;
                boolean copyMenuVisible = false;
                if (currentSelection instanceof IComponentInstanceConfig) {
                    copyMenuVisible = true;
                    moveMenuVisible = true;
                    IComponentInstanceConfig currentComp = (IComponentInstanceConfig)currentSelection;
                    if (!ComponentMenuCreator.this.controllerWrapper.getController().canCreateInstances(currentComp.getComponent(), ComponentMenuCreator.this.controllerWrapper.getController().getFunctionalGroup().getName())) {
                        copyMenuVisible = false;
                    }
                    if (ComponentMenuCreator.this.controllerWrapper.getController().getMaximumNumberOfFunctionalGroups() == 1) {
                        moveMenuVisible = false;
                    }
                }
                moveMenu.setVisible(moveMenuVisible);
                MenuManager copyMenu = new MenuManager(Messages.get().ComponentsView_Menu_CopyTo);
                for (final IFunctionalGroup group : Controller.getInstance().getProfile().getFunctionalGroups()) {
                    copyMenu.add(ActionAnalyticsBuilder.action((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            boolean change = false;
                            for (IChild iChild : (this).ComponentMenuCreator.this.selectionProvider.getSelection()) {
                                if (!(iChild instanceof IComponentInstanceConfig)) continue;
                                IComponentInstanceConfig instanceConfig = (IComponentInstanceConfig)iChild;
                                IComponentInstanceConfig copyOfInstance = (this).ComponentMenuCreator.this.controllerWrapper.getController().createCopy(instanceConfig, group);
                                if (group.getName().equals((this).ComponentMenuCreator.this.controllerWrapper.getController().getFunctionalGroup().getName())) {
                                    ComponentSettingView.open(viewSite, copyOfInstance.getUUID(), true);
                                }
                                change = true;
                            }
                            if (change) {
                                (this).ComponentMenuCreator.this.controllerWrapper.getController().handleSettingChange(1, (Object)ComponentMenuCreator.this, UtilsText.safeString((String)com.nxp.swtools.periphs.controller.Messages.get().Controller_Action_CopyComponentInstance));
                            }
                        }
                    }).id("periphsActionCopyInstance_" + group.getUiName()).text(group.getUiName()).image(null).enabled(true).build());
                }
                copyMenu.setVisible(copyMenuVisible);
                manager.add(ActionAnalyticsBuilder.action(() -> {
                    Shell shell = viewSite.getShell();
                    if (!selectedInstances.isEmpty() && shell != null) {
                        ComponentTemplateCreationDialog.open(shell, (IComponentInstanceConfig)selectedInstances.get(0), ComponentMenuCreator.this.controllerWrapper);
                    }
                }).id("periphsActionOpenCreateTemplateDialog").text(Messages.get().ComponentsView_ComponentPopUp_CreateUseCase).image(null).enabled(this.isSomethingSelected() && !this.isSystemComponentSelected()).build());
                manager.add(ActionAnalyticsBuilder.action((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        Collection<? extends @NonNull IChild> selection = (this).ComponentMenuCreator.this.selectionProvider.getSelection();
                        if (!$assertionsDisabled && selection.isEmpty()) {
                            throw new AssertionError((Object)"Invalid selection - action supposed to be disabled");
                        }
                        IChild selectedItem = (IChild)selection.toArray()[0];
                        if (!$assertionsDisabled && selectedItem == null) {
                            throw new AssertionError();
                        }
                        ConfigurationComponentTypeId typeId = ComponentMenuCreator.getTypeId(selectedItem);
                        if (!$assertionsDisabled && typeId == null) {
                            throw new AssertionError((Object)"Invalid selection - action supposed to be disabled");
                        }
                        DocumentationView.open(viewSite, typeId.getTypeId(), true);
                    }
                }).id("periphsActionShowDocumentation").text(Messages.get().ComponentsView_ComponentPopUp_Documentation).image(ToolsImages.getImageDescriptor((String)"views/documentation.png")).enabled(this.isSomethingSelected() && this.isDocumentedComponentSelected() && !this.isSystemComponentSelected()).build());
                manager.add(ActionAnalyticsBuilder.action((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        Collection<? extends @NonNull IChild> selection = (this).ComponentMenuCreator.this.selectionProvider.getSelection();
                        if (!selection.isEmpty()) {
                            LinkedHashSet<@NonNull ComponentConfig> componentsToRemove = new LinkedHashSet<ComponentConfig>();
                            ArrayList<@NonNull IComponentInstanceConfig> componentInstancesToRemove = new ArrayList<IComponentInstanceConfig>();
                            for (IChild iChild : selection) {
                                if (iChild instanceof IComponentConfig) {
                                    ComponentConfig componentConfig = (ComponentConfig)iChild;
                                    if (componentConfig.getId().equals("system")) continue;
                                    componentsToRemove.add(componentConfig);
                                    continue;
                                }
                                if (!(iChild instanceof IComponentInstanceConfig)) continue;
                                componentInstancesToRemove.add((IComponentInstanceConfig)iChild);
                            }
                            Shell shell = viewSite.getShell();
                            if (shell != null && selection.size() > 1 && (this).ComponentMenuCreator.this.options.isAskWhatToRemove()) {
                                if (!$assertionsDisabled && !componentsToRemove.isEmpty()) {
                                    throw new AssertionError((Object)"When the option 'askWhatToRemove' is set to 'true', it is not possible to remove component configs");
                                }
                                RemoveComponentInstancesDialog.open(shell, componentInstancesToRemove);
                            } else {
                                boolean confirmed;
                                boolean bl = confirmed = shell == null ? true : RemoveDialog.open(shell, componentsToRemove, componentInstancesToRemove);
                                if (confirmed) {
                                    RemoveDialog.remove(componentsToRemove, componentInstancesToRemove, this);
                                }
                            }
                        }
                    }
                }).id("periphsActionRemoveComponent").text(Messages.get().ComponentsView_ComponentPopUp_Remove).image(ToolsImages.getImageDescriptor((String)"icons/remove_cross_circle.png")).enabled(this.isSomethingSelected() && !this.isSystemComponentSelected()).build());
                manager.add(ActionAnalyticsBuilder.action(() -> {
                    Shell shell = viewSite.getShell();
                    if (!$assertionsDisabled && shell == null) {
                        throw new AssertionError();
                    }
                    MigrationOfferDialog.open(shell, ComponentMenuCreator.this.controllerWrapper);
                }).id("periphsActionMigrateComponent").text(Messages.get().ComponentsView_ComponentPopUp_Migrate).image(ToolsImages.getImageDescriptor((String)"icons/properties.png")).enabled(this.isSomethingSelected() && !this.isSystemComponentSelected() && this.canBeMigrated()).build());
                manager.add((IContributionItem)moveMenu);
                manager.add((IContributionItem)copyMenu);
            }

            private void addMarkInstanceAsUserInitliazedAction(@NonNull IMenuManager manager, final @NonNull String peripheral) {
                manager.add(ActionAnalyticsBuilder.action((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        (this).ComponentMenuCreator.this.controllerWrapper.getController().markPeripheralAsUsed(peripheral);
                    }
                }).text(Messages.get().ComponentMenuCreator_markPeripheralAsUsed).id("periphsMarkPeripheralAsUsed").enabled(true).build());
            }
        });
        return menuMgr;
    }

    public void createMenu(@NonNull Viewer viewer, @NonNull IViewSite viewSite) {
        Control control = viewer.getControl();
        if (control != null) {
            this.createMenu(control, viewSite, (ISelectionProvider)viewer);
        }
    }

    void addOpenInstanceAction(@NonNull IMenuManager manager, @NonNull IViewSite viewSite) {
        MenuManager openMenu = new MenuManager(Messages.get().ComponentsView_Menu_Open);
        Collection<? extends @NonNull IChild> selection = this.selectionProvider.getSelection();
        Object[] selections = selection.toArray();
        int amountOfSelectedItems = selections.length;
        if (amountOfSelectedItems == 1) {
            Object object = selections[0];
            if (object instanceof IComponentInstanceConfig) {
                IComponentInstanceConfig instance = (IComponentInstanceConfig)object;
                String actionName = Messages.get().ComponentsView_Menu_Open;
                manager.add(ActionAnalyticsBuilder.action(() -> {
                    boolean bl = this.controllerWrapper.getGUIController().openViewOfInstance(viewSite, instance, true);
                }).id("periphsOpenComponentInstanceView").text(actionName).image(null).enabled(true).build());
            }
        } else {
            for (IChild iChild : selection) {
                if (!(iChild instanceof IComponentInstanceConfig)) continue;
                IComponentInstanceConfig instance = (IComponentInstanceConfig)iChild;
                String enabledMessage = instance.isEnabled() ? "" : "[" + Messages.get().ConfigurationState_Disabled + "]";
                String actionName = String.format("%s %s", instance.getUiName(), enabledMessage);
                openMenu.add(ActionAnalyticsBuilder.action(() -> {
                    boolean bl = this.controllerWrapper.getGUIController().openViewOfInstance(viewSite, instance, true);
                }).id("periphsOpenComponentInstanceView").text(actionName).image(null).enabled(true).build());
            }
            manager.add((IContributionItem)openMenu);
        }
    }

    void addOpenDuplicateViewAction(@NonNull IMenuManager manager, @NonNull IViewSite viewSite) {
        Collection<? extends @NonNull IChild> selection = this.selectionProvider.getSelection();
        Object[] selections = selection.toArray();
        int amountOfSelectedItems = selections.length;
        if (amountOfSelectedItems == 1) {
            Object selectedItem = selections[0];
            if (selectedItem instanceof IComponentInstanceConfig) {
                IComponentInstanceConfig iComponentInstanceConfig = (IComponentInstanceConfig)selectedItem;
                if (!this.controllerWrapper.getController().isInstanceTypeMarkPeripheralAsUsed(iComponentInstanceConfig)) {
                    ComponentSettingViewInput componentInput = new ComponentSettingViewInput(iComponentInstanceConfig.getType(), iComponentInstanceConfig.getName(), false);
                    componentInput.setUUID(iComponentInstanceConfig.getUUID());
                    String actionName = Messages.get().ComponentsView_Menu_OpenDuplicateView;
                    manager.add(ActionAnalyticsBuilder.action(() -> {
                        this.controllerWrapper.getGUIController().addPermittedOccurrenceOfView(ComponentSettingViewHelper.createSecondaryId(componentInput));
                        this.controllerWrapper.getGUIController().openViewOfInstance(viewSite, instance, true);
                    }).id("periphsOpenComponentInstanceDuplicateView").text(actionName).image(null).enabled(true).build());
                }
            }
        } else {
            MenuManager openMenu = new MenuManager(Messages.get().ComponentsView_Menu_OpenDuplicateView);
            for (IChild iChild : selection) {
                if (!(iChild instanceof IComponentInstanceConfig)) continue;
                IComponentInstanceConfig instance = (IComponentInstanceConfig)iChild;
                if (this.controllerWrapper.getController().isInstanceTypeMarkPeripheralAsUsed(instance)) continue;
                String enabledMessage = instance.isEnabled() ? "" : "[" + Messages.get().ConfigurationState_Disabled + "]";
                String actionName = String.format("%s %s", instance.getUiName(), enabledMessage);
                ComponentSettingViewInput componentInput = new ComponentSettingViewInput(instance.getType(), instance.getName(), false);
                componentInput.setUUID(instance.getUUID());
                openMenu.add(ActionAnalyticsBuilder.action(() -> {
                    this.controllerWrapper.getGUIController().addPermittedOccurrenceOfView(ComponentSettingViewHelper.createSecondaryId(componentInput));
                    this.controllerWrapper.getGUIController().openViewOfInstance(viewSite, instance, true);
                }).id("periphsOpenComponentInstanceDuplicateView").text(actionName).image(null).enabled(true).build());
            }
            manager.add((IContributionItem)openMenu);
        }
    }

    void addEnableOrDisableInstancesAction(@NonNull IMenuManager manager, boolean somethingSelected) {
        Collection<? extends @NonNull IChild> selection = this.selectionProvider.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        Object[] selections = selection.toArray();
        int amountOfSelectedItems = selections.length;
        if (amountOfSelectedItems == 1) {
            Object selectedItem = selections[0];
            if (selectedItem instanceof IComponentInstanceConfig) {
                IComponentInstanceConfig componentInstanceConfig = (IComponentInstanceConfig)selectedItem;
                String message = componentInstanceConfig.isEnabled() ? Messages.get().ComponentsView_Menu_EnabledState : Messages.get().ComponentsView_Menu_DisabledState;
                this.createEnableDisableInstanceAction(manager, somethingSelected, componentInstanceConfig, message);
            }
        } else {
            MenuManager enableDisableMenu = new MenuManager(Messages.get().ComponentsView_Menu_EnableSlashDisable);
            Object[] objectArray = selections;
            int n = selections.length;
            int n2 = 0;
            while (n2 < n) {
                Object selectedItem = objectArray[n2];
                if (selectedItem instanceof IComponentInstanceConfig) {
                    IComponentInstanceConfig componentInstanceConfig = (IComponentInstanceConfig)selectedItem;
                    String message = String.valueOf(componentInstanceConfig.isEnabled() ? Messages.get().ComponentsView_Menu_EnabledState : Messages.get().ComponentsView_Menu_DisabledState) + " " + componentInstanceConfig.getUiName();
                    this.createEnableDisableInstanceAction((IMenuManager)enableDisableMenu, somethingSelected, componentInstanceConfig, message);
                }
                ++n2;
            }
            manager.add((IContributionItem)enableDisableMenu);
        }
    }

    private void createEnableDisableInstanceAction(@NonNull IMenuManager manager, boolean enable, final @NonNull IComponentInstanceConfig componentInstanceConfig, @NonNull String message) {
        manager.add(ActionAnalyticsBuilder.action((Runnable)new Runnable(){

            @Override
            public void run() {
                IComponentInstanceConfig componentInstanceConfigLoc = componentInstanceConfig;
                ComponentMenuCreator.this.controllerWrapper.getController().setComponentInstancesEnabled(Arrays.asList(componentInstanceConfigLoc), !componentInstanceConfigLoc.isEnabled(), (Object)ComponentMenuCreator.this);
            }
        }).id("periphsActionEnableComponent").text(message).image(null).enabled(enable).build());
    }

    public static class ComponentMenuOptions {
        private final boolean askWhatToRemove;

        public ComponentMenuOptions(boolean askWhatToRemove) {
            this.askWhatToRemove = askWhatToRemove;
        }

        public boolean isAskWhatToRemove() {
            return this.askWhatToRemove;
        }
    }

    public static interface IComponentSelectionProvider {
        public @NonNull Collection<? extends @NonNull IChild> getSelection();
    }

    public static interface IPeripheralSelectionProvider {
        public @Nullable String getSelection();
    }
}

