/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.gui.view;

import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionMap;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.periphs.controller.Controller;
import com.nxp.swtools.periphs.gui.Messages;
import com.nxp.swtools.periphs.gui.view.ComponentsView;
import com.nxp.swtools.periphs.model.data.ConfigurationComponent;
import com.nxp.swtools.resourcetables.model.config.IComponentInstanceConfig;
import com.nxp.swtools.utils.progress.ProgressUtils;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class RemoveComponentInstancesDialog
extends MessageDialog {
    @NonNull
    public static final String ID = "com.nxp.swtools.periphs.gui.view.removeComponentDialog";
    @NonNull
    Controller controller = Controller.getInstance();
    @Nullable
    CheckboxTableViewer checkboxTableViewer;
    @Nullable
    Button cancelButton;
    @Nullable
    Button removeButton;
    @NonNull
    @NonNull Collection<@NonNull IComponentInstanceConfig> componentInstances;
    @NonNull
    Shell shell;

    public static @NonNull RemoveComponentInstancesDialog open(@NonNull Shell shell, @NonNull Collection<@NonNull IComponentInstanceConfig> instances) {
        RemoveComponentInstancesDialog dialog = new RemoveComponentInstancesDialog(shell, instances);
        dialog.setBlockOnOpen(false);
        dialog.open();
        return dialog;
    }

    private RemoveComponentInstancesDialog(@NonNull Shell shell, @NonNull Collection<@NonNull IComponentInstanceConfig> instances) {
        super(shell, Messages.get().ComponentsView_RemoveComponentInstancesDialog_Title, null, null, 5, new String[]{JFaceResources.getString((String)"yes"), JFaceResources.getString((String)"no")}, 0);
        this.shell = shell;
        this.componentInstances = instances;
    }

    protected Control createMessageArea(Composite parent) {
        Composite container = (Composite)super.createMessageArea(parent);
        Composite messageComposite = new Composite(container, 0);
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).hint(this.convertHorizontalDLUsToPixels(300), -1).applyTo((Control)messageComposite);
        messageComposite.setLayout((Layout)new GridLayout(1, true));
        Label messageHeader = new Label(messageComposite, 0);
        messageHeader.setText(Messages.get().ComponentsView_RemoveComponentInstancesDialog_Message);
        this.createTableViewer(messageComposite);
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.removeButton = this.createButton(parent, 2, JFaceResources.getString((String)"yes"), true);
        this.cancelButton = this.createButton(parent, 3, JFaceResources.getString((String)"no"), false);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 2) {
            this.okPressed();
        } else if (buttonId == 3) {
            this.cancelPressed();
        }
        super.buttonPressed(buttonId);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected void okPressed() {
        @NonNull @NonNull CollectionMap instancesToRemove = new CollectionMap();
        if (this.checkboxTableViewer != null) {
            List checked = CollectionsUtils.safeList((Object[])this.checkboxTableViewer.getCheckedElements());
            for (Object selectedItem : checked) {
                if (selectedItem == null || !(selectedItem instanceof IComponentInstanceConfig)) continue;
                IComponentInstanceConfig selectedItemInstance = (IComponentInstanceConfig)selectedItem;
                this.componentInstances.stream().filter(x -> x.getName().equals(selectedItemInstance.getName())).forEach(x -> {
                    boolean bl = instancesToRemove.add((Object)x.getComponent().getId(), (Object)x.getName());
                });
            }
        }
        if (this.removeButton != null) {
            this.controller.runTransaction(() -> {
                ProgressUtils.run(m -> {
                    boolean bl = this.controller.removeComponentInstances(instancesToRemove, (Object)this.removeButton);
                });
                RemoveComponentInstancesDialog.removeLastInstanceDialog(instancesToRemove.keySet());
            });
        }
        super.okPressed();
    }

    private void createTableViewer(@NonNull Composite composite) {
        CheckboxTableViewer viewer;
        final Composite tableViewerComposite = new Composite(composite, 0);
        GridLayout layout = new GridLayout(1, true);
        tableViewerComposite.setLayout((Layout)layout);
        tableViewerComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.checkboxTableViewer = viewer = CheckboxTableViewer.newCheckList((Composite)tableViewerComposite, (int)0);
        SWTFactoryProxy.INSTANCE.setTestId((Widget)viewer.getTable(), "periphsRemoveCompInstShellList");
        viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                RemoveComponentInstancesDialog.setButtonState(RemoveComponentInstancesDialog.this.removeButton, viewer.getCheckedElements());
            }
        });
        viewer.setLabelProvider((IBaseLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (!$assertionsDisabled && !(element instanceof IComponentInstanceConfig)) {
                    throw new AssertionError();
                }
                return ((IComponentInstanceConfig)element).getUiName();
            }
        });
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                viewer.getTable().deselectAll();
                tableViewerComposite.setFocus();
                tableViewerComposite.forceFocus();
            }
        });
        viewer.setInput(this.componentInstances);
        viewer.setAllChecked(true);
        GridData tableLayoutData = new GridData(4, 4, true, true);
        viewer.getTable().setLayoutData((Object)tableLayoutData);
        Label confirmation = new Label(composite, 0);
        confirmation.setText(Messages.get().ComponentsView_RemoveComponentInstancesDialog_Confirmation);
    }

    static void setButtonState(@Nullable Button button, Object @Nullable [] checked) {
        if (button != null) {
            button.setEnabled(checked != null ? checked.length != 0 : false);
        }
    }

    public static @NonNull String formatInstanceOutput(@NonNull IComponentInstanceConfig componentInstance) {
        StringBuilder output = new StringBuilder();
        output.append(componentInstance.getUiName());
        output.append(" ");
        output.append("[");
        output.append(componentInstance.getComponent().getLabel(componentInstance.getExpressionContext()));
        output.append("]");
        return UtilsText.safeString((String)output.toString());
    }

    public static void removeLastInstanceDialog(@Nullable Set<@NonNull String> componentsToCheck) {
        Controller controller = Controller.getInstance();
        if (componentsToCheck != null) {
            for (String affectedComponent : componentsToCheck) {
                if (!controller.getProfile().isComponentConfigured(affectedComponent) || !controller.getAllComponentInstances(affectedComponent).isEmpty()) continue;
                boolean shouldBeRemoved = true;
                ConfigurationComponent configurationComponent = controller.getConfigurationComponent(affectedComponent);
                if (configurationComponent != null && configurationComponent.getGlobalConfigSet() != null) {
                    shouldBeRemoved = MessageDialog.openQuestion(null, (String)Messages.get().ComponentsView_RemoveComponentDialog_RemovingLastInstance_Title, (String)MessageFormat.format(UtilsText.safeString((String)Messages.get().ComponentsView_RemoveComponentDialog_RemovingLastInstance_Message), configurationComponent.getLabel(controller.getProfile().getExpressionContext())));
                }
                if (!shouldBeRemoved) continue;
                ProgressUtils.run(m -> {
                    boolean bl = controller.removeComponents((Collection)CollectionsUtils.asList((Object)affectedComponent), ComponentsView.class);
                });
            }
        }
    }
}

