/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.gui.view;

import com.nxp.swtools.common.ui.utils.swt.FontFactory;
import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionMap;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.periphs.controller.Controller;
import com.nxp.swtools.periphs.gui.Messages;
import com.nxp.swtools.periphs.gui.view.RemoveComponentInstancesDialog;
import com.nxp.swtools.periphs.gui.view.componentsettings.CollapsibleSettingsStorageHelper;
import com.nxp.swtools.periphs.gui.view.componentsettings.ProvidableSettingsSelectionStorageHelper;
import com.nxp.swtools.periphs.model.config.ComponentConfig;
import com.nxp.swtools.resourcetables.model.config.IComponentInstanceConfig;
import com.nxp.swtools.utils.progress.ProgressUtils;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class RemoveDialog
extends MessageDialog {
    @Nullable
    private List<@NonNull String> components;
    @Nullable
    private CollectionMap<String, IComponentInstanceConfig> componentInstances;
    private static final int INDENT_COMPONENT_INSTANCES_FROM_LEFT = 15;
    private static final int SPACE_BETWEEN_COMPONENT_AND_COMPONENTINSTANCE_MESSAGES = 15;
    private static final int SPACE_BETWEEN_MESSAGE_AND_QUESTION = 15;

    private RemoveDialog(@Nullable Shell shell, @Nullable List<@NonNull String> components, @Nullable CollectionMap<String, IComponentInstanceConfig> componentInstances) {
        super(shell, Messages.get().RemoveDialog_Title, null, null, 3, new String[]{JFaceResources.getString((String)"yes"), JFaceResources.getString((String)"no")}, 0);
        this.components = components;
        this.componentInstances = componentInstances;
    }

    public static boolean open(@Nullable Shell shell, @Nullable LinkedHashSet<@NonNull ComponentConfig> componentConfigs, @Nullable List<@NonNull IComponentInstanceConfig> componentInstanceConfigs) {
        CollectionMap<String, IComponentInstanceConfig> componentInstancesToRemove;
        List<@NonNull String> components = RemoveDialog.getComponentsNames(componentConfigs);
        RemoveDialog dialog = new RemoveDialog(shell, components, componentInstancesToRemove = RemoveDialog.getComponentInstancesNames(componentConfigs, componentInstanceConfigs));
        return dialog.open() == 0;
    }

    private static @Nullable List<@NonNull String> getComponentsNames(@Nullable LinkedHashSet<@NonNull ComponentConfig> componentConfigs) {
        if (componentConfigs != null && !componentConfigs.isEmpty()) {
            return (List)componentConfigs.stream().map(cc -> cc.getUiName()).collect(CollectorsUtils.toList());
        }
        return null;
    }

    private static @Nullable CollectionMap<String, IComponentInstanceConfig> getComponentInstancesNames(@Nullable LinkedHashSet<@NonNull ComponentConfig> componentConfigs, @Nullable List<@NonNull IComponentInstanceConfig> componentInstanceConfigs) {
        CollectionMap componentInstancesToRemove = new CollectionMap();
        if (componentConfigs != null && !componentConfigs.isEmpty()) {
            Controller.getInstance().getProfile().getFunctionalGroups().stream().forEach(g -> componentConfigs.stream().map(cc -> g.getInstancesOfType(cc.getType())).filter(compInstConfigs -> !compInstConfigs.isEmpty()).flatMap(compInstConfigs -> compInstConfigs.stream()).forEach(cic -> {
                boolean bl = componentInstancesToRemove.add((Object)g.getUiName(), cic);
            }));
        }
        if (componentInstanceConfigs != null && !componentInstanceConfigs.isEmpty()) {
            Controller.getInstance().getProfile().getFunctionalGroups().stream().forEach(g -> componentInstanceConfigs.stream().filter(cc -> g.getInstances().containsValue(cc)).forEach(filteredCC -> {
                boolean bl = componentInstancesToRemove.add((Object)g.getUiName(), filteredCC);
            }));
        }
        return componentInstancesToRemove.isEmpty() ? null : componentInstancesToRemove;
    }

    private @NonNull String getRemoveComponentInstancesMessage(@NonNull String fnGroup) {
        String resultMessage = "";
        if (this.componentInstances != null) {
            resultMessage = Objects.requireNonNull(this.componentInstances.get((Object)fnGroup)).stream().map(ci -> String.valueOf(ci.getUiName()) + " [" + ci.getComponent().getLabel(ci.getExpressionContext()) + "]").collect(Collectors.joining("\r\n"));
        }
        return UtilsText.safeString((String)resultMessage);
    }

    private @NonNull String getRemoveComponentsMessage() {
        String resultMessage = "";
        List<@NonNull String> componentsLoc = this.components;
        if (componentsLoc != null) {
            resultMessage = componentsLoc.stream().collect(Collectors.joining("\r\n"));
        }
        return UtilsText.safeString((String)resultMessage);
    }

    protected @Nullable Control createCustomArea(@Nullable Composite parent) {
        Label confirmation = new Label(parent, 1024);
        confirmation.setText(Messages.get().RemoveDialog_Confirmation);
        GridDataFactory.fillDefaults().align(1, 0x1000008).grab(true, false).indent(0, 15).applyTo((Control)confirmation);
        return confirmation;
    }

    protected Control createMessageArea(Composite composite) {
        super.createMessageArea(composite);
        Composite messageComposite = new Composite(composite, 0);
        SWTFactoryProxy.INSTANCE.setTestId((Widget)messageComposite, "periphsRemoveDialogComposite");
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).hint(this.convertHorizontalDLUsToPixels(300), -1).applyTo((Control)messageComposite);
        messageComposite.setLayout((Layout)new GridLayout(1, true));
        this.createComponentsPart(messageComposite);
        this.createComponentInstancesPart(messageComposite);
        return messageComposite;
    }

    private void createComponentInstancesPart(@NonNull Composite messageComposite) {
        CollectionMap<String, IComponentInstanceConfig> componentInstancesLoc = this.componentInstances;
        if (componentInstancesLoc != null && !componentInstancesLoc.isEmpty()) {
            Label removingComponentInstances = new Label(messageComposite, 0);
            removingComponentInstances.setText(Messages.get().RemoveDialog_RemoveComponentInstances);
            FontFactory.changeStyle((Control)removingComponentInstances, (int)1);
            if (this.components != null) {
                GridData removingComponentInstancesLayoutData = new GridData(16384, 128, true, true);
                removingComponentInstancesLayoutData.verticalIndent = 15;
                removingComponentInstances.setLayoutData((Object)removingComponentInstancesLayoutData);
            }
            for (Map.Entry entry : componentInstancesLoc.entrySet()) {
                StringBuilder fromFnGroup = new StringBuilder();
                fromFnGroup.append(Messages.get().RemoveDialog_From);
                fromFnGroup.append(" ");
                fromFnGroup.append((String)entry.getKey());
                Label functionalGroupLabel = new Label(messageComposite, 0);
                functionalGroupLabel.setText(fromFnGroup.toString());
                Label componentInstancesInFnGroup = new Label(messageComposite, 0);
                componentInstancesInFnGroup.setText(this.getRemoveComponentInstancesMessage(UtilsText.safeString((String)((String)entry.getKey()))));
                GridData instancesLayoutData = new GridData(16384, 128, true, true);
                instancesLayoutData.horizontalIndent = 15;
                componentInstancesInFnGroup.setLayoutData((Object)instancesLayoutData);
            }
        }
    }

    private void createComponentsPart(@NonNull Composite messageComposite) {
        if (this.components != null && !this.components.isEmpty()) {
            Label removingComponents = new Label(messageComposite, 0);
            removingComponents.setText(Messages.get().RemoveDialog_RemoveComponents);
            FontFactory.changeStyle((Control)removingComponents, (int)1);
            Label componentsLabel = new Label(messageComposite, 0);
            componentsLabel.setText(this.getRemoveComponentsMessage());
        }
    }

    public static boolean remove(@Nullable LinkedHashSet<@NonNull ComponentConfig> componentConfigs, @Nullable Collection<@NonNull IComponentInstanceConfig> componentInstanceConfigs, @NonNull Object caller) {
        Supplier<Boolean> removeSupplier;
        Controller controller = Controller.getInstance();
        Boolean result = (Boolean)ProgressUtils.run(() -> RemoveDialog.lambda$15(controller, (Supplier<Boolean>)(removeSupplier = () -> {
            boolean anyRemoved = false;
            if (componentConfigs != null) {
                anyRemoved |= controller.removeComponents((Collection)componentConfigs.stream().map(cc -> cc.getId()).collect(CollectorsUtils.toList()), caller);
            }
            if (componentInstanceConfigs != null) {
                componentInstanceConfigs.forEach(instance -> {
                    StringBuilder builder = new StringBuilder();
                    builder.append(controller.getFunctionalGroup().getId()).append(".").append(instance.getName());
                    CollapsibleSettingsStorageHelper.getInstance().removeSettingStateEntries(builder.toString());
                    ProvidableSettingsSelectionStorageHelper.getInstance().removeSettingStateEntries(builder.toString());
                });
                anyRemoved |= controller.removeComponentInstances((Collection)componentInstanceConfigs.stream().map(cic -> cic.getId()).collect(CollectorsUtils.toList()), true, caller);
                Set<@NonNull String> componentsToCheck = componentInstanceConfigs.stream().map(cic -> cic.getComponent().getId()).collect(Collectors.toSet());
                RemoveComponentInstancesDialog.removeLastInstanceDialog(componentsToCheck);
            }
            return new Boolean(anyRemoved);
        })));
        return result == null ? false : result;
    }

    private static /* synthetic */ Boolean lambda$15(Controller controller, Supplier supplier) {
        return (Boolean)CollectionsUtils.nullableOptionalGet((Optional)controller.runTransaction(supplier));
    }
}

