/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.gui.view.componentsettings;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.periphs.gui.controller.IControllerWrapper;
import com.nxp.swtools.periphs.gui.view.componentsettings.ArrayControl;
import com.nxp.swtools.periphs.gui.view.componentsettings.ChildControlBase;
import com.nxp.swtools.periphs.gui.view.componentsettings.ComponentInstanceControl;
import com.nxp.swtools.periphs.gui.view.componentsettings.ConfigSetControl;
import com.nxp.swtools.periphs.gui.view.componentsettings.ControlOptions;
import com.nxp.swtools.periphs.gui.view.componentsettings.FileLinkControl;
import com.nxp.swtools.periphs.gui.view.componentsettings.FilePersistentControl;
import com.nxp.swtools.periphs.gui.view.componentsettings.IChildControl;
import com.nxp.swtools.periphs.gui.view.componentsettings.ScalarButtonControl;
import com.nxp.swtools.periphs.gui.view.componentsettings.ScalarCheckboxControl;
import com.nxp.swtools.periphs.gui.view.componentsettings.ScalarComboAddComponentControl;
import com.nxp.swtools.periphs.gui.view.componentsettings.ScalarComboControl;
import com.nxp.swtools.periphs.gui.view.componentsettings.ScalarComboLinkControl;
import com.nxp.swtools.periphs.gui.view.componentsettings.ScalarControl;
import com.nxp.swtools.periphs.gui.view.componentsettings.ScalarCopyControl;
import com.nxp.swtools.periphs.gui.view.componentsettings.ScalarInfoControl;
import com.nxp.swtools.periphs.gui.view.componentsettings.ScalarInfoMarkdownControl;
import com.nxp.swtools.periphs.gui.view.componentsettings.ScalarRadioGroupControl;
import com.nxp.swtools.periphs.gui.view.componentsettings.ScalarTextControl;
import com.nxp.swtools.periphs.gui.view.componentsettings.SetControl;
import com.nxp.swtools.periphs.gui.view.componentsettings.SetPresenceControl;
import com.nxp.swtools.periphs.gui.view.componentsettings.StructControl;
import com.nxp.swtools.periphs.gui.view.componentsettings.StructInvisibleControl;
import com.nxp.swtools.periphs.gui.view.componentsettings.StructMultiColumnControl;
import com.nxp.swtools.periphs.model.config.ConfigSetConfig;
import com.nxp.swtools.resourcetables.model.config.ArrayConfig;
import com.nxp.swtools.resourcetables.model.config.IChild;
import com.nxp.swtools.resourcetables.model.config.IComponentInstanceConfig;
import com.nxp.swtools.resourcetables.model.config.IConfigSetConfig;
import com.nxp.swtools.resourcetables.model.config.ScalarConfig;
import com.nxp.swtools.resourcetables.model.config.SetConfig;
import com.nxp.swtools.resourcetables.model.config.StructConfig;
import com.nxp.swtools.resourcetables.model.data.setting.ISetting;
import com.nxp.swtools.resourcetables.model.data.setting.VariableSetting;
import java.text.MessageFormat;
import java.util.Objects;
import java.util.logging.Logger;

public class ChildControlFactory {
    @NonNull
    private static final Logger LOGGER = LogManager.getLogger(ChildControlFactory.class);

    public static @Nullable IChildControl create(@NonNull IChild child, @NonNull IControllerWrapper controllerWrapper, @Nullable ControlOptions overrideOptions) {
        if (child.isOptionSet("UI_NOT_VISIBLE_PERMANENT") && Objects.equals(child.getOptionValue("UI_NOT_VISIBLE_PERMANENT"), Boolean.TRUE)) {
            return null;
        }
        ControlOptions creationOptions = new ControlOptions(child);
        if (overrideOptions != null) {
            creationOptions.merge(overrideOptions);
        }
        if (child instanceof ScalarConfig) {
            ScalarConfig scalarConfig = (ScalarConfig)child;
            switch (scalarConfig.getType()) {
                case ENUM: {
                    if (creationOptions.shouldLayoutAsRadioGroup()) {
                        return new ScalarRadioGroupControl(scalarConfig, creationOptions, controllerWrapper);
                    }
                    if (child.isOptionSet("FEATURE_COMPONENT_ADD")) {
                        return new ScalarComboAddComponentControl(scalarConfig, creationOptions, controllerWrapper);
                    }
                    if (child.isOptionSet("UI_SETTING_LINK")) {
                        return new ScalarComboLinkControl(scalarConfig, creationOptions, controllerWrapper);
                    }
                    return new ScalarComboControl(scalarConfig, creationOptions, controllerWrapper);
                }
                case BOOL: {
                    if (creationOptions.shouldLayoutAsRadioGroup()) {
                        return new ScalarRadioGroupControl(scalarConfig, creationOptions, controllerWrapper);
                    }
                    return new ScalarCheckboxControl(scalarConfig, creationOptions, controllerWrapper);
                }
                case BUTTON: {
                    return new ScalarButtonControl(scalarConfig, creationOptions, controllerWrapper);
                }
                case INTEGER: 
                case FLOAT: 
                case STRING: {
                    return new ScalarTextControl(scalarConfig, creationOptions, controllerWrapper);
                }
                case FILE: {
                    if (creationOptions.isSelectionPersistent() && !scalarConfig.hasDirectoryType()) {
                        return new FilePersistentControl(scalarConfig, creationOptions, controllerWrapper);
                    }
                    return new FileLinkControl(scalarConfig, creationOptions, controllerWrapper);
                }
                case VARIABLE: {
                    return null;
                }
                case INFO: {
                    if (child.isOptionSet("UI_INFO_COPY_BUTTON")) {
                        return new ScalarCopyControl(scalarConfig, creationOptions, controllerWrapper);
                    }
                    if (child.isOptionSet("UI_INFO_MARKDOWN_CONTENT")) {
                        return new ScalarInfoMarkdownControl(scalarConfig, creationOptions, controllerWrapper);
                    }
                    return new ScalarInfoControl((ScalarConfig)child, creationOptions, controllerWrapper);
                }
            }
            return new ScalarControl(scalarConfig, creationOptions, controllerWrapper);
        }
        if (child instanceof StructConfig) {
            boolean invisible = true;
            StructConfig structConfig = (StructConfig)child;
            for (ISetting setting : structConfig.getModelData().getSettings().values()) {
                if (setting instanceof VariableSetting) continue;
                invisible = false;
            }
            if (invisible) {
                return new StructInvisibleControl(structConfig, creationOptions, controllerWrapper);
            }
            if (creationOptions.isMultiColumn()) {
                return new StructMultiColumnControl(structConfig, creationOptions, controllerWrapper);
            }
            return new StructControl(structConfig, creationOptions, controllerWrapper);
        }
        if (child instanceof ArrayConfig) {
            return new ArrayControl((ArrayConfig)child, creationOptions, controllerWrapper);
        }
        if (child instanceof SetConfig) {
            return new SetControl((SetConfig)child, creationOptions, controllerWrapper);
        }
        if (child instanceof IConfigSetConfig) {
            return new ConfigSetControl((ConfigSetConfig)child, creationOptions, controllerWrapper);
        }
        if (child instanceof SetConfig.SetPresence) {
            return new SetPresenceControl((SetConfig.SetPresence)child, creationOptions, controllerWrapper);
        }
        if (child instanceof IComponentInstanceConfig) {
            return new ComponentInstanceControl((IComponentInstanceConfig)child, creationOptions, controllerWrapper);
        }
        LOGGER.severe(MessageFormat.format("[TOOL] Unexpected class \"{0}\" of setting with ID \"{1}\"", child.getClass().getSimpleName(), child.getId()));
        return new ChildControlBase(child, creationOptions, controllerWrapper);
    }

    public static @Nullable IChildControl create(@NonNull IChild child, @Nullable ControlOptions overwriteOptions, @NonNull IControllerWrapper controllerWrapper) {
        IChildControl childControl = ChildControlFactory.create(child, controllerWrapper, overwriteOptions);
        if (childControl != null && overwriteOptions != null) {
            childControl.getControlOptions().merge(overwriteOptions);
        }
        return childControl;
    }
}

