/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.gui.view.componentsettings;

import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.periphs.gui.view.componentsettings.IChildControl;
import com.nxp.swtools.provider.configuration.ConfigChangeReason;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.ISharedConfigurationListener;
import com.nxp.swtools.provider.configuration.SharedConfigurationAdapter;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.resourcetables.model.config.ChildContext;
import com.nxp.swtools.resourcetables.model.config.IChild;
import com.nxp.swtools.resourcetables.model.config.IComponentInstanceConfig;
import com.nxp.swtools.resourcetables.model.config.IFunctionalGroup;
import com.nxp.swtools.utils.storage.StorageHelper;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;

public class CollapsibleSettingsStorageHelper {
    @NonNull
    private static final Logger LOGGER = LogManager.getLogger(CollapsibleSettingsStorageHelper.class);
    private static final String STATES_ELEMENT_NAME = "states";
    private static final String STATE_ELEMENT_NAME = "state";
    private static final String ID_ATTRIBUTE_NAME = "id";
    private static final String VALUE_ATTRIBUTE_NAME = "value";
    private static final boolean COLLAPSED_VALUE = false;
    private static final boolean EXPANDED_VALUE = true;
    @NonNull
    public static final String COLLAPSIBLE_SETTINGS_KEY = "collapsible_settings_";
    @NonNull
    StorageHelper storageHelper = new StorageHelper(5);
    @NonNull
    private @NonNull Map<@NonNull String, @NonNull Boolean> collapsibleSettingsState = new HashMap<String, Boolean>();
    @NonNull
    private String mexFileLocation = "";

    public static @NonNull CollapsibleSettingsStorageHelper getInstance() {
        try {
            CollapsibleSettingsStorageHelper helper = (CollapsibleSettingsStorageHelper)SWTFactoryProxy.INSTANCE.getSingletonInstance(CollapsibleSettingsStorageHelper.class);
            return helper;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalStateException("Cannot obtain instance of a component editor helper", e);
        }
    }

    public CollapsibleSettingsStorageHelper() {
        this.storageHelper.saveString(COLLAPSIBLE_SETTINGS_KEY, "");
        SharedConfigurationFactory.getSharedConfigurationSingleton().addListener((ISharedConfigurationListener)new SharedConfigurationAdapter(){

            public void configurationReloaded(@NonNull ISharedConfiguration sharedConfig, @NonNull ConfigChangeReason reason) {
                switch (reason) {
                    case LOAD_CONFIG: {
                        CollapsibleSettingsStorageHelper.this.mexFileLocation = CollapsibleSettingsStorageHelper.getMexFilePath();
                        CollapsibleSettingsStorageHelper.this.loadStates();
                        break;
                    }
                    case NEW_CONFIG: {
                        CollapsibleSettingsStorageHelper.this.saveStates();
                        CollapsibleSettingsStorageHelper.this.mexFileLocation = CollapsibleSettingsStorageHelper.getMexFilePath();
                        CollapsibleSettingsStorageHelper.this.collapsibleSettingsState.clear();
                    }
                }
            }
        });
    }

    public void collapseControl(@NonNull IChildControl control) {
        boolean result = this.setCollapsedState(control, false);
        if (!result) {
            LOGGER.log(Level.FINE, "[TOOL] Given control \"{0}\" does not contain full path to the root and was not saved", control.getChild().getId());
        }
    }

    public void expandControl(@NonNull IChildControl control) {
        boolean result = this.setCollapsedState(control, true);
        if (!result) {
            LOGGER.log(Level.FINE, "[TOOL] Given control \"{0}\" does not contain full path to the root and was not saved", control.getChild().getId());
        }
    }

    private boolean setCollapsedState(IChildControl control, boolean state) {
        String fullSettingId = CollapsibleSettingsStorageHelper.getFullId(control);
        if (fullSettingId == null) {
            return false;
        }
        this.collapsibleSettingsState.put(fullSettingId, state);
        this.saveStates();
        return true;
    }

    private static @Nullable String getFullId(IChildControl control) {
        IChild child = control.getChild();
        ChildContext childContext = child.getChildContext();
        StringBuilder builder = new StringBuilder(100);
        IFunctionalGroup functionalGroup = childContext.getFunctionalGroup();
        if (functionalGroup == null) {
            return null;
        }
        builder.append(functionalGroup.getName()).append(".");
        IComponentInstanceConfig instance = childContext.getComponentInstanceConfig();
        if (instance == null) {
            return null;
        }
        builder.append(instance.getName()).append(".");
        builder.append(child.getId());
        String fullSettingId = builder.toString();
        return fullSettingId;
    }

    public boolean isExpanded(@NonNull IChildControl control) {
        String fullId = CollapsibleSettingsStorageHelper.getFullId(control);
        if (fullId == null) {
            return true;
        }
        Boolean expanded = this.collapsibleSettingsState.get(fullId);
        if (expanded == null) {
            return true;
        }
        return expanded;
    }

    public boolean isStored(@NonNull IChildControl control) {
        String fullId = CollapsibleSettingsStorageHelper.getFullId(control);
        if (fullId == null) {
            return false;
        }
        Boolean expanded = this.collapsibleSettingsState.get(fullId);
        return expanded != null;
    }

    private void saveStates() {
        StringWriter writer = new StringWriter();
        try {
            XMLMemento xmlMemento = XMLMemento.createWriteRoot((String)STATES_ELEMENT_NAME);
            for (Map.Entry<String, Boolean> entry : this.collapsibleSettingsState.entrySet()) {
                IMemento child = xmlMemento.createChild(STATE_ELEMENT_NAME);
                child.putString(ID_ATTRIBUTE_NAME, entry.getKey());
                child.putBoolean(VALUE_ATTRIBUTE_NAME, entry.getValue().booleanValue());
            }
            xmlMemento.save((Writer)writer);
            this.storageHelper.saveString(COLLAPSIBLE_SETTINGS_KEY + this.mexFileLocation, UtilsText.safeString((String)writer.toString()));
        }
        catch (IOException e) {
            LOGGER.log(Level.INFO, "[TOOL] File exception occured. Detail: {0}", e.getMessage());
        }
    }

    private void loadStates() {
        try {
            if (UtilsText.isEmpty((String)this.mexFileLocation)) {
                return;
            }
            String mementoStrContent = this.storageHelper.loadString(COLLAPSIBLE_SETTINGS_KEY + this.mexFileLocation, "");
            if ("".equals(mementoStrContent)) {
                return;
            }
            StringReader reader = new StringReader(mementoStrContent);
            XMLMemento xmlMemento = XMLMemento.createReadRoot((Reader)reader);
            IMemento[] children = xmlMemento.getChildren();
            this.collapsibleSettingsState.clear();
            IMemento[] iMementoArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento child = iMementoArray[n2];
                String id = UtilsText.safeString((String)child.getString(ID_ATTRIBUTE_NAME));
                Boolean value = child.getBoolean(VALUE_ATTRIBUTE_NAME);
                value = value != null ? value : Boolean.FALSE;
                this.collapsibleSettingsState.put(id, value);
                ++n2;
            }
        }
        catch (WorkbenchException e) {
            LOGGER.log(Level.SEVERE, "[TOOL] XMLMemento exception occured. Detail: {0}", e.getMessage());
        }
    }

    private static String getMexFilePath() {
        @Nullable IPath locationPath = SharedConfigurationFactory.getSharedConfigurationSingleton().getLocationPath();
        String projectLocation = locationPath == null ? "" : locationPath.toOSString();
        return projectLocation;
    }

    public void onShutdown() {
        this.saveStates();
    }

    public void removeSettingStateEntries(String pattern) {
        this.collapsibleSettingsState.keySet().removeIf(fullId -> fullId.contains(pattern));
        this.saveStates();
    }
}

