/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.gui.view.componentsettings;

import com.nxp.swtools.common.ui.utils.editors.FileSelectionCellEditor;
import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.periphs.gui.Messages;
import com.nxp.swtools.periphs.gui.controller.IControllerWrapper;
import com.nxp.swtools.periphs.gui.view.componentsettings.ControlOptions;
import com.nxp.swtools.periphs.gui.view.componentsettings.IChildControl;
import com.nxp.swtools.periphs.gui.view.componentsettings.ScalarControl;
import com.nxp.swtools.resourcetables.model.config.ScalarConfig;
import com.nxp.swtools.utils.text.TextBoxHelper;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class FileLinkControl
extends ScalarControl {
    @Nullable
    private Text pathText;
    @Nullable
    private Button pathButton;

    public FileLinkControl(@NonNull ScalarConfig child, @NonNull ControlOptions controlOptions, @NonNull IControllerWrapper controllerWrapper) {
        super(child, controlOptions, controllerWrapper);
    }

    @Override
    public @NonNull Control createMainControl(@NonNull Composite composite) {
        Button button;
        Text text;
        Composite group = new Composite(composite, this.getSwtStyle());
        group.setLayout((Layout)new GridLayout(2, false));
        this.pathText = text = new Text(group, 2048);
        this.mainControlInternal = text;
        text.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        TextBoxHelper.attachModifyListeners((Text)text, this::saveLink);
        this.pathButton = button = new Button(group, 8);
        button.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(@NonNull SelectionEvent e) {
                if (FileLinkControl.this.getChild().hasDirectoryType()) {
                    String selectedPath = SWTFactoryProxy.INSTANCE.openDirectoryDialog(button.getShell(), Messages.get().FileControl_SelectDirectory, Messages.get().FileControl_SelectDirectory, UtilsText.safeString((String)FileLinkControl.this.getChild().getFilePath()));
                    FileLinkControl.this.saveLink(selectedPath);
                } else {
                    FileSelectionCellEditor.openFileDialog((Shell)button.getShell(), (String)Messages.get().FileControl_SelectFile, (String)UtilsText.safeString((String)FileLinkControl.this.getChild().getFilePath()), result -> FileLinkControl.this.saveLink((String)result));
                }
            }
        });
        this.createErrorDecoration((Control)group, 16512);
        return group;
    }

    void saveLink(@Nullable String link) {
        if (link == null) {
            return;
        }
        String newValue = this.getChild().prepareFileValue(link);
        if (!newValue.equals(this.getChild().getFilePath())) {
            this.controllerWrapper.getController().setValue(this.getChild(), newValue, FileLinkControl.class);
        }
    }

    @Override
    protected void updateMainContent(@NonNull Control contentControl, IChildControl.UpdateType updateType) {
        if (updateType != IChildControl.UpdateType.PROBLEM_DECORATION) {
            Text pathTextLoc = this.pathText;
            Button pathButtonLoc = this.pathButton;
            if (pathTextLoc != null) {
                String text = UtilsText.safeString((String)this.getChild().getFilePath());
                Point previousSelection = pathTextLoc.getSelection();
                pathTextLoc.setText(text);
                pathTextLoc.setSelection(previousSelection.y);
            }
            if (pathButtonLoc != null) {
                if (this.getChild().hasDirectoryType()) {
                    pathButtonLoc.setText(Messages.get().FileControl_SelectDirectory);
                } else {
                    pathButtonLoc.setText(Messages.get().FileControl_SelectFile);
                }
            }
            contentControl.requestLayout();
        }
        if (this.mainControlInternal != null) {
            this.updateErrorDecoration(this.mainControlInternal);
        }
        this.updateErrorDecoration(contentControl);
    }

    @Override
    protected void setEnabledStateToMainControl(boolean enabled) {
        super.setEnabledStateToMainControl(enabled);
        Text pathTextLoc = this.pathText;
        Button pathButtonLoc = this.pathButton;
        if (pathTextLoc != null) {
            pathTextLoc.setEnabled(enabled);
        }
        if (pathButtonLoc != null) {
            pathButtonLoc.setEnabled(enabled);
        }
    }
}

