/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.gui.view.componentsettings;

import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.common.ui.utils.swt.widgets.InstantSearchList;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.derivative.swt.GridDataComponents;
import com.nxp.swtools.derivative.swt.GridLayoutComponents;
import com.nxp.swtools.periphs.gui.Messages;
import com.nxp.swtools.periphs.gui.controller.IControllerWrapper;
import com.nxp.swtools.periphs.gui.view.AddComponentDialog;
import com.nxp.swtools.periphs.gui.view.componentsettings.ComponentSettingViewHelper;
import com.nxp.swtools.periphs.gui.view.componentsettings.ControlOptions;
import com.nxp.swtools.periphs.gui.view.componentsettings.ScalarComboControl;
import com.nxp.swtools.periphs.model.data.ConfigurationComponent;
import com.nxp.swtools.resourcetables.model.config.IChildProvidable;
import com.nxp.swtools.resourcetables.model.config.ScalarConfig;
import com.nxp.swtools.utils.progress.ProgressUtils;
import com.nxp.swtools.utils.resources.ToolsImages;
import java.text.MessageFormat;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;

public class ScalarComboAddComponentControl
extends ScalarComboControl {
    @NonNull
    private static final Logger LOGGER = LogManager.getLogger(ScalarComboAddComponentControl.class);
    private static final int FEATURE_COMPONENT_ADD_NUM_COLUMNS = 2;
    private Button addButton;

    public ScalarComboAddComponentControl(@NonNull ScalarConfig child, @NonNull ControlOptions controlOptions, @NonNull IControllerWrapper controllerWrapper) {
        super(child, controlOptions, controllerWrapper);
    }

    @Override
    protected void setEnabledStateToMainControl(boolean enabled) {
        Control mainControlLoc;
        Button addButtonLoc;
        InstantSearchList comboLoc = this.combo;
        if (comboLoc != null && comboLoc.getEnabled() != enabled) {
            comboLoc.setEnabled(enabled);
        }
        if ((addButtonLoc = this.addButton) != null && addButtonLoc.getEnabled() != enabled) {
            addButtonLoc.setEnabled(enabled && !this.controllerWrapper.getController().getComponentTypeIdsForComponentAddFeature(this.getChild()).isEmpty());
        }
        if ((mainControlLoc = this.mainControl) != null && !mainControlLoc.getEnabled()) {
            mainControlLoc.setEnabled(true);
        }
    }

    @Override
    protected Composite createComposite(@NonNull Composite composite) {
        Composite contentComposite = new Composite(composite, 0);
        GridLayoutComponents layout = new GridLayoutComponents(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        contentComposite.setLayout((Layout)layout);
        return contentComposite;
    }

    @Override
    protected void createControls(@NonNull Composite composite) {
        List componentsIds;
        this.combo = this.createComboBox(composite);
        this.addButton = this.createAddButton(composite);
        if (SWToolsProperties.isVerificationOn() && (componentsIds = this.getChild().getFeatureComponentAddValues()) != null) {
            CollectionsUtils.getInstancesOf(componentsIds.stream().map(id -> this.controllerWrapper.getController().getConfigurationComponent(id)), ConfigurationComponent.class).filter(c -> c.isGlobalOnly()).forEach(c -> LOGGER.warning(MessageFormat.format("[DATA] Component type \"{0}\" referenced in enum with ID \"{1}\" is not instantiable.", c.getId(), this.child.getId())));
        }
    }

    @Override
    protected void addSpecificListeners() {
        Button addButtonLoc = this.addButton;
        if (addButtonLoc != null) {
            addButtonLoc.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    IViewPart viewPart = ComponentSettingViewHelper.getViewPart();
                    if (viewPart == null) {
                        return;
                    }
                    IViewSite viewSite = viewPart.getViewSite();
                    if (viewSite == null) {
                        return;
                    }
                    ScalarComboAddComponentControl.this.controllerWrapper.getController().runTransaction(() -> {
                        @NonNull List componentsThatPassedFilter = ScalarComboAddComponentControl.this.controllerWrapper.getController().getComponentTypeIdsForComponentAddFeature(ScalarComboAddComponentControl.this.getChild());
                        AddComponentDialog openForComponents = AddComponentDialog.openForComponents(viewSite, componentsThatPassedFilter, ScalarComboAddComponentControl.this.controllerWrapper);
                        IChildProvidable result = openForComponents.getResult();
                        if (result == null) {
                            return;
                        }
                        ProgressUtils.run(m -> {
                            boolean bl = ScalarComboAddComponentControl.this.controllerWrapper.getController().setValue(ScalarComboAddComponentControl.this.getChild(), result.getUiName(), (Object)this);
                        });
                    });
                }
            });
        }
    }

    private Button createAddButton(@NonNull Composite composite) {
        Button button = new Button(composite, 8);
        SWTFactoryProxy.INSTANCE.setTestId((Widget)button, "periphsAddCompInstInCompSettViewBtn_" + this.child.getId());
        SWTFactoryProxy.INSTANCE.setHtmlTooltip((Control)button, Messages.get().ComponentsView_AddButtonTooltip);
        button.setImage(ToolsImages.getImage((String)"icons/add_circle.png"));
        button.setLayoutData((Object)new GridDataComponents(131072, 4, false, false));
        button.setEnabled(!this.controllerWrapper.getController().getComponentTypeIdsForComponentAddFeature(this.getChild()).isEmpty());
        return button;
    }
}

