/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.gui.view.componentsettings;

import animations.swt.ColorChanger;
import animations.swt.EaseSelector;
import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.expression.Expression;
import com.nxp.swtools.common.utils.expression.ExpressionException;
import com.nxp.swtools.common.utils.expression.IFunction;
import com.nxp.swtools.common.utils.expression.IValue;
import com.nxp.swtools.derivative.swt.GridDataComponents;
import com.nxp.swtools.derivative.swt.GridLayoutComponents;
import com.nxp.swtools.periphs.gui.controller.IControllerWrapper;
import com.nxp.swtools.periphs.gui.view.componentsettings.ControlOptions;
import com.nxp.swtools.periphs.gui.view.componentsettings.IChildControl;
import com.nxp.swtools.periphs.gui.view.componentsettings.ScalarControl;
import com.nxp.swtools.resourcetables.model.config.ASettingConfig;
import com.nxp.swtools.resourcetables.model.config.ScalarConfig;
import com.nxp.swtools.resourcetables.model.config.ScalarUtils;
import com.nxp.swtools.utils.preferences.KEPreferences;
import com.nxp.swtools.utils.resources.ToolsColors;
import com.nxp.swtools.utils.text.TextBoxHelper;
import java.text.MessageFormat;
import java.util.Objects;
import java.util.logging.Level;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ScalarTextControl
extends ScalarControl {
    private static final int MAXIMAL_PERMITTED_LINES = 200;
    private static final int ANIMATION_TIME = 1500;

    public ScalarTextControl(@NonNull ScalarConfig child, @NonNull ControlOptions controlOptions, @NonNull IControllerWrapper controllerWrapper) {
        super(child, controlOptions, controllerWrapper);
    }

    @Override
    public @NonNull Control createMainControl(@NonNull Composite composite) {
        Composite textComposite = new Composite(composite, 0);
        GridLayoutComponents textCompositeLayout = new GridLayoutComponents();
        textCompositeLayout.marginHeight = 0;
        textCompositeLayout.marginWidth = 0;
        textComposite.setLayout((Layout)textCompositeLayout);
        GridDataComponents textCompositeLayoutData = new GridDataComponents(4, 0x1000000, true, false);
        Text text = new Text(textComposite, this.getSwtStyle());
        text.setLayoutData((Object)textCompositeLayoutData);
        SWTFactoryProxy.INSTANCE.setTestId((Widget)text, "periphsSettCtrl_" + this.child.getId());
        this.mainControlInternal = text;
        TextBoxHelper.attachModifyListeners((Text)text, value -> {
            String childValue = this.getChild().getStringValue();
            if (!Objects.equals(value, childValue)) {
                Expression stringValidationExpr = this.getChild().getStringValidationExpr();
                if (stringValidationExpr != null) {
                    IFunction functionReference;
                    IValue resolvedExpression;
                    try {
                        resolvedExpression = stringValidationExpr.resolve(this.getChild().getExpressionContext());
                    }
                    catch (Exception e) {
                        LOGGER.severe(MessageFormat.format("[DATA] Expression resolving caused an error with message: {0}", e.getMessage()));
                        return;
                    }
                    try {
                        functionReference = resolvedExpression.getFunctionReference();
                    }
                    catch (ExpressionException e) {
                        e.log();
                        return;
                    }
                    Object result = functionReference.invokeOn(this.getChild().getExpressionContext(), new Object[]{value}).getValue();
                    if (result instanceof Boolean && !((Boolean)result).booleanValue()) {
                        return;
                    }
                }
                this.changeModelValue((String)value);
            }
        });
        TextBoxHelper.attachModifyErrorListener(() -> this.getChild().getStringValue(), (Text)text, value -> this.getStatus((String)value));
        this.createErrorDecoration((Control)text, 16512);
        ScalarTextControl.addScrollListener((Control)text, composite);
        return textComposite;
    }

    @Override
    public int getSwtStyle() {
        int style = super.getSwtStyle();
        if (this.getControlOptions().getNumOfLines() != null) {
            style |= 0x202;
        }
        return style;
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull TextBoxHelper.Status getStatus(@NonNull String value) {
        if (this.child.isEnabled()) {
            if (!this.getChild().isParseable(value)) {
                return TextBoxHelper.Status.INVALID;
            }
            if (this.getChild().getType() != ScalarConfig.Type.STRING && !ScalarUtils.isInRange((ASettingConfig)this.getChild(), (String)value)) {
                return TextBoxHelper.Status.VALUE_ERROR;
            }
            Expression stringValidationExpr = this.getChild().getStringValidationExpr();
            if (stringValidationExpr != null) {
                try {
                    IFunction functionReference;
                    try {
                        functionReference = stringValidationExpr.resolve(this.getChild().getExpressionContext()).getFunctionReference();
                    }
                    catch (ExpressionException e) {
                        String description = "[DATA] Lambda function is required in string valdation expression";
                        LOGGER.severe(description);
                        throw e;
                    }
                    Object result = functionReference.invokeOn(this.getChild().getExpressionContext(), new Object[]{value}).getValue();
                    if (result instanceof Boolean && !((Boolean)result).booleanValue()) {
                        return TextBoxHelper.Status.INVALID;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return TextBoxHelper.Status.INVALID;
                }
            }
        }
        return TextBoxHelper.Status.OK;
    }

    @Override
    protected void updateMainContent(@NonNull Control contentControl, IChildControl.UpdateType updateType) {
        if (updateType != IChildControl.UpdateType.PROBLEM_DECORATION) {
            Text textControl = (Text)this.mainControlInternal;
            if (textControl != null) {
                String stringValue;
                Object data = textControl.getLayoutData();
                if (data instanceof GridDataComponents) {
                    GridDataComponents layoutData = (GridDataComponents)data;
                    Integer multiLine = this.getControlOptions().getNumOfLines();
                    if (multiLine != null) {
                        int lines = multiLine;
                        if (lines < 1) {
                            lines = 1;
                            LOGGER.log(Level.SEVERE, () -> MessageFormat.format("[DATA] UI_MULTI_COLUMN option was set to \"{0}\" in setting with ID \"{1}\". Using value 1 instead.", multiLine, this.getChild().getId()));
                        }
                        if (lines > 200) {
                            lines = 200;
                            LOGGER.log(Level.WARNING, () -> MessageFormat.format("[DATA] Value of option UI_MULTI_COLUMN exceeds permitted limit of \"{0}\" lines in setting with ID \"{1}\"", 200, this.getChild().getId()));
                        }
                        layoutData.heightHint = lines * textControl.getLineHeight();
                    }
                }
                if (!Objects.equals(stringValue = this.getChild().getStringValue(), textControl.getText())) {
                    int caretPos = textControl.getCaretPosition();
                    textControl.setText(stringValue);
                    textControl.setSelection(caretPos);
                }
                Color background = ToolsColors.SwToolsColors.getColor((String)"com.nxp.swtools.utils.default_list_BG");
                Color foreground = ToolsColors.SwToolsColors.getColor((String)"com.nxp.swtools.utils.default_FG");
                textControl.setData("state", (Object)"ok");
                if (this.getChild().getWarning() != null) {
                    background = ToolsColors.SwToolsColors.getColor((String)"com.nxp.swtools.utils.warning_FG");
                    foreground = ToolsColors.SwToolsColors.getColor((String)"com.nxp.swtools.utils.black_FG");
                    textControl.setData("state", (Object)"warning");
                }
                if (this.getChild().getError() != null) {
                    background = ToolsColors.SwToolsColors.getColor((String)"com.nxp.swtools.utils.error_BG");
                    foreground = ToolsColors.SwToolsColors.getColor((String)"com.nxp.swtools.utils.error_FG");
                    textControl.setData("state", (Object)"error");
                }
                if (KEPreferences.isAnimationsEnabled()) {
                    ColorChanger cc = new ColorChanger((Control)textControl, background, EaseSelector.SPIKE);
                    cc.play(1500);
                } else {
                    textControl.setBackground(background);
                }
                textControl.setForeground(foreground);
            }
            if (this.mainControlInternal != null) {
                this.updateErrorDecoration(this.mainControlInternal);
            }
            this.updateErrorDecoration(contentControl);
        }
    }
}

