/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.gui.view.componentsettings.internal;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.periphs.gui.controller.IControllerWrapper;
import com.nxp.swtools.periphs.gui.view.componentsettings.ControlOptions;
import com.nxp.swtools.periphs.gui.view.componentsettings.internal.AArrayControlInternal;
import com.nxp.swtools.periphs.gui.view.componentsettings.internal.ArrayControlInvisible;
import com.nxp.swtools.periphs.gui.view.componentsettings.internal.ArrayControlMasterDetail;
import com.nxp.swtools.periphs.gui.view.componentsettings.internal.ArrayControlRadioHorizontal;
import com.nxp.swtools.periphs.gui.view.componentsettings.internal.ArrayControlRadioVertical;
import com.nxp.swtools.periphs.gui.view.componentsettings.internal.ArrayControlStandardHorizontal;
import com.nxp.swtools.periphs.gui.view.componentsettings.internal.ArrayControlStandardVertical;
import com.nxp.swtools.periphs.gui.view.componentsettings.internal.ArrayControlTabs;
import com.nxp.swtools.periphs.gui.view.componentsettings.internal.ArrayControlTabularHorizontal;
import com.nxp.swtools.periphs.gui.view.componentsettings.internal.ArrayControlTabularVertical;
import com.nxp.swtools.resourcetables.model.config.ArrayConfig;
import com.nxp.swtools.resourcetables.model.data.setting.ISetting;
import com.nxp.swtools.resourcetables.model.data.setting.StructSetting;
import com.nxp.swtools.resourcetables.model.data.setting.VariableSetting;

public class ArrayControlInternalFactory {
    public static @NonNull AArrayControlInternal create(@NonNull ArrayConfig arrayConfig, @NonNull ControlOptions controlOptions, @NonNull IControllerWrapper controllerWrapper) {
        ISetting arrayTypeSeting = arrayConfig.getInstanceSetting();
        if (arrayTypeSeting instanceof VariableSetting) {
            return new ArrayControlInvisible(arrayConfig, controlOptions, controllerWrapper);
        }
        if (arrayTypeSeting instanceof StructSetting) {
            boolean invisible = true;
            StructSetting structSetting = (StructSetting)arrayTypeSeting;
            for (ISetting setting : structSetting.getSettings().values()) {
                if (setting instanceof VariableSetting) continue;
                invisible = false;
                break;
            }
            if (invisible) {
                return new ArrayControlInvisible(arrayConfig, controlOptions, controllerWrapper);
            }
        }
        switch (arrayConfig.getRepresentation()) {
            case VERTICAL_TABLE: {
                return new ArrayControlTabularVertical(arrayConfig, controlOptions, controllerWrapper);
            }
            case HORIZONTAL_TABLE: {
                return new ArrayControlTabularHorizontal(arrayConfig, controlOptions, controllerWrapper);
            }
            case VERTICAL_RADIOS: {
                return new ArrayControlRadioVertical(arrayConfig, controlOptions, controllerWrapper);
            }
            case HORIZONTAL_RADIOS: {
                return new ArrayControlRadioHorizontal(arrayConfig, controlOptions, controllerWrapper);
            }
            case MASTER_DETAIL: {
                return new ArrayControlMasterDetail(arrayConfig, controlOptions, controllerWrapper);
            }
            case TABS: {
                return new ArrayControlTabs(arrayConfig, controlOptions, controllerWrapper);
            }
            case HORIZONTAL_FORM: {
                return new ArrayControlStandardHorizontal(arrayConfig, controlOptions, controllerWrapper);
            }
        }
        return new ArrayControlStandardVertical(arrayConfig, controlOptions, controllerWrapper);
    }
}

