/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.gui.view.componentsettings.internal;

import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.common.ui.utils.swt.ScrolledCompositeHelper;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.periphs.gui.Messages;
import com.nxp.swtools.periphs.gui.controller.IControllerWrapper;
import com.nxp.swtools.periphs.gui.view.componentsettings.ControlOptions;
import com.nxp.swtools.periphs.gui.view.componentsettings.IChildControl;
import com.nxp.swtools.periphs.gui.view.componentsettings.internal.AArrayControlGroup;
import com.nxp.swtools.periphs.gui.view.componentsettings.internal.ArrayControlItemMenu;
import com.nxp.swtools.periphs.gui.view.componentsettings.internal.IArrayControlItemMenuControl;
import com.nxp.swtools.resourcetables.model.config.ArrayConfig;
import com.nxp.swtools.resourcetables.model.config.IChild;
import com.nxp.swtools.resourcetables.model.config.ISettingConfig;
import com.nxp.swtools.utils.preferences.KEPreferences;
import com.nxp.swtools.utils.resources.ToolsColors;
import com.nxp.swtools.utils.resources.ToolsImages;
import java.util.logging.Level;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ArrayControlTabs
extends AArrayControlGroup {
    @Nullable
    private Composite contentComposite;

    protected ArrayControlTabs(@NonNull ArrayConfig arrayConfig, @NonNull ControlOptions controlOptions, @NonNull IControllerWrapper controllerWrapper) {
        super(arrayConfig, controlOptions, controllerWrapper);
    }

    @Override
    public Control createLabelControl(Composite composite) {
        return null;
    }

    @Override
    public ISettingConfig getSelection() {
        IChildControl selectedChildLoc = this.getSelectedChild();
        if (selectedChildLoc == null) {
            return null;
        }
        IChild childLoc = selectedChildLoc.getChild();
        if (childLoc instanceof ISettingConfig) {
            return (ISettingConfig)childLoc;
        }
        return null;
    }

    @Override
    protected @NonNull String getMoveDownDescription() {
        return Messages.get().ArrayControl_ItemMenu_MoveRight;
    }

    @Override
    protected @NonNull String getMoveUpButtonDescription() {
        return Messages.get().ArrayControl_ItemMenu_MoveLeft;
    }

    @Override
    public @Nullable Control createMainControl(@NonNull Composite composite) {
        boolean borderHidden = this.getControlOptions().isBorderHidden();
        this.getControlOptions().borderHidden(true);
        int colSpan = 1;
        Composite createdComposite = this.createComposite(composite, colSpan);
        this.getControlOptions().borderHidden(borderHidden);
        this.createLabelWithControls(createdComposite);
        this.contentComposite = this.createControlTabs(createdComposite, 3, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ArrayControlTabs.this.updateChildSelection(3);
                ArrayControlTabs.this.updateButtons(ArrayControlTabs.this.getControlUpdateType());
                Composite contentCompositeLoc = ArrayControlTabs.this.contentComposite;
                if (contentCompositeLoc != null) {
                    ScrolledCompositeHelper.updateScrollSize((Composite)contentCompositeLoc);
                }
            }
        });
        this.createInfoLabel(createdComposite, colSpan);
        return createdComposite;
    }

    @Override
    protected void updateSelectionOfExpandGroupContent() {
        if (this.children.isEmpty()) {
            this.setSelectedChild(null);
            this.expandGroupContent = null;
        } else {
            this.expandGroupContent = this.contentComposite;
        }
    }

    @Override
    public void updateMainContent(@NonNull Control mainControlLoc, @NonNull IChildControl.UpdateType updateType) {
        Composite contentCompositeLoc = this.contentComposite;
        if (contentCompositeLoc != null) {
            boolean isChanged;
            Point size = contentCompositeLoc.getSize();
            boolean bl = isChanged = !size.equals((Object)new Point(0, 0));
            if (KEPreferences.isAnimationsEnabled() && isChanged && (updateType == IChildControl.UpdateType.NORMAL || updateType == IChildControl.UpdateType.NORMAL_CONFIGSET) && (this.children.isEmpty() || this.children.size() == 1 && !contentCompositeLoc.isVisible())) {
                this.setControlVisibleAnimation((Control)contentCompositeLoc, null, !this.children.isEmpty());
            } else {
                this.setControlVisible((Control)contentCompositeLoc, !this.children.isEmpty());
            }
        }
    }

    @Override
    protected void updateButtons(@Nullable IChildControl.UpdateType updateType) {
        if (!this.areButtonsEnabled()) {
            updateType = IChildControl.UpdateType.FORCE_DISABLE;
        }
        Color buttonTextColor = ToolsColors.SwToolsColors.getColor((String)(updateType == IChildControl.UpdateType.FORCE_DISABLE ? "com.nxp.swtools.utils.disabled_FG" : "com.nxp.swtools.utils.default_FG"));
        Composite contentCompositeLoc = this.contentComposite;
        if (contentCompositeLoc instanceof CTabFolder) {
            if (!contentCompositeLoc.isDisposed()) {
                CTabItem[] items;
                CTabItem[] cTabItemArray = items = ((CTabFolder)contentCompositeLoc).getItems();
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    CTabItem item = cTabItemArray[n2];
                    if (!item.isDisposed()) {
                        SWTFactoryProxy.INSTANCE.setCTabItemForeground(item, buttonTextColor);
                    }
                    ++n2;
                }
            }
        } else if (contentCompositeLoc != null) {
            LOGGER.log(Level.SEVERE, "[TOOL] Expected contentComposite to be instance of CTabItem, but instance of class \"{0}\" was present", contentCompositeLoc.getClass().getSimpleName());
        }
        this.updateAddButton(updateType);
        this.updateRemoveButton(updateType);
        this.updateDownButton(updateType);
        this.updateUpButton(updateType);
    }

    @Override
    public void setAllSettingsTo(@NonNull ArrayControlItemMenu caller, @NonNull IArrayControlItemMenuControl control) {
    }

    @Override
    public void selectLastItem() {
        int lastIndex = this.children.size() - 1;
        if (lastIndex >= 0) {
            this.setSelectedChild((IChildControl)this.children.get(lastIndex));
            this.updateTabs();
            this.updateButtons(this.getControlUpdateType());
        }
    }

    @Override
    protected @Nullable Image getMoveUpIcon() {
        return ToolsImages.getImage((String)"icons/left.png");
    }

    @Override
    protected @Nullable Image getMoveDownIcon() {
        return ToolsImages.getImage((String)"icons/right.png");
    }
}

