/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.gui.view.provider;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.periphs.controller.Controller;
import com.nxp.swtools.periphs.controller.PeripheralsProblem;
import com.nxp.swtools.periphs.gui.view.componentsettings.ComponentSettingView;
import com.nxp.swtools.periphs.gui.view.componentsettings.GlobalComponentSettingView;
import com.nxp.swtools.resourcetables.model.config.IComponentInstanceConfig;
import com.nxp.swtools.resourcetables.model.config.IConfigSetConfig;
import com.nxp.swtools.resourcetables.model.config.IFunctionalGroup;
import com.nxp.swtools.validation.engine.IBaseProblem;
import com.nxp.swtools.validation.engine.IProblemOpenHandler;
import com.nxp.swtools.validation.engine.IProblemOpenProvider;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.logging.Logger;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class PeripheralsProblemOpenProvider
implements IProblemOpenProvider {
    @NonNull
    static final Logger LOGGER = LogManager.getLogger(PeripheralsProblemOpenProvider.class);
    @NonNull
    private static final @NonNull Collection<@NonNull IProblemOpenHandler> HANDLERS = CollectionsUtils.asList((Object)new PeripheralsProblemOpenHandler());

    public @NonNull Collection<@NonNull IProblemOpenHandler> getOpenHandlers(@NonNull IBaseProblem problem) {
        if (problem instanceof PeripheralsProblem && ((PeripheralsProblem)problem).getComponentType() != null) {
            return HANDLERS;
        }
        return CollectionsUtils.emptyList();
    }

    private static class PeripheralsProblemOpenHandler
    implements IProblemOpenHandler {
        PeripheralsProblemOpenHandler() {
        }

        public void openProblem(@NonNull IBaseProblem problem) {
            if (problem instanceof PeripheralsProblem) {
                this.openTool("Peripherals");
                final PeripheralsProblem peripheralsProblem = (PeripheralsProblem)problem;
                final IComponentInstanceConfig instance = peripheralsProblem.getChild().getChildContext().getComponentInstanceConfig();
                final String componentType = peripheralsProblem.getComponentType();
                final String componentName = peripheralsProblem.getComponentInstanceName();
                String functionalGroupName = peripheralsProblem.getFunctionalGroupName();
                if (componentType != null) {
                    IFunctionalGroup group = Controller.getInstance().getProfile().getFunctionalGroup(UtilsText.safeString((String)functionalGroupName));
                    if (group != null && !Controller.getInstance().getFunctionalGroup().getUiName().equals(functionalGroupName)) {
                        Controller.getInstance().setFunctionalGroup(group, (Object)this);
                    }
                    Display display = Display.getCurrent();
                    assert (display != null);
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                            if (activeWorkbenchWindow != null) {
                                IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
                                if (activePage != null) {
                                    if (PeripheralsProblemOpenHandler.isChildPresentInGlobalConfigSet(peripheralsProblem.getChild().getId())) {
                                        GlobalComponentSettingView.open(activePage, componentType, peripheralsProblem.getChild());
                                    } else if (instance != null) {
                                        ComponentSettingView.open(activePage, instance.getUUID(), true, peripheralsProblem.getChild());
                                    } else {
                                        ComponentSettingView.open(activePage, componentType, UtilsText.safeString((String)componentName), componentName == null, true, peripheralsProblem.getChild());
                                    }
                                } else {
                                    LOGGER.warning("[TOOL] Cannot open component setting view because there is no active page");
                                }
                            } else {
                                LOGGER.warning("[TOOL] Cannot open component setting view because there is no active workbench window");
                            }
                        }
                    });
                }
            } else {
                LOGGER.warning(MessageFormat.format("[TOOL] {0} accepts only {1}", PeripheralsProblemOpenHandler.class.getSimpleName(), PeripheralsProblem.class.getSimpleName()));
            }
        }

        public @Nullable String getTargetToolId() {
            return "Peripherals";
        }

        protected static boolean isChildPresentInGlobalConfigSet(String settingId) {
            Collection globalConfigSets = Controller.getInstance().getProfile().getGlobalConfigSets().values();
            for (IConfigSetConfig cfgSet : globalConfigSets) {
                if (!cfgSet.getAllStorableSettings().stream().anyMatch(setting -> setting.getId().equals(settingId))) continue;
                return true;
            }
            return false;
        }
    }
}

