/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.gui.view.provider;

import com.nxp.swtools.codemanager.GeneratedCodeStatus;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.periphs.controller.Controller;
import com.nxp.swtools.periphs.controller.Messages;
import com.nxp.swtools.periphs.model.data.mcu.IMcu;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.provider.configuration.sources.ISourceFile;
import com.nxp.swtools.provider.configuration.sources.SourceFileProviderFactory;
import com.nxp.swtools.provider.configuration.storage.ICustomCopyrightHeaderRead;
import com.nxp.swtools.resourcetables.model.mcu.ACommonMcu;
import com.nxp.swtools.resourcetables.model.mcu.ICommonMcu;
import com.nxp.swtools.utils.scripting.ScriptResult;
import com.nxp.swtools.utils.sources.ISourcesContentProvider;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class SourcesViewProvider
implements ISourcesContentProvider {
    public @NonNull Collection<@NonNull ISourceFile> getContent() {
        Controller controller = Controller.getInstance();
        ScriptResult scriptResult = controller.getGeneratedCode();
        LinkedHashMap<@NonNull String, @NonNull String> code = new LinkedHashMap<String, String>();
        LinkedHashMap<@NonNull String, byte @NonNull []> binaryFiles = new LinkedHashMap<String, byte[]>();
        if (scriptResult != null) {
            code.putAll(scriptResult.getOpenedFiles());
            binaryFiles.putAll(scriptResult.getOpenedBinaryFiles());
            IMcu mcu = controller.getMcu();
            for (String core : scriptResult.getCores()) {
                Map coreBinaryFiles;
                Map<@NonNull K, @NonNull V> coreFiles = scriptResult.containsAnyError() ? new HashMap() : scriptResult.getOpenedFiles(core);
                Map map = coreBinaryFiles = scriptResult.containsAnyError() ? new HashMap() : scriptResult.getOpenedBinaryFiles(core);
                if (coreFiles != null) {
                    for (Map.Entry entry : coreFiles.entrySet()) {
                        code.put(ACommonMcu.addCoreNameIfMulticore((ICommonMcu)mcu, (String)core, (String)((String)entry.getKey())), (String)entry.getValue());
                    }
                }
                if (coreBinaryFiles == null) continue;
                for (Map.Entry entry : coreBinaryFiles.entrySet()) {
                    binaryFiles.put(ACommonMcu.addCoreNameIfMulticore((ICommonMcu)mcu, (String)core, (String)((String)entry.getKey())), (byte[])entry.getValue());
                }
            }
        }
        return SourceFileProviderFactory.buildSourceFileList(code, binaryFiles, (ICustomCopyrightHeaderRead)SharedConfigurationFactory.getSharedConfigurationSingleton().getPreferences().getCustomCopyright());
    }

    public @Nullable String getErrorText() {
        Controller controller = Controller.getInstance();
        if (!controller.isTurnedOn() || controller.isGeneratingCode()) {
            return null;
        }
        ScriptResult scriptResult = controller.getGeneratedCode();
        String mcuError = controller.getToolError();
        if (mcuError != null) {
            return mcuError;
        }
        if (scriptResult != null && scriptResult.isFailedDueTimeout()) {
            return Messages.get().Controller_SourcesGeneration_GenerationFailedDueTimeout;
        }
        return scriptResult != null && !scriptResult.isFailed() ? scriptResult.getErrors() : Messages.get().Controller_SourcesGeneration_CannotGenerateDueToInternalError;
    }

    public @Nullable String getWarningText() {
        Controller controller = Controller.getInstance();
        if (!controller.isTurnedOn() || controller.isGeneratingCode()) {
            return null;
        }
        ScriptResult scriptResult = controller.getGeneratedCode();
        return scriptResult != null ? scriptResult.getWarnings() : null;
    }

    public boolean isOutOfSync() {
        Controller controller = Controller.getInstance();
        ScriptResult generatedCode = controller.getGeneratedCode();
        return controller.isGeneratingCode() || generatedCode == null || generatedCode.isFailed() || GeneratedCodeStatus.getInstance().isOutOfSync();
    }

    public @Nullable String getStatus() {
        Controller controller = Controller.getInstance();
        if (!controller.isTurnedOn() || controller.isGeneratingCode()) {
            return null;
        }
        ScriptResult scriptResult = controller.getGeneratedCode();
        String mcuError = controller.getToolError();
        if (mcuError != null) {
            return mcuError;
        }
        if (scriptResult != null && scriptResult.isFailedDueTimeout()) {
            return Messages.get().Controller_SourcesGeneration_GenerationFailedDueTimeout;
        }
        if (scriptResult == null || scriptResult.isFailed() || scriptResult.containsAnyError()) {
            return Messages.get().Controller_SourcesGeneration_CannotGenerateDueToInternalError;
        }
        if (!UtilsText.isEmpty((String)scriptResult.getErrors())) {
            return Messages.get().SourcesViewProvider_SourcesGeneration_GeneratedWithErrors;
        }
        if (!UtilsText.isEmpty((String)scriptResult.getWarnings())) {
            return Messages.get().SourcesViewProvider_SourcesGeneration_GeneratedWithWarnings;
        }
        return "";
    }
}

