/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.rcp.datacollection.transfer;

import com.nxp.s32ds.ext.rcp.internal.datacollection.DataCollectionActivator;
import com.nxp.s32ds.ext.rcp.internal.datacollection.Messages;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class TransferServiceProcessor {
    public TransferServiceProcessor foreach(Path dir, Predicate<? super Path> predicate, Consumer<? super Path> action) {
        try {
            Files.walk(dir, 1, new FileVisitOption[0]).filter(predicate).forEach(action);
        }
        catch (IOException e) {
            DataCollectionActivator.getInstance().logError(Messages.TransferService_error_file_tree, e);
        }
        return this;
    }

    public TransferServiceProcessor ifExists(Path dir, Predicate<? super Path> predicate, Runnable action) {
        try {
            Files.walk(dir, 1, new FileVisitOption[0]).filter(predicate).findAny().ifPresent(file -> action.run());
        }
        catch (IOException e) {
            DataCollectionActivator.getInstance().logError(Messages.TransferService_error_file_tree, e);
        }
        return this;
    }
}

