/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.rcp.internal.datacollection;

import com.nxp.s32ds.ext.rcp.datacollection.ArbitrageProcessor;
import com.nxp.s32ds.ext.rcp.internal.datacollection.DataCollectionActivator;
import com.nxp.s32ds.ext.rcp.internal.datacollection.Messages;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.osgi.util.NLS;

public class ArbitrageService {
    private static ArbitrageService serviceInstance;
    private boolean locked;
    private Path resourcePath;

    private ArbitrageService() {
    }

    public static synchronized ArbitrageService getDataCollectionArbitr() {
        if (serviceInstance == null) {
            serviceInstance = new ArbitrageService();
        }
        return serviceInstance;
    }

    public synchronized <T extends ArbitrageProcessor> void startProcess(T t, Path path) {
        String msg;
        if (!this.lock(path)) {
            msg = NLS.bind((String)Messages.TransferService_error_resource_locked, (Object)path);
            DataCollectionActivator.getInstance().logError(msg);
        }
        t.processUnderArbitrage();
        if (!this.unlock(path)) {
            msg = NLS.bind((String)Messages.TransferService_error_resource_canot_be_unlocked, (Object)path);
            DataCollectionActivator.getInstance().logError(msg);
        }
    }

    public synchronized boolean isAccesiable() {
        return !this.locked;
    }

    private synchronized boolean lock(Path path) {
        if (!this.isAccesiable()) {
            return false;
        }
        this.resourcePath = path;
        this.locked = true;
        return true;
    }

    private synchronized boolean unlock(Path path) {
        if (this.resourcePath.toFile().exists() && this.resourcePath.compareTo(path) == 0) {
            this.locked = false;
        }
        return !this.locked;
    }

    public boolean reInit(String resource) {
        Path filePath = Paths.get(resource, new String[0]);
        File file = filePath.toFile();
        if (file.exists() && file.canWrite()) {
            this.resourcePath = filePath;
            this.locked = false;
            return true;
        }
        return false;
    }
}

