/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.rcp.license.core.cli.cmd;

import com.nxp.s32ds.ext.rcp.license.cll.CLLActivationType;
import com.nxp.s32ds.ext.rcp.license.cll.CLLReason;
import com.nxp.s32ds.ext.rcp.license.cll.ICLL;
import com.nxp.s32ds.rcp.license.core.cli.ISettings;
import com.nxp.s32ds.rcp.license.core.cli.cmd.AbstractCommand;
import java.io.File;

public class Activate
extends AbstractCommand {
    public static final String PARAM_ACT_ID = "actid";
    public static final String PARAM_REQ = "req";
    public static final String PARAM_RES = "res";

    public Activate(ISettings settings, ICLL cll) {
        super(cll, settings);
        this.getParams().put(PARAM_ACT_ID, "Software Activation Code for product");
        this.getParams().put(PARAM_REQ, "Specify request xml file name for offline strategy");
        this.getParams().put(PARAM_RES, "Specify response xml file name for offline strategy");
    }

    @Override
    public String getName() {
        return "activate";
    }

    @Override
    public String getOneLineDesc() {
        return "Activate license. If req or res is set, use offline strategy.";
    }

    @Override
    public boolean canExecute() {
        return this.getProblemDescription() == null;
    }

    @Override
    public String getProblemDescription() {
        String rootProblems = super.getProblemDescription();
        if (rootProblems != null) {
            return rootProblems;
        }
        String resFilename = this.getSettings().getParam(PARAM_RES);
        if (this.getSettings().getParam(PARAM_ACT_ID) == null && resFilename == null) {
            return "Software Activation Code is not set";
        }
        if (resFilename != null && !new File(resFilename).exists()) {
            return "File '" + resFilename + "' missing";
        }
        return null;
    }

    @Override
    public int execute() {
        CLLReason result;
        block9: {
            String actID;
            block8: {
                try {
                    super.initLicenseLocation();
                    super.setupProxy();
                    if (this.isTestFNO()) {
                        if (this.getSettings().isDebugModeOn()) {
                            System.out.println("use test FNO");
                        }
                        this.getCll().setFNOUrlForTesting(true);
                    }
                    String requestXml = this.getSettings().getParam(PARAM_REQ);
                    String responseXml = this.getSettings().getParam(PARAM_RES);
                    actID = this.getSettings().getParam(PARAM_ACT_ID);
                    if (this.getActivationType() != CLLActivationType.CLL_ACTIVATION_TYPE_OFFLINE_FNO) break block8;
                    if (requestXml != null) {
                        return this.generateXmlRequest(requestXml, actID);
                    }
                    if (responseXml != null) {
                        return this.processXmlResponse(responseXml);
                    }
                    System.err.println("requestXml and responseXml are null");
                    return 1;
                }
                catch (Exception e) {
                    System.err.println(e.getMessage());
                    return 1;
                }
            }
            result = this.getCll().activateLicense(actID, this.getActivationType(), null, 0L, 0L);
            if (result != null) break block9;
            return 0;
        }
        System.err.println(result);
        return 1;
    }

    private int processXmlResponse(String responseXml) {
        String resFileName = new File(responseXml).getAbsolutePath();
        CLLReason result = this.getCll().processOfflineResponse(resFileName);
        if (result == null) {
            return 0;
        }
        System.err.println(result);
        return 1;
    }

    private int generateXmlRequest(String requestXml, String actID) {
        String reqFileName = new File(requestXml).getAbsolutePath();
        CLLReason result = this.getCll().activateLicense(actID, this.getActivationType(), reqFileName, null, null);
        if (result == null) {
            return 0;
        }
        System.err.println(result);
        return 1;
    }

    private CLLActivationType getActivationType() {
        if (this.getSettings().getParam(PARAM_REQ) != null || this.getSettings().getParam(PARAM_RES) != null) {
            return CLLActivationType.CLL_ACTIVATION_TYPE_OFFLINE_FNO;
        }
        return CLLActivationType.CLL_ACTIVATION_TYPE_FNO;
    }
}

