/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.rcp.license.core.cli.cmd.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.MaskFormatter;

public class ActivationIdDialog
extends JDialog {
    private static final String EMPTY_CODE_VALUE = "    -    -    -    ";
    private static final long serialVersionUID = 1L;
    private String value;

    public ActivationIdDialog(String title, String message, String initial) throws ParseException {
        super((Frame)null, title, true);
        this.setAlwaysOnTop(true);
        this.setResizable(false);
        JPanel pane = new JPanel(new BorderLayout());
        final JButton btnOk = new JButton("Ok");
        btnOk.setEnabled(false);
        this.value = initial;
        Icon icon = UIManager.getIcon("OptionPane.questionIcon");
        JPanel mainPane = new JPanel(new FlowLayout());
        JPanel inputPane = new JPanel(new GridLayout(2, 1));
        MaskFormatter formatter = new MaskFormatter("HHHH-HHHH-HHHH-HHHH");
        final JFormattedTextField activationIdInput = new JFormattedTextField(formatter);
        activationIdInput.setValue(this.value);
        activationIdInput.setPreferredSize(new Dimension(240, 20));
        activationIdInput.getDocument().addDocumentListener(new DocumentListener(){
            private final Pattern ACT_ID_PATTERN = Pattern.compile("[0-9A-F]{4}-[0-9A-F]{4}-[0-9A-F]{4}-[0-9A-F]{4}");

            @Override
            public void insertUpdate(DocumentEvent e) {
                if (activationIdInput.getText() != null) {
                    btnOk.setEnabled(this.ACT_ID_PATTERN.matcher(activationIdInput.getText()).matches());
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        activationIdInput.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                if (activationIdInput.getCaretPosition() != 0 && activationIdInput.getText().equals(ActivationIdDialog.EMPTY_CODE_VALUE)) {
                    activationIdInput.setCaretPosition(0);
                }
            }
        });
        JLabel inputLabel = new JLabel(message);
        inputLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 8, 0));
        inputLabel.setLabelFor(activationIdInput);
        inputPane.add(inputLabel);
        inputPane.add(activationIdInput);
        JLabel iconLabel = new JLabel(icon);
        iconLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 18));
        mainPane.add(iconLabel);
        mainPane.add(inputPane);
        JPanel buttonsPane = new JPanel(new FlowLayout(1));
        btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ActivationIdDialog.this.value = activationIdInput.getText();
                ActivationIdDialog.this.setVisible(false);
            }
        });
        JButton btnCancel = new JButton("Cancel");
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ActivationIdDialog.this.cancel();
            }
        });
        buttonsPane.add(btnOk);
        buttonsPane.add(btnCancel);
        pane.add((Component)mainPane, "North");
        pane.add((Component)buttonsPane, "South");
        pane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.getRootPane().setDefaultButton(btnOk);
        this.getContentPane().add(pane);
        this.pack();
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(2);
    }

    private void cancel() {
        this.value = null;
        this.setVisible(false);
    }

    public String getValue() {
        return this.value == null || this.value.isEmpty() ? null : this.value;
    }
}

