/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.rcp.license.core.cli.cmd.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;

public class FNPServiceVersionUtil {
    private static final String WIN32_FNP_SERVICE_PATH = "C:\\\\Program Files (x86)\\\\Common Files\\\\Macrovision Shared\\\\FlexNet Publisher\\\\FNPLicensingService.exe";
    private static final String WIN64_FNP_SERVICE_PATH = "C:\\\\Program Files\\\\Common Files\\\\Macrovision Shared\\\\FlexNet Publisher\\\\FNPLicensingService64.exe";
    private static final String WMIC_COMMAND_PATTERN = "wmic datafile where name=\"%s\" get version";

    private FNPServiceVersionUtil() {
    }

    public static void printVersions() {
        if (!FNPServiceVersionUtil.isWindowsPlatform()) {
            System.out.println("Not supported on non Windows OS");
            return;
        }
        FNPServiceVersionUtil.printServiceVersion(WIN32_FNP_SERVICE_PATH);
        FNPServiceVersionUtil.printServiceVersion(WIN64_FNP_SERVICE_PATH);
    }

    private static void printServiceVersion(String path) {
        block12: {
            try {
                if (!Files.exists(Paths.get(path, new String[0]), new LinkOption[0])) break block12;
                System.out.println("Found " + path);
                String cmd = String.format(WMIC_COMMAND_PATTERN, path);
                Process process = Runtime.getRuntime().exec(cmd);
                Throwable throwable = null;
                Object var4_6 = null;
                try (InputStream is = process.getInputStream();){
                    String line = "";
                    BufferedReader br = new BufferedReader(new InputStreamReader(is));
                    while ((line = br.readLine()) != null) {
                        if (line.isEmpty()) continue;
                        System.out.println(line);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static boolean isWindowsPlatform() {
        String os = System.getProperty("os.name");
        return os.toLowerCase().contains("win");
    }
}

