/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.tutorial.tutorial;

import com.nxp.swtools.common.ui.utils.swt.FontFactory;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class WidgetHighlighter {
    @NonNull
    public static final String KEY_TUTORIAL = "tutorial";
    private static final int OVERLAY_OPACITY = 150;
    @NonNull
    public Shell shell;
    @NonNull
    public Shell overlayShell;
    @NonNull
    String text = "";
    @NonNull
    Canvas canvas;

    public WidgetHighlighter(final @NonNull Shell shell) {
        this.shell = shell;
        shell.forceActive();
        final Display display = shell.getDisplay();
        this.overlayShell = new Shell(shell, 8);
        this.overlayShell.setLayout((Layout)new FillLayout());
        this.overlayShell.setData(KEY_TUTORIAL, (Object)Boolean.TRUE);
        this.overlayShell.setBounds(shell.getBounds());
        this.overlayShell.setAlpha(150);
        this.overlayShell.setBackground(display.getSystemColor(2));
        this.overlayShell.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 27) {
                    shell.getDisplay().asyncExec(() -> WidgetHighlighter.this.overlayShell.close());
                }
            }
        });
        this.overlayShell.open();
        this.canvas = new Canvas((Composite)this.overlayShell, 0);
        this.canvas.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                shell.getDisplay().asyncExec(() -> WidgetHighlighter.this.overlayShell.close());
            }
        });
        FontFactory.scaleFontSize((Control)this.canvas, (double)5.0);
        this.canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                GC gc = e.gc;
                if (!$assertionsDisabled && gc == null) {
                    throw new AssertionError();
                }
                gc.setForeground(display.getSystemColor(1));
                Point extent = gc.textExtent(WidgetHighlighter.this.text);
                gc.drawText(WidgetHighlighter.this.text, (WidgetHighlighter.this.canvas.getSize().x - extent.x) / 2, WidgetHighlighter.this.canvas.getSize().y - (int)((double)extent.y * 1.2), true);
            }
        });
        Point canvasSize = this.overlayShell.getSize();
        this.canvas.setSize(canvasSize);
        this.canvas.setBackground(display.getSystemColor(2));
    }

    public static @Nullable WidgetHighlighter createFor(@NonNull String testId, @NonNull Shell shell) {
        if (WidgetHighlighter.findControl(testId, (Control)shell) != null) {
            WidgetHighlighter shellTutorial = new WidgetHighlighter(shell);
            shellTutorial.highlightControl(testId);
            return shellTutorial;
        }
        return null;
    }

    public static @Nullable WidgetHighlighter createFor(@NonNull String testId, @NonNull Shell @NonNull [] shells) {
        Shell[] shellArray = shells;
        int n = shells.length;
        int n2 = 0;
        while (n2 < n) {
            Shell shell = shellArray[n2];
            WidgetHighlighter shellTutorial = WidgetHighlighter.createFor(testId, shell);
            if (shellTutorial != null) {
                return shellTutorial;
            }
            ++n2;
        }
        return null;
    }

    public @NonNull Shell getShell() {
        return this.shell;
    }

    public boolean highlightControl(@NonNull String testId) {
        Display display = this.shell.getDisplay();
        Control control = WidgetHighlighter.findControl(testId, (Control)this.shell);
        if (control != null) {
            Rectangle controlBounds = display.map((Control)control.getParent(), (Control)this.overlayShell, control.getBounds());
            if (controlBounds.width > 0) {
                Composite parent = control.getParent();
                while (parent != null && parent.getParent() != null) {
                    Rectangle newBounds = controlBounds.intersection(display.map((Control)parent.getParent(), (Control)this.overlayShell, parent.getBounds()));
                    if (newBounds.width == 0 || newBounds.height == 0) {
                        newBounds = display.map((Control)parent.getParent(), (Control)this.overlayShell, parent.getBounds());
                        control = parent;
                    }
                    controlBounds = newBounds;
                    parent = parent.getParent();
                }
                Region region = new Region();
                region.add(new Rectangle(0, 0, this.shell.getBounds().width, this.shell.getBounds().height));
                region.subtract(controlBounds);
                this.overlayShell.setRegion(region);
                this.canvas.redraw();
            }
            return true;
        }
        return false;
    }

    public void setText(@NonNull String text) {
        this.text = text;
        this.canvas.redraw();
    }

    public static @Nullable Control findControl(@NonNull String testId, @NonNull Control in) {
        Control[] children;
        if (testId.equals(in.getData("test-id"))) {
            return in;
        }
        if (in instanceof Composite && (children = ((Composite)in).getChildren()) != null) {
            Control[] controlArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control result;
                Control child = controlArray[n2];
                if (child != null && (result = WidgetHighlighter.findControl(testId, child)) != null) {
                    return result;
                }
                ++n2;
            }
        }
        return null;
    }

    public void close() {
        if (!this.overlayShell.isDisposed()) {
            this.overlayShell.dispose();
        }
    }
}

