/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.debug.ka.osek.utils;

import com.freescale.s32ds.debug.ka.osek.implementation.OrtiObjectAttribute;
import java.util.Arrays;
import java.util.regex.Pattern;

public class OrtiGlobal {
    public static final String DEFAULT_LOG_MSG_FORMAT = "[%s]%s";
    public static final String TRACE_ELEMENT_ID_FORMAT = "%s\\%s\\%s";
    public static final String OS_SERVICETRACE = "SERVICETRACE";
    public static final int ORTI_EVENT_TYPE = 6735;
    public static final Pattern ORTI_HYPER_LINK_REGEX_PATTERN = Pattern.compile(OrtiGlobal.HL(".+"));
    public static final char NOT_AVAILABLE_HEX_DIGIT = '?';
    public static final String COLUMN_NAME = "Name";

    public static Pattern GetHyperLinkPattern() {
        return Pattern.compile(OrtiGlobal.HL(".+"));
    }

    public static String HL(String text) {
        return "@" + text + "@";
    }

    public static String NADigit(int size) {
        char[] returnStr = new char[size * 2];
        Arrays.fill(returnStr, '?');
        return new String(returnStr);
    }

    public static String FormatIntAttr(long intValue, int representBase, int size) {
        StringBuilder retStr = new StringBuilder();
        switch (representBase) {
            case 2: {
                retStr.append("0b");
                break;
            }
            case 8: {
                retStr.append("0");
                break;
            }
            case 16: {
                retStr.append("0x");
            }
        }
        long mask = 0L | (1L << 8 * size) - 1L;
        retStr.append(Long.toString(intValue & mask, representBase));
        return retStr.toString();
    }

    public static String FormatIntAttr(OrtiObjectAttribute attr) {
        return OrtiGlobal.FormatIntAttr(attr.getValue(), attr.getRepresentBase(), attr.getSize());
    }

    public static enum EnumValueShow {
        LabelOnly("Show label"),
        ValueOnly("Show value"),
        LabelValue("Show label and value");

        public String label;

        private EnumValueShow(String l) {
            this.label = l;
        }
    }

    public static enum IntBases {
        Binary(2),
        Octal(8),
        Decimal(10),
        Hex(16);

        private int base = 2;

        private IntBases(int base) {
            this.base = base;
        }

        public int getBase() {
            return this.base;
        }
    }
}

