/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.debug.ka.osek.utils;

import com.freescale.s32ds.debug.ka.osek.implementation.OrtiImplAttr;
import com.freescale.s32ds.debug.ka.osek.implementation.OrtiObject;
import com.freescale.s32ds.debug.ka.osek.implementation.OrtiObjectAttribute;
import com.freescale.s32ds.debug.ka.osek.orti.model.OrtiImplementation;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;

public class TypeObjectTableSorter
extends ViewerSorter {
    private String attributeName = "Name";
    private boolean direction = true;
    private OrtiImplementation.ImplObjectInfo implInfo;
    private OrtiImplAttr sortImplAttr;

    public TypeObjectTableSorter(OrtiImplementation.ImplObjectInfo info) {
        this.implInfo = info;
    }

    public void setColumn(String columnName) {
        if (columnName.equals(this.attributeName)) {
            this.direction = !this.direction;
        } else {
            this.sortImplAttr = null;
            OrtiImplAttr[] ortiImplAttrArray = this.implInfo.implObject.getAtributes();
            int n = ortiImplAttrArray.length;
            int n2 = 0;
            while (n2 < n) {
                OrtiImplAttr attr = ortiImplAttrArray[n2];
                if (attr.name.equals(columnName)) {
                    this.sortImplAttr = attr;
                    break;
                }
                ++n2;
            }
            this.attributeName = columnName;
            this.direction = true;
        }
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        int result = -1;
        if (e1 instanceof OrtiObject && e2 instanceof OrtiObject) {
            OrtiObject obj1 = (OrtiObject)e1;
            OrtiObject obj2 = (OrtiObject)e2;
            if (this.sortImplAttr == null || this.attributeName.equals("Name")) {
                result = obj1.name.compareTo(obj2.name);
            } else {
                OrtiObjectAttribute attr1 = null;
                OrtiObjectAttribute attr2 = null;
                int i = 0;
                while (i < obj1.getAtributes().length) {
                    if (obj1.getAtributes()[i].implAttribute.name.equals(this.attributeName)) {
                        attr1 = obj1.getAtributes()[i];
                        break;
                    }
                    ++i;
                }
                if (attr1 == null) {
                    return -1;
                }
                i = 0;
                while (i < obj2.getAtributes().length) {
                    if (obj2.getAtributes()[i].implAttribute.name.equals(this.attributeName)) {
                        attr2 = obj2.getAtributes()[i];
                        break;
                    }
                    ++i;
                }
                if (attr2 == null) {
                    return 1;
                }
                switch (this.sortImplAttr.getType()) {
                    case 3: {
                        result = attr1.formula.compareTo(attr2.formula);
                        break;
                    }
                    case 1: 
                    case 2: {
                        result = attr1.getValue() - attr2.getValue();
                    }
                }
            }
        }
        if (!this.direction) {
            result *= -1;
        }
        return result;
    }
}

