/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.s32debugger.flash.internal.ui;

import com.nxp.s32ds.debug.ide.core.AttributeReadingUtils;
import com.nxp.s32ds.debug.ide.core.S32DebuggerErrorStatuses;
import com.nxp.s32ds.debug.ide.s32debugger.flash.internal.ui.S32DebuggerFlashLaunchImages;
import com.nxp.s32ds.debug.ide.s32debugger.flash.internal.ui.S32DebuggerFlashProgrammerMainTabMessages;
import com.nxp.s32ds.debug.ide.s32debugger.flash.internal.ui.dialogs.S32DebuggerFlashElementDialog;
import com.nxp.s32ds.debug.ide.s32debugger.flash.validation.FlashElementConfiguration;
import com.nxp.s32ds.debug.ide.s32debugger.flash.validation.S32DebuggerFlashProgrammerAttributesValidator;
import com.nxp.s32ds.debug.ide.s32debugger.flash.validation.S32DebuggerFlashProgrammerParams;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class S32DebuggerFlashProgrammerMainTab
extends AbstractLaunchConfigurationTab {
    private static final String TAB_NAME = "Main";
    private List<FlashElementConfiguration> flashElements = new ArrayList<FlashElementConfiguration>();
    private CheckboxTableViewer tableViewer;
    private Button btnUp;
    private Button btnDown;
    private Button btnAdd;
    private Button btnDelete;
    private Button btnEdit;
    private Button btnVerifyAfterWrite;
    private Button btnEraseChip;
    private static final int COLUMN0_WIDTH = 28;
    private static final int COLUMN1_WIDTH = 400;
    private static final int COLUMN2_WIDTH = 75;
    private static final int COLUMN3_WIDTH = 85;
    private static final int COLUMN4_WIDTH = 83;

    public void createControl(Composite parent) {
        Composite entireComposite = new Composite(parent, 0);
        this.setControl((Control)entireComposite);
        entireComposite.setLayout((Layout)new GridLayout(2, false));
        this.createTableView(entireComposite);
        this.createSideButtons(entireComposite);
        Composite checkButtons = new Composite(entireComposite, 0);
        checkButtons.setLayout((Layout)new GridLayout(1, true));
        this.btnVerifyAfterWrite = new Button(checkButtons, 32);
        this.btnVerifyAfterWrite.setSelection(false);
        this.btnVerifyAfterWrite.setText(S32DebuggerFlashProgrammerMainTabMessages.S32DebuggerFlashProgrammerMainTab_verify_after_write_button);
        this.btnVerifyAfterWrite.addListener(13, listener -> this.updateLaunchConfigurationDialog());
        this.btnEraseChip = new Button(checkButtons, 32);
        this.btnEraseChip.setSelection(false);
        this.btnEraseChip.setText(S32DebuggerFlashProgrammerMainTabMessages.S32DebuggerFlashProgrammerMainTab_erase_all_memory);
        this.btnEraseChip.addListener(13, listener -> this.updateLaunchConfigurationDialog());
        this.tableViewer.addSelectionChangedListener(event -> this.updateButtonsEnablement());
        this.tableViewer.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                S32DebuggerFlashProgrammerMainTab.this.btnEdit.notifyListeners(13, new Event());
            }
        });
        this.tableViewer.addCheckStateListener(event -> {
            ((FlashElementConfiguration)event.getElement()).setEnabled(event.getChecked());
            this.updateLaunchConfigurationDialog();
        });
        this.tableViewer.getControl().addListener(1, event -> {
            if (event.keyCode == 127) {
                this.btnDelete.notifyListeners(13, null);
            }
        });
        this.updateButtonsEnablement();
    }

    private void createTableView(Composite parent) {
        this.tableViewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)68354);
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new TableElementsProvider());
        this.tableViewer.setInput(this.flashElements);
        Table table = this.tableViewer.getTable();
        table.setFont(parent.getFont());
        table.setHeaderVisible(true);
        table.setLayoutData((Object)new GridData(1808));
        TableColumn column0 = new TableColumn(table, 0);
        column0.setWidth(28);
        column0.setResizable(false);
        TableColumn column1 = new TableColumn(table, 0);
        column1.setText(S32DebuggerFlashProgrammerMainTabMessages.S32DebuggerFlashProgrammerMainTab_table_application_label);
        column1.setWidth(400);
        TableColumn column2 = new TableColumn(table, 0);
        column2.setText(S32DebuggerFlashProgrammerMainTabMessages.S32DebuggerFlashProgrammerMainTab_table_binary_type);
        column2.setWidth(75);
        TableColumn column3 = new TableColumn(table, 0);
        column3.setText(S32DebuggerFlashProgrammerMainTabMessages.S32DebuggerFlashProgrammerMainTab_table_project_label);
        column3.setWidth(85);
        TableColumn column4 = new TableColumn(table, 0);
        column4.setText(S32DebuggerFlashProgrammerMainTabMessages.S32DebuggerFlashProgrammerMainTab_table_base_address_label);
        column4.setWidth(83);
    }

    private void createSideButtons(Composite parent) {
        Composite layout = new Composite(parent, 0);
        layout.setLayout((Layout)new GridLayout());
        GridData layoutData = new GridData();
        layoutData.verticalAlignment = 1;
        layoutData.widthHint = 100;
        layout.setLayoutData((Object)layoutData);
        this.btnUp = this.createSidePushButton(layout, S32DebuggerFlashProgrammerMainTabMessages.S32DebuggerFlashProgrammerMainTab_up_button);
        this.btnUp.addListener(13, listener -> {
            int index = this.getSingleSelectionIndex();
            FlashElementConfiguration flashElement = this.flashElements.get(index);
            this.flashElements.set(index, this.flashElements.get(index - 1));
            this.flashElements.set(index - 1, flashElement);
            this.updateLaunchConfigurationDialog();
            this.updateButtonsEnablement();
        });
        this.btnDown = this.createSidePushButton(layout, S32DebuggerFlashProgrammerMainTabMessages.S32DebuggerFlashProgrammerMainTab_down_button);
        this.btnDown.addListener(13, listener -> {
            int index = this.getSingleSelectionIndex();
            FlashElementConfiguration flashElement = this.flashElements.get(index);
            this.flashElements.set(index, this.flashElements.get(index + 1));
            this.flashElements.set(index + 1, flashElement);
            this.updateLaunchConfigurationDialog();
            this.updateButtonsEnablement();
        });
        this.btnAdd = this.createSidePushButton(layout, S32DebuggerFlashProgrammerMainTabMessages.S32DebuggerFlashProgrammerMainTab_add_button);
        this.btnAdd.addListener(13, listener -> {
            S32DebuggerFlashElementDialog dialog = new S32DebuggerFlashElementDialog(this.tableViewer.getControl().getShell(), null);
            dialog.addAlreadyCreatedElements(this.flashElements);
            if (dialog.open() == 0) {
                FlashElementConfiguration flashElement = dialog.getFlashElementData();
                flashElement.setEnabled(true);
                this.flashElements.add(flashElement);
                Display.getDefault().asyncExec(() -> this.tableViewer.setChecked((Object)flashElement, flashElement.isEnabled()));
                this.updateLaunchConfigurationDialog();
                this.updateButtonsEnablement();
            }
        });
        this.btnDelete = this.createSidePushButton(layout, S32DebuggerFlashProgrammerMainTabMessages.S32DebuggerFlashProgrammerMainTab_delete_button);
        this.btnDelete.addListener(13, listener -> {
            Integer[] indices = this.getMultiSelectionIndices();
            if (indices.length < 1) {
                return;
            }
            int i = indices.length - 1;
            while (i >= 0) {
                this.flashElements.remove(indices[i]);
                --i;
            }
            this.updateLaunchConfigurationDialog();
            this.updateButtonsEnablement();
        });
        this.btnEdit = this.createSidePushButton(layout, S32DebuggerFlashProgrammerMainTabMessages.S32DebuggerFlashProgrammerMainTab_edit_button);
        this.btnEdit.addListener(13, listener -> {
            int index = this.getSingleSelectionIndex();
            if (index < 0) {
                return;
            }
            FlashElementConfiguration flashElement = this.flashElements.get(index);
            S32DebuggerFlashElementDialog dialog = new S32DebuggerFlashElementDialog(this.tableViewer.getControl().getShell(), flashElement);
            dialog.addAlreadyCreatedElements(this.flashElements);
            if (dialog.open() == 0) {
                this.updateLaunchConfigurationDialog();
                this.updateButtonsEnablement();
            }
        });
    }

    private Button createSidePushButton(Composite parent, String text) {
        Button button = new Button(parent, 8);
        button.setText(text);
        button.setFont(parent.getFont());
        GridData layoutData = new GridData(768);
        button.setLayoutData((Object)layoutData);
        return button;
    }

    private void updateButtonsEnablement() {
        int index = this.getSingleSelectionIndex();
        this.btnDown.setEnabled(index >= 0 && index != this.flashElements.size() - 1);
        this.btnUp.setEnabled(this.getSingleSelectionIndex() > 0);
        int selectionCount = ((StructuredSelection)this.tableViewer.getSelection()).size();
        this.btnEdit.setEnabled(selectionCount == 1);
        this.btnDelete.setEnabled(selectionCount > 0);
    }

    private int getSingleSelectionIndex() {
        StructuredSelection selection = (StructuredSelection)this.tableViewer.getSelection();
        if (selection.size() != 1) {
            return -1;
        }
        FlashElementConfiguration flashElement = (FlashElementConfiguration)selection.getFirstElement();
        return this.flashElements.indexOf(flashElement);
    }

    private Integer[] getMultiSelectionIndices() {
        StructuredSelection sel = (StructuredSelection)this.tableViewer.getSelection();
        ArrayList<Integer> indices = new ArrayList<Integer>();
        for (FlashElementConfiguration flashElement : sel) {
            indices.add(this.flashElements.indexOf(flashElement));
        }
        return (Integer[])Arrays.copyOf(indices.toArray(), indices.size(), Integer[].class);
    }

    public boolean isValid(ILaunchConfiguration lc) {
        this.tableViewer.refresh();
        this.setErrorMessage(null);
        this.setWarningMessage(null);
        S32DebuggerFlashProgrammerAttributesValidator validator = new S32DebuggerFlashProgrammerAttributesValidator();
        S32DebuggerFlashProgrammerParams params = S32DebuggerFlashProgrammerParams.getParams((ILaunchConfiguration)lc);
        IStatus errorOrWarning = validator.validateProjectParameters(params);
        if (errorOrWarning.matches(4)) {
            this.setErrorMessage(errorOrWarning.getMessage());
            return false;
        }
        if (errorOrWarning.matches(2)) {
            this.setWarningMessage(errorOrWarning.getMessage());
        }
        return true;
    }

    public String getName() {
        return TAB_NAME;
    }

    public void initializeFrom(ILaunchConfiguration lc) {
        this.flashElements.clear();
        S32DebuggerFlashProgrammerParams programmererParams = S32DebuggerFlashProgrammerParams.getParams((ILaunchConfiguration)lc);
        Map idToBinaryMap = programmererParams.getIdToBinaryMap();
        Map binaryIdToBinaryTypeMap = programmererParams.getBinaryIdToBinaryTypeMap();
        Map binaryIdIsEnabledMap = programmererParams.getBinaryIdIsEnabledMap();
        Map binaryIdToBaseAddressMap = programmererParams.getBinaryIdToBaseAddressMap();
        Map binaryIdToProjectNameMap = programmererParams.getBinaryIdToProjectNameMap();
        if (!idToBinaryMap.isEmpty()) {
            for (String binaryId : idToBinaryMap.keySet()) {
                FlashElementConfiguration config = new FlashElementConfiguration();
                config.setBinaryPath((String)idToBinaryMap.get(binaryId));
                config.setBinaryType(binaryIdToBinaryTypeMap.getOrDefault(binaryId, "elf"));
                String enabled = binaryIdIsEnabledMap.getOrDefault(binaryId, "enabled");
                config.setEnabled("enabled".equals(enabled));
                String baseAddress = binaryIdToBaseAddressMap.getOrDefault(binaryId, "");
                if (!baseAddress.isEmpty()) {
                    config.setUseBaseAddress(true);
                    config.setBaseAddress(baseAddress);
                } else {
                    config.setUseBaseAddress(false);
                    config.setBaseAddress("");
                }
                config.setProjectName(binaryIdToProjectNameMap.getOrDefault(binaryId, ""));
                this.flashElements.add(config);
                if (!config.isEnabled()) continue;
                Display.getDefault().asyncExec(() -> this.tableViewer.setChecked((Object)config, true));
            }
            this.updateButtonsEnablement();
        }
        this.btnVerifyAfterWrite.setSelection(programmererParams.isVerifyAfterWrite());
        this.btnEraseChip.setSelection(programmererParams.isFlashMemoryErase());
        ArrayList readErrors = programmererParams.getReadErrors();
        if (!readErrors.isEmpty()) {
            AttributeReadingUtils.handleAttributeReadingFailure((IStatus)S32DebuggerErrorStatuses.getAttributesReadingFailedStatus((List)readErrors));
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy lc) {
        S32DebuggerFlashProgrammerParams programmererParams = S32DebuggerFlashProgrammerParams.getParams((ILaunchConfiguration)lc);
        HashMap<String, String> idToBinaryMap = new HashMap<String, String>();
        HashMap<String, String> binaryIdToBinaryTypeMap = new HashMap<String, String>();
        HashMap<String, String> binaryIdIsEnabledMap = new HashMap<String, String>();
        HashMap<String, String> binaryIdToBaseAddressMap = new HashMap<String, String>();
        HashMap<String, String> binaryIdToProjectNameMap = new HashMap<String, String>();
        for (FlashElementConfiguration config : this.flashElements) {
            String binaryId = programmererParams.getNextProjectId();
            idToBinaryMap.put(binaryId, config.getBinaryPath());
            binaryIdToBinaryTypeMap.put(binaryId, config.getBinaryType());
            binaryIdIsEnabledMap.put(binaryId, config.isEnabled() ? "enabled" : "disabled");
            binaryIdToBaseAddressMap.put(binaryId, config.getBaseAddress());
            binaryIdToProjectNameMap.put(binaryId, config.getProjectName());
        }
        programmererParams.setIdToBinaryMap(idToBinaryMap);
        programmererParams.setBinaryIdToBinaryTypeMap(binaryIdToBinaryTypeMap);
        programmererParams.setBinaryIdIsEnabledMap(binaryIdIsEnabledMap);
        programmererParams.setBinaryIdToBaseAddressMap(binaryIdToBaseAddressMap);
        programmererParams.setBinaryIdToProjectNameMap(binaryIdToProjectNameMap);
        programmererParams.verifyAfterWrite(this.btnVerifyAfterWrite.getSelection());
        programmererParams.setFlashMemoryErase(this.btnEraseChip.getSelection());
        programmererParams.applyParams(lc);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy lc) {
        S32DebuggerFlashProgrammerParams.applyDefaults((ILaunchConfigurationWorkingCopy)lc);
    }

    public Image getImage() {
        return S32DebuggerFlashLaunchImages.getMainTabImage();
    }

    private static class TableElementsProvider
    extends BaseLabelProvider
    implements ITableLabelProvider {
        private TableElementsProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (!(element instanceof FlashElementConfiguration)) {
                return null;
            }
            FlashElementConfiguration flashElement = (FlashElementConfiguration)element;
            if (columnIndex == 0) {
                return null;
            }
            if (columnIndex == 1) {
                return flashElement.getBinaryPath();
            }
            if (columnIndex == 2) {
                return flashElement.getBinaryType();
            }
            if (columnIndex == 3) {
                return flashElement.getProjectName();
            }
            if (columnIndex == 4) {
                return flashElement.getBaseAddress();
            }
            return null;
        }
    }
}

