/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.bootimage.binders;

import com.nxp.swtools.bootimage.model.ArrayDataModel;
import com.nxp.swtools.bootimage.settings.AlignToValueSetting;
import com.nxp.swtools.bootimage.settings.BoolSetting;
import com.nxp.swtools.bootimage.settings.EnumSetting;
import com.nxp.swtools.bootimage.settings.IntegerSetting;
import com.nxp.swtools.bootimage.settings.LimitValuesSetting;
import com.nxp.swtools.bootimage.settings.TextSetting;
import com.nxp.swtools.common.uct.validation.IProblemSource;
import com.nxp.swtools.common.utils.NonNullByDefault;
import com.nxp.swtools.common.utils.Nullable;
import java.util.List;
import java.util.Objects;

@NonNullByDefault
public class ArrayDataBinder
implements IProblemSource {
    protected ArrayDataModel dataModel;

    public ArrayDataBinder(ArrayDataModel dataModel) {
        this.dataModel = dataModel;
    }

    public Integer getIndex() {
        return this.dataModel.getIndex();
    }

    public void setIndex(int index) {
        this.dataModel.setIndex(index);
    }

    public List<BoolSetting> getBoolSettings() {
        return this.dataModel.getBoolSettings();
    }

    public void addBoolSetting(BoolSetting boolSetting) {
        for (BoolSetting currentBoolSetting : this.dataModel.getBoolSettings()) {
            if (!currentBoolSetting.getId().equals(boolSetting.getId())) continue;
            return;
        }
        BoolSetting newBoolSetting = ArrayDataBinder.createBoolSettingFromModel(boolSetting);
        this.dataModel.getBoolSettings().add(newBoolSetting);
    }

    private static BoolSetting createBoolSettingFromModel(BoolSetting modelSetting) {
        BoolSetting newBoolSetting = new BoolSetting(modelSetting.getId(), modelSetting.getLabel(), modelSetting.getDescription(), modelSetting.getOffset(), modelSetting.getSize(), modelSetting.getInitValue(), modelSetting.getValueToWrite(), modelSetting.getOptions(), modelSetting.getMessages(), modelSetting.getByteOrder());
        newBoolSetting.setCurrentDisableState(modelSetting.getCurrentDisableState().get());
        newBoolSetting.setDisableConditionsList(modelSetting.getDisableConditionsList());
        newBoolSetting.setConfigurableConditionsList(modelSetting.getConfigurableConditionsList());
        newBoolSetting.setVisibleConditionsList(modelSetting.getVisibleConditionsList());
        newBoolSetting.setEnableStatesList(modelSetting.getEnableStatesList());
        newBoolSetting.setCurrentSelection(modelSetting.getCurrentSelection());
        newBoolSetting.setOptions(modelSetting.getOptions());
        return newBoolSetting;
    }

    public @Nullable BoolSetting getBoolSettingById(String id) {
        for (BoolSetting boolSetting : this.dataModel.getBoolSettings()) {
            if (!boolSetting.getId().equals(id)) continue;
            return boolSetting;
        }
        return null;
    }

    public List<EnumSetting> getEnumSettings() {
        return this.dataModel.getEnumSettings();
    }

    public void addEnumSetting(EnumSetting enumSetting) {
        for (EnumSetting currentEnumSetting : this.dataModel.getEnumSettings()) {
            if (!currentEnumSetting.getId().equals(enumSetting.getId())) continue;
            return;
        }
        EnumSetting newEnumSetting = ArrayDataBinder.createEnumSettingFromModel(enumSetting);
        this.dataModel.getEnumSettings().add(newEnumSetting);
    }

    private static EnumSetting createEnumSettingFromModel(EnumSetting modelSetting) {
        EnumSetting newSetting = new EnumSetting(modelSetting.getId(), modelSetting.getLabel(), modelSetting.getDescription(), modelSetting.getOffset(), modelSetting.getSize(), modelSetting.getInitValue(), modelSetting.getValueToWrite(), modelSetting.getOptions(), modelSetting.getMessages());
        newSetting.setItems(modelSetting.getItems());
        newSetting.setCurrentDisableState(modelSetting.getCurrentDisableState().get());
        newSetting.setDisableConditionsList(modelSetting.getDisableConditionsList());
        newSetting.setConfigurableConditionsList(modelSetting.getConfigurableConditionsList());
        newSetting.setVisibleConditionsList(modelSetting.getVisibleConditionsList());
        newSetting.setEnableStatesList(modelSetting.getEnableStatesList());
        newSetting.setCurrentSelection(modelSetting.getCurrentSelection());
        newSetting.setOptions(modelSetting.getOptions());
        return newSetting;
    }

    public @Nullable EnumSetting getEnumSettingById(String id) {
        for (EnumSetting enumSetting : this.dataModel.getEnumSettings()) {
            if (!enumSetting.getId().equals(id)) continue;
            return enumSetting;
        }
        return null;
    }

    public List<IntegerSetting> getIntegerSettings() {
        return this.dataModel.getIntegerSettings();
    }

    public void addIntegerSetting(IntegerSetting integerSetting) {
        for (IntegerSetting currentIntegerSetting : this.dataModel.getIntegerSettings()) {
            if (!currentIntegerSetting.getId().equals(integerSetting.getId())) continue;
            return;
        }
        IntegerSetting newIntegerSetting = ArrayDataBinder.createIntegerSettingFromModel(integerSetting);
        this.dataModel.getIntegerSettings().add(newIntegerSetting);
    }

    private static IntegerSetting createIntegerSettingFromModel(IntegerSetting modelSetting) {
        IntegerSetting newSetting = new IntegerSetting(modelSetting.getId(), modelSetting.getLabel(), modelSetting.getDescription(), modelSetting.getOffset(), modelSetting.getSize(), modelSetting.getInitValue(), modelSetting.getConstraintsRefs(), modelSetting.getOptions(), modelSetting.getLockedSetting(), modelSetting.getValueExpression(), modelSetting.getMessages(), null, null, modelSetting.getInputFileRef(), modelSetting.getInputFileOffset(), modelSetting.getInputFileSize());
        newSetting.setCurrentDisableState(modelSetting.getCurrentDisableState().get());
        newSetting.setDisableConditionsList(modelSetting.getDisableConditionsList());
        newSetting.setConfigurableConditionsList(modelSetting.getConfigurableConditionsList());
        newSetting.setVisibleConditionsList(modelSetting.getVisibleConditionsList());
        newSetting.setEnableStatesList(modelSetting.getEnableStatesList());
        newSetting.setValueToWrite(modelSetting.getValueToWrite());
        newSetting.setOptions(modelSetting.getOptions());
        return newSetting;
    }

    public @Nullable IntegerSetting getIntegerSettingById(String id) {
        for (IntegerSetting integerSetting : this.dataModel.getIntegerSettings()) {
            if (!integerSetting.getId().equals(id)) continue;
            return integerSetting;
        }
        return null;
    }

    public List<TextSetting> getTextSettings() {
        return this.dataModel.getTextSettings();
    }

    public void addTextSetting(TextSetting textSetting) {
        for (TextSetting currentSetting : this.dataModel.getTextSettings()) {
            if (!currentSetting.getId().equals(textSetting.getId())) continue;
            return;
        }
        TextSetting newTextSetting = ArrayDataBinder.createTextSettingFromModel(textSetting);
        this.dataModel.getTextSettings().add(newTextSetting);
    }

    private static TextSetting createTextSettingFromModel(TextSetting modelSetting) {
        return new TextSetting(modelSetting.getId(), modelSetting.getLabel(), modelSetting.getDescription(), modelSetting.getOffset(), modelSetting.getSize(), modelSetting.getInitValue(), modelSetting.getValueToWrite(), modelSetting.getOptions(), modelSetting.getMessage(), modelSetting.getMessages());
    }

    public @Nullable TextSetting getTextSettingById(String id) {
        for (TextSetting textSetting : this.dataModel.getTextSettings()) {
            if (!textSetting.getId().equals(id)) continue;
            return textSetting;
        }
        return null;
    }

    public List<LimitValuesSetting> getLimitValuesConstraints() {
        return this.dataModel.getLimitValuesConstraints();
    }

    public void addLimitValuesConstraint(LimitValuesSetting limitValuesConstraint) {
        for (LimitValuesSetting setting : this.dataModel.getLimitValuesConstraints()) {
            if (!setting.getId().equals(limitValuesConstraint.getId())) continue;
            return;
        }
        LimitValuesSetting newSetting = new LimitValuesSetting(limitValuesConstraint.getId(), limitValuesConstraint.getLabel(), limitValuesConstraint.getDescription(), limitValuesConstraint.getMinValue(), limitValuesConstraint.getMaxValue(), limitValuesConstraint.getMinValueExpression(), limitValuesConstraint.getMaxValueExpression(), limitValuesConstraint.getOptions(), limitValuesConstraint.getMessages());
        newSetting.setCurrentDisableState(limitValuesConstraint.getCurrentDisableState().get());
        newSetting.setDisableConditionsList(limitValuesConstraint.getDisableConditionsList());
        newSetting.setConfigurableConditionsList(limitValuesConstraint.getConfigurableConditionsList());
        newSetting.setEnableStatesList(limitValuesConstraint.getEnableStatesList());
        newSetting.setVisibleConditionsList(limitValuesConstraint.getVisibleConditionsList());
        newSetting.setOptions(limitValuesConstraint.getOptions());
        this.dataModel.getLimitValuesConstraints().add(newSetting);
    }

    public @Nullable LimitValuesSetting getLimitValuesConstraintById(String id) {
        for (LimitValuesSetting limitRange : this.dataModel.getLimitValuesConstraints()) {
            if (!limitRange.getId().equals(id)) continue;
            return limitRange;
        }
        return null;
    }

    public List<AlignToValueSetting> getAlignToValueConstraints() {
        return this.dataModel.getAlignToValueConstraints();
    }

    public void addAlignToValueConstraint(AlignToValueSetting alignToValueConstraint) {
        for (AlignToValueSetting setting : this.dataModel.getAlignToValueConstraints()) {
            if (!setting.getId().equals(alignToValueConstraint.getId())) continue;
            return;
        }
        AlignToValueSetting newSetting = new AlignToValueSetting(alignToValueConstraint.getId(), alignToValueConstraint.getLabel(), alignToValueConstraint.getDescription(), alignToValueConstraint.getInitValue(), alignToValueConstraint.getOptions(), alignToValueConstraint.getMessages());
        newSetting.setCurrentDisableState(alignToValueConstraint.getCurrentDisableState().get());
        newSetting.setDisableConditionsList(alignToValueConstraint.getDisableConditionsList());
        newSetting.setConfigurableConditionsList(alignToValueConstraint.getConfigurableConditionsList());
        newSetting.setEnableStatesList(alignToValueConstraint.getEnableStatesList());
        newSetting.setVisibleConditionsList(alignToValueConstraint.getVisibleConditionsList());
        newSetting.setOptions(alignToValueConstraint.getOptions());
        this.dataModel.getAlignToValueConstraints().add(newSetting);
    }

    public @Nullable AlignToValueSetting getAlignToValueConstraintById(String id) {
        for (AlignToValueSetting alignToValueConstraint : this.dataModel.getAlignToValueConstraints()) {
            if (!alignToValueConstraint.getId().equals(id)) continue;
            return alignToValueConstraint;
        }
        return null;
    }

    public void setDisableStateForComponents(boolean state) {
        this.dataModel.getBoolSettings().forEach(setting -> setting.setCurrentDisableState(state));
        this.dataModel.getEnumSettings().forEach(setting -> setting.setCurrentDisableState(state));
        this.dataModel.getIntegerSettings().forEach(setting -> setting.setCurrentDisableState(state));
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArrayDataBinder other = (ArrayDataBinder)obj;
        return this.getIndex().intValue() == other.getIndex().intValue() && Objects.equals(this.getBoolSettings(), other.getBoolSettings()) && Objects.equals(this.getEnumSettings(), other.getEnumSettings()) && Objects.equals(this.getIntegerSettings(), other.getIntegerSettings()) && Objects.equals(this.getTextSettings(), other.getTextSettings()) && Objects.equals(this.getAlignToValueConstraints(), other.getAlignToValueConstraints()) && Objects.equals(this.getLimitValuesConstraints(), other.getLimitValuesConstraints());
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.getIndex().hashCode();
        result = 31 * result + Objects.hashCode(this.getBoolSettings());
        result = 31 * result + Objects.hashCode(this.getEnumSettings());
        result = 31 * result + Objects.hashCode(this.getEnumSettings());
        result = 31 * result + Objects.hashCode(this.getIntegerSettings());
        result = 31 * result + Objects.hashCode(this.getTextSettings());
        result = 31 * result + Objects.hashCode(this.getAlignToValueConstraints());
        result = 31 * result + Objects.hashCode(this.getLimitValuesConstraints());
        return result;
    }
}

