/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.bootimage.settings;

import com.nxp.swtools.bootimage.settings.ABaseComponentSetting;
import com.nxp.swtools.bootimage.settings.Description;
import com.nxp.swtools.bootimage.settings.MessagesSetting;
import com.nxp.swtools.bootimage.utils.BootXmlConstants;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.number.NumberFormatValidator;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Root;

@Root(name="version", strict=false)
public class VersionSetting
extends ABaseComponentSetting {
    private static final Logger LOGGER = LogManager.getLogger(VersionSetting.class);
    @Attribute(name="size")
    private String size;
    @Attribute(name="offset")
    private String offset;

    public VersionSetting(String id, String label, @Nullable Description description, String size, String value, String offset, String options, @Nullable MessagesSetting messages) {
        super(id, label, description, value, options, messages, -1L, "");
        this.size = size;
        this.offset = offset;
    }

    public VersionSetting() {
        this.size = "";
        this.offset = "";
    }

    public int getSizeValue() {
        int sizeVal = 0;
        Matcher matcher = BootXmlConstants.SIZE_BYTE_UNIT_VALUE_REGEXP.matcher(this.size);
        if (matcher.matches() && matcher.groupCount() > 1) {
            try {
                return Integer.parseInt(matcher.group(1));
            }
            catch (NumberFormatException err) {
                LOGGER.log(Level.WARNING, "Error parsing  ", err);
                return 0;
            }
        }
        return sizeVal;
    }

    public int getOffsetValue() {
        int offsetValue = 0;
        if (NumberFormatValidator.isValidDecimal((String)this.offset)) {
            offsetValue = NumberFormatValidator.getIntFromStringDecimal((String)this.offset);
        } else if (NumberFormatValidator.isValidXmlHexFormat((String)this.offset)) {
            offsetValue = NumberFormatValidator.getDecimalIntegerFromXmlHex((String)this.offset);
        }
        return offsetValue;
    }

    public long getVersionValue() {
        long versionVal = 0L;
        if (NumberFormatValidator.isValidXmlHexFormat((String)this.getInitValue())) {
            versionVal = NumberFormatValidator.getDecimalLongFromXmlHex((String)this.getInitValue());
        } else if (NumberFormatValidator.isValidDecimal((String)this.getInitValue())) {
            versionVal = NumberFormatValidator.getLongFromStringDecimal((String)this.getInitValue());
        }
        return versionVal;
    }

    public byte[] getBufferToWrite() {
        ByteBuffer bufferToWrite = ByteBuffer.allocate(this.getSizeValue());
        ByteBuffer versionBuffer = ByteBuffer.allocate(8).putLong(this.getVersionValue());
        if (this.getSizeValue() > 8) {
            int i = 0;
            while (i < 8) {
                bufferToWrite.put(this.getSizeValue() - 1 - i, versionBuffer.get(7 - i));
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.getSizeValue()) {
                bufferToWrite.put(this.getSizeValue() - 1 - i, versionBuffer.get(7 - i));
                ++i;
            }
        }
        return bufferToWrite.array();
    }
}

