/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.bootimage.utils;

import com.nxp.swtools.bootimage.binders.ArrayDataBinder;
import com.nxp.swtools.bootimage.settings.ABaseComponentSetting;
import com.nxp.swtools.bootimage.settings.ArraySetting;
import com.nxp.swtools.bootimage.settings.ArrayStructure;
import com.nxp.swtools.bootimage.settings.BoolSetting;
import com.nxp.swtools.bootimage.settings.EnumSetting;
import com.nxp.swtools.bootimage.settings.InputFileSetting;
import com.nxp.swtools.bootimage.settings.IntegerSetting;
import com.nxp.swtools.bootimage.settings.StructSetting;
import com.nxp.swtools.bootimage.settings.TextSetting;
import com.nxp.swtools.bootimage.utils.BootUtils;
import com.nxp.swtools.common.utils.number.NumberFormatValidator;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.provider.configuration.storage.bootimage.StorageBootArraySetting;
import com.nxp.swtools.provider.configuration.storage.bootimage.StorageBootScalarSetting;
import com.nxp.swtools.provider.configuration.storage.bootimage.StorageBootStructSetting;

public class BootStorageUtils {
    public static StorageBootStructSetting createStorageStructSetting(StructSetting structSetting) {
        StorageBootStructSetting stStructSetting = new StorageBootStructSetting(structSetting.getId());
        for (BoolSetting boolSetting : structSetting.getBoolSettingList()) {
            stStructSetting.getScalarSettings().add(BootStorageUtils.createStorageScalarSetting(boolSetting));
        }
        for (EnumSetting enumSetting : structSetting.getEnumSettingList()) {
            stStructSetting.getScalarSettings().add(BootStorageUtils.createStorageScalarSetting(enumSetting));
        }
        for (IntegerSetting integerSetting : structSetting.getIntegerSettingList()) {
            if (integerSetting.hasValueExpression()) continue;
            stStructSetting.getScalarSettings().add(BootStorageUtils.createStorageScalarSetting(integerSetting));
        }
        for (InputFileSetting inputFile : structSetting.getInputFiles()) {
            stStructSetting.getScalarSettings().add(BootStorageUtils.createStorageScalarSetting(inputFile));
        }
        for (TextSetting textSetting : structSetting.getTextSettingList()) {
            stStructSetting.getScalarSettings().add(BootStorageUtils.createStorageScalarSetting(textSetting));
        }
        for (ArraySetting arraySetting : structSetting.getArraySettingList()) {
            stStructSetting.getArraySettings().add(BootStorageUtils.createStorageArraySetting(arraySetting));
        }
        for (StructSetting childStructSetting : structSetting.getStructSettingList()) {
            stStructSetting.getChildStructSettings().add(BootStorageUtils.createStorageStructSetting(childStructSetting));
        }
        return stStructSetting;
    }

    public static StorageBootScalarSetting createStorageScalarSetting(ABaseComponentSetting setting) {
        StorageBootScalarSetting stScalarSetting = new StorageBootScalarSetting(setting.getId());
        if (setting instanceof BoolSetting) {
            stScalarSetting.setValue(((BoolSetting)setting).getCurrentSelection() ? "true" : "false");
        } else if (setting instanceof EnumSetting) {
            stScalarSetting.setValue(((EnumSetting)setting).getCurrentSelection());
        } else if (setting instanceof IntegerSetting) {
            stScalarSetting.setValue(((IntegerSetting)setting).getValueToWriteFormatted());
        } else if (setting instanceof InputFileSetting) {
            InputFileSetting inputFileSetting = (InputFileSetting)setting;
            stScalarSetting.setValue(inputFileSetting.getCurrentValue());
            if (inputFileSetting.getSignImage() != null) {
                stScalarSetting.setSignImage(inputFileSetting.getSignImageProperty().get() ? "true" : "false");
            }
        } else if (setting instanceof TextSetting) {
            stScalarSetting.setValue(((TextSetting)setting).getMessage());
        }
        return stScalarSetting;
    }

    public static void createStorageScalarSetting(ABaseComponentSetting setting, StorageBootStructSetting stParentStruct) {
        StorageBootScalarSetting stScalarSetting = stParentStruct.getScalarSettingByName(setting.getId());
        if (stScalarSetting == null) {
            stParentStruct.getScalarSettings().add(BootStorageUtils.createStorageScalarSetting(setting));
        }
    }

    public static StorageBootArraySetting createStorageArraySetting(ArraySetting arraySetting) {
        StorageBootArraySetting stArraySetting = new StorageBootArraySetting(arraySetting.getId());
        for (ArrayDataBinder arrayItem : arraySetting.getTableData()) {
            StorageBootStructSetting arrayStruct = BootStorageUtils.createNewStorageArrayStruct(arrayItem);
            stArraySetting.getStructSettings().add(arrayStruct);
        }
        return stArraySetting;
    }

    public static void createStorageArraySetting(ArraySetting arraySetting, StorageBootStructSetting stParentStruct) {
        StorageBootArraySetting stArraySetting = stParentStruct.getArraySettingByName(arraySetting.getId());
        if (stArraySetting == null) {
            stParentStruct.getArraySettings().add(BootStorageUtils.createStorageArraySetting(arraySetting));
        }
    }

    public static StorageBootStructSetting createNewStorageArrayStruct(ArrayDataBinder arrayDataBinder) {
        StorageBootStructSetting stStructSetting = new StorageBootStructSetting(Integer.toString(arrayDataBinder.getIndex()));
        for (BoolSetting boolSetting : arrayDataBinder.getBoolSettings()) {
            stStructSetting.getScalarSettings().add(BootStorageUtils.createStorageScalarSetting(boolSetting));
        }
        for (EnumSetting enumSetting : arrayDataBinder.getEnumSettings()) {
            stStructSetting.getScalarSettings().add(BootStorageUtils.createStorageScalarSetting(enumSetting));
        }
        for (IntegerSetting integerSetting : arrayDataBinder.getIntegerSettings()) {
            stStructSetting.getScalarSettings().add(BootStorageUtils.createStorageScalarSetting(integerSetting));
        }
        for (TextSetting textSetting : arrayDataBinder.getTextSettings()) {
            stStructSetting.getScalarSettings().add(BootStorageUtils.createStorageScalarSetting(textSetting));
        }
        return stStructSetting;
    }

    public static void updateStorageStructSetting(StorageBootStructSetting stStructSetting, StructSetting structSetting) {
        for (BoolSetting boolSetting : structSetting.getBoolSettingList()) {
            BootStorageUtils.updateStorageScalarSetting(boolSetting, stStructSetting);
        }
        for (EnumSetting enumSetting : structSetting.getEnumSettingList()) {
            BootStorageUtils.updateStorageScalarSetting(enumSetting, stStructSetting);
        }
        for (IntegerSetting integerSetting : structSetting.getIntegerSettingList()) {
            BootStorageUtils.updateStorageScalarSetting(integerSetting, stStructSetting);
        }
        for (InputFileSetting inputFile : structSetting.getInputFiles()) {
            BootStorageUtils.updateStorageScalarSetting(inputFile, stStructSetting);
        }
        for (TextSetting textSetting : structSetting.getTextSettingList()) {
            BootStorageUtils.updateStorageScalarSetting(textSetting, stStructSetting);
        }
        for (ArraySetting arraySetting : structSetting.getArraySettingList()) {
            BootStorageUtils.updateStorageArraySetting(arraySetting, stStructSetting);
        }
    }

    public static boolean updateStorageScalarSetting(ABaseComponentSetting scalarSetting, StorageBootStructSetting stParentStruct) {
        StorageBootScalarSetting stScalarSetting = stParentStruct.getScalarSettingByName(scalarSetting.getId());
        if (stScalarSetting != null) {
            String value = null;
            if (scalarSetting instanceof BoolSetting) {
                value = ((BoolSetting)scalarSetting).getCurrentSelection() ? "true" : "false";
            } else if (scalarSetting instanceof EnumSetting) {
                value = ((EnumSetting)scalarSetting).getCurrentSelection();
            } else if (scalarSetting instanceof IntegerSetting) {
                value = ((IntegerSetting)scalarSetting).getValueToWriteFormatted();
            } else if (scalarSetting instanceof InputFileSetting) {
                value = ((InputFileSetting)scalarSetting).getCurrentValue();
            } else if (scalarSetting instanceof TextSetting) {
                value = ((TextSetting)scalarSetting).getMessage();
            }
            if (value != null && !stScalarSetting.getValue().equals(value)) {
                stScalarSetting.setValue(value);
                return true;
            }
        }
        return false;
    }

    public static void updateStorageArraySetting(ArraySetting arraySetting, StorageBootStructSetting stParentStruct) {
        block4: {
            StorageBootArraySetting stArraySetting = stParentStruct.getArraySettingByName(arraySetting.getId());
            if (stArraySetting == null) break block4;
            if (stArraySetting.getStructSettings().size() == arraySetting.getTableData().size()) {
                for (ArrayDataBinder arrayDataBinder : arraySetting.getTableData()) {
                    BootStorageUtils.updateStorageArrayItem(arrayDataBinder, stArraySetting);
                }
            } else {
                stArraySetting.getStructSettings().clear();
                for (ArrayDataBinder arrayDataBinder : arraySetting.getTableData()) {
                    StorageBootStructSetting stArrayItem = BootStorageUtils.createNewStorageArrayStruct(arrayDataBinder);
                    stArraySetting.getStructSettings().add(stArrayItem);
                }
            }
        }
    }

    public static boolean updateStorageArrayItem(ArrayDataBinder arrayDataBinder, StorageBootArraySetting stArraySetting) {
        StorageBootStructSetting stArrayStruct = stArraySetting.getStructSettingByName(Integer.toString(arrayDataBinder.getIndex()));
        boolean updated = false;
        if (stArrayStruct != null) {
            for (BoolSetting boolSetting : arrayDataBinder.getBoolSettings()) {
                updated |= BootStorageUtils.updateStorageScalarSetting(boolSetting, stArrayStruct);
            }
            for (EnumSetting enumSetting : arrayDataBinder.getEnumSettings()) {
                updated |= BootStorageUtils.updateStorageScalarSetting(enumSetting, stArrayStruct);
            }
            for (IntegerSetting integerSetting : arrayDataBinder.getIntegerSettings()) {
                if (integerSetting.hasValueExpression()) continue;
                updated |= BootStorageUtils.updateStorageScalarSetting(integerSetting, stArrayStruct);
            }
            for (TextSetting textSetting : arrayDataBinder.getTextSettings()) {
                updated |= BootStorageUtils.updateStorageScalarSetting(textSetting, stArrayStruct);
            }
        }
        return updated;
    }

    public static void updateStructSettingFromStorage(StructSetting structSetting, StorageBootStructSetting stStructSetting) {
        for (BoolSetting boolSetting : structSetting.getBoolSettingList()) {
            BootStorageUtils.updateScalarSettingFromStorage(boolSetting, stStructSetting);
        }
        for (EnumSetting enumSetting : structSetting.getEnumSettingList()) {
            BootStorageUtils.updateScalarSettingFromStorage(enumSetting, stStructSetting);
        }
        for (IntegerSetting integerSetting : structSetting.getIntegerSettingList()) {
            if (integerSetting.hasValueExpression()) continue;
            BootStorageUtils.updateScalarSettingFromStorage(integerSetting, stStructSetting);
        }
        for (InputFileSetting inputFile : structSetting.getInputFiles()) {
            BootStorageUtils.updateScalarSettingFromStorage(inputFile, stStructSetting);
        }
        for (TextSetting textSetting : structSetting.getTextSettingList()) {
            BootStorageUtils.updateScalarSettingFromStorage(textSetting, stStructSetting);
        }
        for (ArraySetting arraySetting : structSetting.getArraySettingList()) {
            BootStorageUtils.updateArraySettingFromStorage(arraySetting, stStructSetting);
        }
        for (StructSetting childStructSetting : structSetting.getStructSettingList()) {
            StorageBootStructSetting parentStorageStructSetting = stStructSetting.getChildStructSettingByName(structSetting.getId());
            if (parentStorageStructSetting != null) {
                BootStorageUtils.updateStructSettingFromStorage(childStructSetting, parentStorageStructSetting);
                continue;
            }
            BootStorageUtils.updateStructSettingFromStorage(childStructSetting, stStructSetting);
        }
    }

    public static void updateScalarSettingFromStorage(ABaseComponentSetting scalarSetting, StorageBootStructSetting stParentStruct) {
        StorageBootScalarSetting stScalarSetting = stParentStruct.getScalarSettingByName(scalarSetting.getId());
        if (stScalarSetting != null) {
            if (scalarSetting instanceof BoolSetting) {
                BoolSetting boolSetting = (BoolSetting)scalarSetting;
                boolSetting.setCurrentSelection("true".equalsIgnoreCase(stScalarSetting.getValue()));
                boolSetting.updateValueToWrite("true".equalsIgnoreCase(stScalarSetting.getValue()));
            } else if (scalarSetting instanceof EnumSetting) {
                EnumSetting enumSetting = (EnumSetting)scalarSetting;
                String label = stScalarSetting.getValue();
                if (enumSetting.getItemByLabel(label) != null) {
                    enumSetting.updateValueToWrite(label);
                    enumSetting.setCurrentSelection(label);
                } else {
                    EnumSetting.ItemSetting firstItem = (EnumSetting.ItemSetting)enumSetting.getItems().stream().findFirst().get();
                    enumSetting.updateValueToWrite(String.valueOf(firstItem.getValueToWrite()));
                    enumSetting.setCurrentSelection(firstItem.getLabel());
                }
            } else if (scalarSetting instanceof IntegerSetting) {
                IntegerSetting integerSetting = (IntegerSetting)scalarSetting;
                integerSetting.setValueToWrite(NumberFormatValidator.getLongValueFromString((String)stScalarSetting.getValue()));
            } else if (scalarSetting instanceof InputFileSetting) {
                InputFileSetting inputFile = (InputFileSetting)scalarSetting;
                inputFile.setCurrentValue(stScalarSetting.getValue());
                String stSignImage = stScalarSetting.getSignImage();
                if (stSignImage != null) {
                    inputFile.setSignImage(stSignImage.equals("true"));
                }
            } else if (scalarSetting instanceof TextSetting) {
                TextSetting textSetting = (TextSetting)scalarSetting;
                textSetting.setMessage(stScalarSetting.getValue());
            }
        }
    }

    public static void updateArraySettingFromStorage(ArraySetting arraySetting, StorageBootStructSetting stParentStruct) {
        StorageBootArraySetting stArraySetting = stParentStruct.getArraySettingByName(arraySetting.getId());
        if (stArraySetting != null) {
            arraySetting.getTableData().clear();
            for (StorageBootStructSetting stStructSetting : stArraySetting.getStructSettings()) {
                int index = Integer.decode(stStructSetting.getName());
                ArrayStructure arrayStruct = arraySetting.getArrayStructure();
                if (arrayStruct == null) continue;
                ArrayDataBinder dataBinder = BootUtils.createNewArrayDataBinder(index, arraySetting);
                BootStorageUtils.updateArrayItemFromStorage(dataBinder, stArraySetting);
                arraySetting.getTableData().add((Object)dataBinder);
            }
        }
    }

    public static void updateArrayItemFromStorage(ArrayDataBinder arrayDataBinder, StorageBootArraySetting stArraySetting) {
        StorageBootStructSetting stArrayStruct = stArraySetting.getStructSettingByName(Integer.toString(arrayDataBinder.getIndex()));
        if (stArrayStruct != null) {
            for (BoolSetting boolSetting : arrayDataBinder.getBoolSettings()) {
                BootStorageUtils.updateScalarSettingFromStorage(boolSetting, stArrayStruct);
            }
            for (EnumSetting enumSetting : arrayDataBinder.getEnumSettings()) {
                BootStorageUtils.updateScalarSettingFromStorage(enumSetting, stArrayStruct);
            }
            for (IntegerSetting integerSetting : arrayDataBinder.getIntegerSettings()) {
                BootStorageUtils.updateScalarSettingFromStorage(integerSetting, stArrayStruct);
            }
            for (TextSetting textSetting : arrayDataBinder.getTextSettings()) {
                BootStorageUtils.updateScalarSettingFromStorage(textSetting, stArrayStruct);
            }
        }
    }

    public static void resetStorageStructSettingToDefaults(StorageBootStructSetting stStructSetting, StructSetting structSetting) {
        for (BoolSetting boolSetting : structSetting.getBoolSettingList()) {
            BootStorageUtils.resetStorageScalarSettingToDefault(boolSetting, stStructSetting);
        }
        for (EnumSetting enumSetting : structSetting.getEnumSettingList()) {
            BootStorageUtils.resetStorageScalarSettingToDefault(enumSetting, stStructSetting);
        }
        for (IntegerSetting integerSetting : structSetting.getIntegerSettingList()) {
            if (integerSetting.hasValueExpression()) continue;
            BootStorageUtils.resetStorageScalarSettingToDefault(integerSetting, stStructSetting);
        }
        for (InputFileSetting inputFile : structSetting.getInputFiles()) {
            BootStorageUtils.resetStorageScalarSettingToDefault(inputFile, stStructSetting);
        }
        for (TextSetting textSetting : structSetting.getTextSettingList()) {
            BootStorageUtils.resetStorageScalarSettingToDefault(textSetting, stStructSetting);
        }
        for (ArraySetting arraySetting : structSetting.getArraySettingList()) {
            BootStorageUtils.resetStorageArraySettingToDefault(arraySetting, stStructSetting);
        }
        for (StructSetting childStructSetting : structSetting.getStructSettingList()) {
            StorageBootStructSetting parentStorageStructSetting = stStructSetting.getChildStructSettingByName(structSetting.getId());
            if (parentStorageStructSetting != null) {
                BootStorageUtils.resetStorageStructSettingToDefaults(parentStorageStructSetting, childStructSetting);
                continue;
            }
            BootStorageUtils.resetStorageStructSettingToDefaults(stStructSetting, childStructSetting);
        }
    }

    public static void resetStorageScalarSettingToDefault(ABaseComponentSetting scalarSetting, StorageBootStructSetting stParentStruct) {
        StorageBootScalarSetting stScalarSetting = stParentStruct.getScalarSettingByName(scalarSetting.getId());
        if (stScalarSetting != null) {
            if (scalarSetting instanceof EnumSetting) {
                EnumSetting enumSetting = (EnumSetting)scalarSetting;
                EnumSetting.ItemSetting defaultSelectedItem = enumSetting.getItemById(enumSetting.getInitValue());
                stScalarSetting.setValue(defaultSelectedItem != null ? defaultSelectedItem.getLabel() : enumSetting.getInitValue());
            } else if (!scalarSetting.getInitValue().equals("")) {
                if (NumberFormatValidator.isValidXmlHexFormat((String)scalarSetting.getInitValue())) {
                    stScalarSetting.setValue(UtilsText.safeString((String)("0x" + Long.toHexString(NumberFormatValidator.getDecimalLongFromXmlHex((String)scalarSetting.getInitValue())))));
                } else if (NumberFormatValidator.isValidDecimal((String)scalarSetting.getInitValue())) {
                    stScalarSetting.setValue(String.valueOf(NumberFormatValidator.getLongFromStringDecimal((String)scalarSetting.getInitValue())));
                } else {
                    stScalarSetting.setValue(scalarSetting.getInitValue());
                }
            } else {
                stScalarSetting.setValue(scalarSetting.getInitValue());
            }
        }
    }

    public static void resetStorageArraySettingToDefault(ArraySetting arraySetting, StorageBootStructSetting stParentStruct) {
        StorageBootArraySetting stArraySetting = stParentStruct.getArraySettingByName(arraySetting.getId());
        if (stArraySetting != null) {
            stArraySetting.getStructSettings().clear();
            for (ArrayDataBinder dataView : arraySetting.getTableData()) {
                StorageBootStructSetting stStructSetting = BootStorageUtils.createNewStorageArrayStruct(dataView);
                stArraySetting.getStructSettings().add(stStructSetting);
            }
        }
    }
}

