/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.s32debugger.group.launch;

import com.nxp.s32ds.debug.ide.s32debugger.group.internal.launch.S32DebuggerGroupLaunchMessages;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;

public class S32DebuggerSingleLaunchElement {
    int index;
    boolean launchEnabled;
    String launchName;
    ILaunchConfiguration lcData;
    String launchMode;
    ActionAfterLaunch actionAfterLaunch;
    Object launchActionData;

    public static String actionAfterLaunchToString(ActionAfterLaunch action) {
        switch (action) {
            case ACTION_NONE: {
                return S32DebuggerGroupLaunchMessages.S32DebuggerGroupLaunch_action_none;
            }
            case ACTION_WAIT_FOR_STOP_ON_BP: {
                return S32DebuggerGroupLaunchMessages.S32DebuggerGroupLaunch_action_wait_for_stop_on_bp;
            }
            case ACTION_WAIT_FOR_TERMINATION: {
                return S32DebuggerGroupLaunchMessages.S32DebuggerGroupLaunch_action_wait_for_termination;
            }
            case ACTION_DELAY: {
                return S32DebuggerGroupLaunchMessages.S32DebuggerGroupLaunch_action_delay;
            }
        }
        assert (false) : "Not created action is selected!";
        return S32DebuggerGroupLaunchMessages.S32DebuggerGroupLaunch_action_none;
    }

    public static ActionAfterLaunch stringToActionAfterLaunch(String string) {
        if (string.equals(S32DebuggerGroupLaunchMessages.S32DebuggerGroupLaunch_action_none)) {
            return ActionAfterLaunch.ACTION_NONE;
        }
        if (string.equals(S32DebuggerGroupLaunchMessages.S32DebuggerGroupLaunch_action_wait_for_termination)) {
            return ActionAfterLaunch.ACTION_WAIT_FOR_TERMINATION;
        }
        if (string.equals(S32DebuggerGroupLaunchMessages.S32DebuggerGroupLaunch_action_wait_for_stop_on_bp)) {
            return ActionAfterLaunch.ACTION_WAIT_FOR_STOP_ON_BP;
        }
        if (string.equals(S32DebuggerGroupLaunchMessages.S32DebuggerGroupLaunch_action_delay)) {
            return ActionAfterLaunch.ACTION_DELAY;
        }
        assert (false) : "Not created action is selected!";
        return ActionAfterLaunch.ACTION_NONE;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public boolean isLaunchEnabled() {
        return this.launchEnabled;
    }

    public void setLaunchEnabled(boolean launchEnabled) {
        this.launchEnabled = launchEnabled;
    }

    public String getLaunchName() {
        return this.launchName;
    }

    public void setLaunchName(String launchName) {
        this.launchName = launchName;
    }

    public ILaunchConfiguration getLCData() {
        return this.lcData;
    }

    public void setLCData(ILaunchConfiguration data) {
        this.lcData = data;
    }

    public String getLaunchMode() {
        return this.launchMode;
    }

    public void setLaunchMode(String launchMode) {
        this.launchMode = launchMode;
    }

    public ActionAfterLaunch getActionAfterLaunch() {
        return this.actionAfterLaunch;
    }

    public void setActionAfterLaunch(ActionAfterLaunch actionAfterLaunch) {
        this.actionAfterLaunch = actionAfterLaunch;
    }

    public Object getLaunchActionData() {
        return this.launchActionData;
    }

    public void setLaunchActionData(Object launchActionData) {
        this.launchActionData = launchActionData;
    }

    public static List<S32DebuggerSingleLaunchElement> createLaunchElements(ILaunchConfiguration configuration, List<S32DebuggerSingleLaunchElement> elements) {
        try {
            Map attributes = configuration.getAttributes();
            for (String attribute : attributes.keySet()) {
                try {
                    ActionAfterLaunch action;
                    if (!attribute.startsWith("com.nxp.s32ds.debug.ide.s32debugger.groupLaunch")) continue;
                    String prop = attribute.substring("com.nxp.s32ds.debug.ide.s32debugger.groupLaunch".length() + 1);
                    int dotIndex = prop.indexOf(46);
                    String number = prop.substring(0, dotIndex);
                    int index = Integer.parseInt(number);
                    String name = prop.substring(dotIndex + 1);
                    if (!name.equals("name")) continue;
                    S32DebuggerSingleLaunchElement element = new S32DebuggerSingleLaunchElement();
                    element.index = index;
                    element.launchName = (String)attributes.get(attribute);
                    Integer postActionData = null;
                    String actionStr = (String)attributes.get(S32DebuggerSingleLaunchElement.getProperty(index, "action"));
                    try {
                        action = ActionAfterLaunch.valueOf(actionStr);
                    }
                    catch (Exception exception) {
                        action = ActionAfterLaunch.ACTION_NONE;
                    }
                    if (action == ActionAfterLaunch.ACTION_DELAY) {
                        try {
                            postActionData = Integer.parseInt((String)attributes.get(S32DebuggerSingleLaunchElement.getProperty(index, "actionParam")));
                        }
                        catch (NumberFormatException ex) {
                            DebugPlugin.logDebugMessage((String)ex.getMessage());
                        }
                    }
                    element.actionAfterLaunch = action;
                    element.launchActionData = postActionData;
                    element.launchMode = (String)attributes.get(S32DebuggerSingleLaunchElement.getProperty(index, "mode"));
                    element.launchEnabled = Boolean.parseBoolean((String)attributes.get(S32DebuggerSingleLaunchElement.getProperty(index, "enabled")));
                    try {
                        element.lcData = S32DebuggerSingleLaunchElement.findLaunchConfiguration(element.launchName);
                    }
                    catch (Exception exception) {
                        element.lcData = null;
                    }
                    while (index >= elements.size()) {
                        elements.add(null);
                    }
                    elements.set(index, element);
                }
                catch (Exception ex) {
                    DebugPlugin.logDebugMessage((String)ex.getMessage());
                }
            }
        }
        catch (CoreException ex) {
            DebugPlugin.log((IStatus)ex.getStatus());
        }
        return elements;
    }

    public static void storeLaunchElements(ILaunchConfigurationWorkingCopy configuration, List<S32DebuggerSingleLaunchElement> elements) {
        int i = 0;
        S32DebuggerSingleLaunchElement.removeLaunchElements(configuration);
        for (S32DebuggerSingleLaunchElement element : elements) {
            if (element == null) continue;
            configuration.setAttribute(S32DebuggerSingleLaunchElement.getProperty(i, "name"), element.launchName);
            configuration.setAttribute(S32DebuggerSingleLaunchElement.getProperty(i, "action"), element.actionAfterLaunch.toString());
            configuration.setAttribute(S32DebuggerSingleLaunchElement.getProperty(i, "actionParam"), element.launchActionData != null ? element.launchActionData.toString() : null);
            configuration.setAttribute(S32DebuggerSingleLaunchElement.getProperty(i, "mode"), element.launchMode);
            configuration.setAttribute(S32DebuggerSingleLaunchElement.getProperty(i, "enabled"), String.valueOf(element.launchEnabled));
            ++i;
        }
    }

    private static String getProperty(int index, String string) {
        return "com.nxp.s32ds.debug.ide.s32debugger.groupLaunch." + index + "." + string;
    }

    private static void removeLaunchElements(ILaunchConfigurationWorkingCopy configuration) {
        try {
            Map attributes = configuration.getAttributes();
            for (String attribute : attributes.keySet()) {
                try {
                    if (!attribute.startsWith("com.nxp.s32ds.debug.ide.s32debugger.groupLaunch")) continue;
                    configuration.removeAttribute(attribute);
                }
                catch (Exception ex) {
                    DebugPlugin.logDebugMessage((String)ex.getMessage());
                }
            }
        }
        catch (CoreException ex) {
            DebugPlugin.log((IStatus)ex.getStatus());
        }
    }

    private static ILaunchConfiguration findLaunchConfiguration(String name) throws CoreException {
        ILaunchConfiguration[] launchConfigurations = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations();
        int i = 0;
        while (i < launchConfigurations.length) {
            ILaunchConfiguration lConf = launchConfigurations[i];
            if (lConf.getName().equals(name)) {
                return lConf;
            }
            ++i;
        }
        return null;
    }

    public static enum ActionAfterLaunch {
        ACTION_NONE,
        ACTION_WAIT_FOR_STOP_ON_BP,
        ACTION_WAIT_FOR_TERMINATION,
        ACTION_DELAY;

    }
}

