/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.arm.mbs.common;

import com.freescale.s32ds.cross.core.model.IParameterHandler;
import com.freescale.s32ds.cross.core.model.context.AbstractContext;
import com.freescale.s32ds.cross.core.model.context.CProjectContext;
import com.freescale.s32ds.cross.core.model.context.CProjectMasterContext;
import com.freescale.s32ds.cross.core.model.context.ChangeResult;
import com.freescale.s32ds.cross.core.model.context.ContextChange;
import com.freescale.s32ds.cross.core.model.context.ProcessorContext;
import com.freescale.s32ds.cross.core.model.context.ProjectContext;
import com.freescale.s32ds.cross.core.model.data.DataSet;
import com.freescale.s32ds.cross.core.model.registry.ModelRegistry;
import java.util.ArrayList;
import java.util.List;

public class IoHostedParameterHandler
implements IParameterHandler {
    private static final String HOSTED_IO = "hosted";
    private static final String NOIO_HOSTED_SET = "noio_hosted";
    private static final String NOIO_SET = "only_noio";
    private static final String ISYSTEM_DEBUGGER = "isystem";
    private static final String WARNING_MSG = "Debugger Console option is not compatible with selected debugger";
    private boolean isWarningSet = false;

    public boolean isEnabled(String tag, AbstractContext context) {
        return false;
    }

    public ChangeResult onInit(String tag, Object newValue, AbstractContext context) {
        return null;
    }

    public ChangeResult onEdit(String tag, Object newValue, AbstractContext context) {
        DataSet dataSet;
        this.isWarningSet = false;
        if (!(context instanceof CProjectMasterContext) || newValue == null) {
            return null;
        }
        CProjectMasterContext projectContext = (CProjectMasterContext)context;
        ModelRegistry registry = context.getRegistry();
        ArrayList<ContextChange> cChange = new ArrayList<ContextChange>();
        ContextChange contextChange = new ContextChange(context, tag);
        String currentDebugger = projectContext.getStringValue("debugger");
        List<String> ioOptions = this.getOptionsByGlobalContext(projectContext, "io");
        String currentIO = projectContext.getStringValue("io");
        DataSet dataSetIO = projectContext.getDataSet("io");
        if ("io".equals(tag)) {
            if (ISYSTEM_DEBUGGER.equals(currentDebugger)) {
                if (dataSetIO.getValues().contains(HOSTED_IO)) {
                    dataSet = registry.getDataSet("ioSet", NOIO_SET);
                    cChange.addAll(this.changeGlobalContext(projectContext, dataSet, tag));
                }
            } else if (!dataSetIO.getValues().contains(HOSTED_IO)) {
                dataSet = registry.getDataSet("ioSet", NOIO_HOSTED_SET);
                cChange.addAll(this.changeGlobalContext(projectContext, dataSet, tag));
            }
        }
        if ("debugger".equals(tag)) {
            if (newValue instanceof String) {
                String debuggerValue = (String)newValue;
                DataSet dbgDataSet = registry.getDataSet("debuggerSet", "debuggerSet");
                cChange.addAll(this.changeGlobalContext(projectContext, dbgDataSet, "debugger", debuggerValue));
            }
            if (ISYSTEM_DEBUGGER.equals(newValue)) {
                if (dataSetIO.getValues().contains(HOSTED_IO)) {
                    if (ioOptions.contains(HOSTED_IO)) {
                        this.isWarningSet = true;
                    }
                    dataSet = registry.getDataSet("ioSet", NOIO_SET);
                    contextChange.addDataSet(dataSet);
                }
            } else if (!dataSetIO.getValues().contains(HOSTED_IO)) {
                contextChange.addValue("io", (Object)currentIO);
                dataSet = registry.getDataSet("ioSet", NOIO_HOSTED_SET);
                contextChange.addDataSet(dataSet);
                cChange.addAll(this.changeGlobalContext(projectContext, dataSet, tag));
            }
        }
        cChange.add(contextChange);
        ChangeResult result = new ChangeResult(cChange);
        if (this.isWarningSet) {
            result.setWarningMessage(WARNING_MSG);
        }
        return result;
    }

    public Object parseValue(String tag, String value, AbstractContext context) {
        return null;
    }

    public List<ContextChange> changeGlobalContext(CProjectMasterContext projectContext, DataSet dataSet, String contextTag) {
        ProcessorContext processorContext = projectContext.getProcessorContext();
        List projectContexts = processorContext.getProjectContexts();
        ArrayList<ContextChange> changes = new ArrayList<ContextChange>();
        for (CProjectContext pcontext : projectContexts) {
            projectContext.addRelatedContext((ProjectContext)pcontext);
            ContextChange contextLocalChange = new ContextChange((AbstractContext)pcontext, contextTag);
            contextLocalChange.addDataSet(dataSet);
            changes.add(contextLocalChange);
        }
        return changes;
    }

    public List<ContextChange> changeGlobalContext(CProjectMasterContext projectContext, DataSet dataSet, String tag, String value) {
        ProcessorContext processorContext = projectContext.getProcessorContext();
        List projectContexts = processorContext.getProjectContexts();
        ArrayList<ContextChange> changes = new ArrayList<ContextChange>();
        for (CProjectContext pcontext : projectContexts) {
            projectContext.addRelatedContext((ProjectContext)pcontext);
            ContextChange contextLocalChange = new ContextChange((AbstractContext)pcontext, tag);
            contextLocalChange.addDataSet(dataSet);
            contextLocalChange.addValue(tag, (Object)value);
            changes.add(contextLocalChange);
        }
        return changes;
    }

    public List<String> getOptionsByGlobalContext(CProjectMasterContext projectContext, String tag) {
        ProcessorContext processorContext = projectContext.getProcessorContext();
        List projectContexts = processorContext.getProjectContexts();
        ArrayList<String> result = new ArrayList<String>();
        for (CProjectContext pcontext : projectContexts) {
            result.add(pcontext.getStringValue(tag));
        }
        return result;
    }
}

