/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.dcd.model.settings;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.number.NumberFormatter;
import com.nxp.swtools.dcd.model.settings.ABaseAttributes;
import com.nxp.swtools.dcd.model.settings.Action;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.core.Validate;

@Root(name="parameters", strict=false)
public class HeaderParameters
extends ABaseAttributes {
    @Element(name="target_width")
    private TargetWidthSetting targetWidth;
    @Element(name="action")
    private CommandActionSetting action;

    protected HeaderParameters() {
        this(0, 0, new TargetWidthSetting(), new CommandActionSetting());
    }

    public HeaderParameters(int size, int startPosition, TargetWidthSetting targetWidth, CommandActionSetting action) {
        super(size, startPosition);
        this.targetWidth = targetWidth;
        this.action = action;
    }

    public TargetWidthSetting getTargetWidthSetting() {
        return this.targetWidth;
    }

    public void setTargetWidthSetting(TargetWidthSetting targetWidth) {
        this.targetWidth = targetWidth;
    }

    public CommandActionSetting getActionSetting() {
        return this.action;
    }

    public void setActionSetting(CommandActionSetting action) {
        this.action = action;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.targetWidth);
        result = 31 * result + Objects.hashCode(this.action);
        return result;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HeaderParameters other = (HeaderParameters)obj;
        return Objects.equals(this.targetWidth, other.targetWidth) && Objects.equals(this.action, other.action);
    }

    @Root(name="action", strict=false)
    public static class CommandActionSetting
    extends ParameterSetting {
        @ElementList(inline=true)
        private List<Action> items = new ArrayList<Action>();

        protected CommandActionSetting() {
            this("", "", new ArrayList<Action>());
        }

        public CommandActionSetting(String offset, String defaultItem, List<Action> items) {
            super(offset, defaultItem);
            this.items = new ArrayList<Action>(items);
        }

        public List<Action> getItems() {
            return this.items;
        }

        public void setItems(List<Action> items) {
            this.items = items;
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + Objects.hashCode(this.items);
            return result;
        }

        @Override
        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CommandActionSetting other = (CommandActionSetting)obj;
            return Objects.equals(this.items, other.items);
        }
    }

    @Root(name="item", strict=false)
    public static class ItemSetting {
        private static final Logger LOGGER = LogManager.getLogger(ItemSetting.class);
        @Attribute(name="id")
        private String id;
        @Attribute(name="value")
        private String value;
        @Attribute(name="name")
        private String name;
        int valueInt;

        protected ItemSetting() {
            this("", "", "");
        }

        public ItemSetting copy() {
            return new ItemSetting(this.id, this.value, this.name, this.valueInt);
        }

        public ItemSetting(String id, String value, String name) {
            this.id = id;
            this.value = value;
            this.name = name;
        }

        public ItemSetting(String id, String value, String name, int valueInt) {
            this.id = id;
            this.value = value;
            this.name = name;
            this.valueInt = valueInt;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getValueInt() {
            return this.valueInt;
        }

        @Validate
        public void validate() {
            try {
                BigInteger itemValue = NumberFormatter.getBigIntegerWithSuffix((String)this.value);
                this.valueInt = itemValue.intValue();
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.severe(MessageFormat.format("Invalid value {0}", this.value));
            }
        }

        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + Objects.hashCode(this.id);
            result = 31 * result + Objects.hashCode(this.value);
            result = 31 * result + Objects.hashCode(this.name);
            return result;
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ItemSetting other = (ItemSetting)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.value, other.value) && Objects.equals(this.name, other.name);
        }

        public String toString() {
            return this.name;
        }
    }

    private static class ParameterSetting {
        private static final Logger LOGGER = LogManager.getLogger(ParameterSetting.class);
        @Attribute(name="offset")
        private String offset;
        @Attribute(name="default")
        private String defaultItem;
        private int offsetInt;

        public ParameterSetting(String offset, String defaultItem) {
            this.offset = offset;
            this.defaultItem = defaultItem;
        }

        public String getOffset() {
            return this.offset;
        }

        public void setOffset(String offset) {
            this.offset = offset;
        }

        public String getDefaultItem() {
            return this.defaultItem;
        }

        public void setDefaultItem(String defaultItem) {
            this.defaultItem = defaultItem;
        }

        public int getOffsetInt() {
            return this.offsetInt;
        }

        @Validate
        public void validate() {
            try {
                BigInteger itemValue = NumberFormatter.getBigIntegerWithSuffix((String)this.offset);
                this.offsetInt = itemValue.intValue();
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.severe(MessageFormat.format("Invalid offset {0}", this.offset));
            }
        }

        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + Objects.hashCode(this.offset);
            result = 31 * result + Objects.hashCode(this.defaultItem);
            return result;
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ParameterSetting other = (ParameterSetting)obj;
            return Objects.equals(this.offset, other.offset) && Objects.equals(this.defaultItem, other.defaultItem);
        }
    }

    public static class TargetWidth
    extends ItemSetting {
    }

    @Root(name="target_width", strict=false)
    public static class TargetWidthSetting
    extends ParameterSetting {
        @ElementList(inline=true)
        private List<TargetWidth> items;

        protected TargetWidthSetting() {
            this("", "", new ArrayList<TargetWidth>());
        }

        public TargetWidthSetting(String offset, String defaultItem, List<TargetWidth> items) {
            super(offset, defaultItem);
            this.items = new ArrayList<TargetWidth>(items);
        }

        public List<TargetWidth> getItems() {
            return this.items;
        }

        public void setItems(List<TargetWidth> items) {
            this.items = items;
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + Objects.hashCode(this.items);
            return result;
        }

        @Override
        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TargetWidthSetting other = (TargetWidthSetting)obj;
            return Objects.equals(this.items, other.items);
        }
    }
}

